# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from talos_aclient.models.relation_filter_config import RelationFilterConfig
from typing import Optional, Set
from typing_extensions import Self

class GetNodeRequest(BaseModel):
    """
    根据id获name:label获取node
    """ # noqa: E501
    dataset_id: StrictStr
    resource_id: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    label_id: Optional[Annotated[str, Field(strict=True, max_length=32)]] = None
    label_name: Optional[Annotated[str, Field(strict=True, max_length=128)]] = None
    name: Optional[Annotated[str, Field(strict=True, max_length=300)]] = None
    depth: Optional[StrictInt] = 0
    relation_filter_config: Optional[RelationFilterConfig] = None
    limit: Optional[StrictInt] = Field(default=30, description="depth>1时，限制与当前点相关边的数量，小于等于0表示不限制")
    with_node_ontology: Optional[StrictBool] = Field(default=False, description="是否返回节点的本体id")
    __properties: ClassVar[List[str]] = ["dataset_id", "resource_id", "id", "label_id", "label_name", "name", "depth", "relation_filter_config", "limit", "with_node_ontology"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetNodeRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of relation_filter_config
        if self.relation_filter_config:
            _dict['relation_filter_config'] = self.relation_filter_config.to_dict()
        # set to None if resource_id (nullable) is None
        # and model_fields_set contains the field
        if self.resource_id is None and "resource_id" in self.model_fields_set:
            _dict['resource_id'] = None

        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if label_id (nullable) is None
        # and model_fields_set contains the field
        if self.label_id is None and "label_id" in self.model_fields_set:
            _dict['label_id'] = None

        # set to None if label_name (nullable) is None
        # and model_fields_set contains the field
        if self.label_name is None and "label_name" in self.model_fields_set:
            _dict['label_name'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetNodeRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dataset_id": obj.get("dataset_id"),
            "resource_id": obj.get("resource_id"),
            "id": obj.get("id"),
            "label_id": obj.get("label_id"),
            "label_name": obj.get("label_name"),
            "name": obj.get("name"),
            "depth": obj.get("depth") if obj.get("depth") is not None else 0,
            "relation_filter_config": RelationFilterConfig.from_dict(obj["relation_filter_config"]) if obj.get("relation_filter_config") is not None else None,
            "limit": obj.get("limit") if obj.get("limit") is not None else 30,
            "with_node_ontology": obj.get("with_node_ontology") if obj.get("with_node_ontology") is not None else False
        })
        return _obj


