# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from talos_aclient.models.elasticsearch_args import ElasticsearchArgs
from talos_aclient.models.graph_args import GraphArgs
from talos_aclient.models.graph_store_type import GraphStoreType
from talos_aclient.models.relational_db_config_output import RelationalDBConfigOutput
from talos_aclient.models.text_store_type import TextStoreType
from talos_aclient.models.vector_store_args import VectorStoreArgs
from talos_aclient.models.vector_store_type import VectorStoreType
from typing import Optional, Set
from typing_extensions import Self

class IndexConfigOutput(BaseModel):
    """
    IndexConfigOutput
    """ # noqa: E501
    embedding_model: Optional[StrictStr] = None
    vector_store: Optional[VectorStoreType] = None
    vector_store_args: Optional[VectorStoreArgs] = None
    text_store: Optional[TextStoreType] = None
    text_store_args: Optional[ElasticsearchArgs] = None
    graph_store: Optional[GraphStoreType] = None
    graph_args: Optional[GraphArgs] = None
    relational_db: Optional[RelationalDBConfigOutput] = None
    __properties: ClassVar[List[str]] = ["embedding_model", "vector_store", "vector_store_args", "text_store", "text_store_args", "graph_store", "graph_args", "relational_db"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IndexConfigOutput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of vector_store_args
        if self.vector_store_args:
            _dict['vector_store_args'] = self.vector_store_args.to_dict()
        # override the default output from pydantic by calling `to_dict()` of text_store_args
        if self.text_store_args:
            _dict['text_store_args'] = self.text_store_args.to_dict()
        # override the default output from pydantic by calling `to_dict()` of graph_args
        if self.graph_args:
            _dict['graph_args'] = self.graph_args.to_dict()
        # override the default output from pydantic by calling `to_dict()` of relational_db
        if self.relational_db:
            _dict['relational_db'] = self.relational_db.to_dict()
        # set to None if embedding_model (nullable) is None
        # and model_fields_set contains the field
        if self.embedding_model is None and "embedding_model" in self.model_fields_set:
            _dict['embedding_model'] = None

        # set to None if vector_store (nullable) is None
        # and model_fields_set contains the field
        if self.vector_store is None and "vector_store" in self.model_fields_set:
            _dict['vector_store'] = None

        # set to None if vector_store_args (nullable) is None
        # and model_fields_set contains the field
        if self.vector_store_args is None and "vector_store_args" in self.model_fields_set:
            _dict['vector_store_args'] = None

        # set to None if text_store (nullable) is None
        # and model_fields_set contains the field
        if self.text_store is None and "text_store" in self.model_fields_set:
            _dict['text_store'] = None

        # set to None if text_store_args (nullable) is None
        # and model_fields_set contains the field
        if self.text_store_args is None and "text_store_args" in self.model_fields_set:
            _dict['text_store_args'] = None

        # set to None if graph_store (nullable) is None
        # and model_fields_set contains the field
        if self.graph_store is None and "graph_store" in self.model_fields_set:
            _dict['graph_store'] = None

        # set to None if graph_args (nullable) is None
        # and model_fields_set contains the field
        if self.graph_args is None and "graph_args" in self.model_fields_set:
            _dict['graph_args'] = None

        # set to None if relational_db (nullable) is None
        # and model_fields_set contains the field
        if self.relational_db is None and "relational_db" in self.model_fields_set:
            _dict['relational_db'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IndexConfigOutput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "embedding_model": obj.get("embedding_model"),
            "vector_store": obj.get("vector_store"),
            "vector_store_args": VectorStoreArgs.from_dict(obj["vector_store_args"]) if obj.get("vector_store_args") is not None else None,
            "text_store": obj.get("text_store"),
            "text_store_args": ElasticsearchArgs.from_dict(obj["text_store_args"]) if obj.get("text_store_args") is not None else None,
            "graph_store": obj.get("graph_store"),
            "graph_args": GraphArgs.from_dict(obj["graph_args"]) if obj.get("graph_args") is not None else None,
            "relational_db": RelationalDBConfigOutput.from_dict(obj["relational_db"]) if obj.get("relational_db") is not None else None
        })
        return _obj


