# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from talos_aclient.models.status_filter import StatusFilter
from typing import Optional, Set
from typing_extensions import Self

class ListDatasetResourcesRequest(BaseModel):
    """
    ListDatasetResourcesRequest
    """ # noqa: E501
    dataset_id: StrictStr
    resource_ids: Optional[List[StrictStr]] = None
    keyword: Optional[StrictStr] = None
    extensions: Optional[List[StrictStr]] = None
    status: Optional[StatusFilter] = None
    graph_counted: Optional[StrictBool] = Field(default=False, description="若是图谱库，标记是否返回图谱的计数信息")
    __properties: ClassVar[List[str]] = ["dataset_id", "resource_ids", "keyword", "extensions", "status", "graph_counted"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListDatasetResourcesRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        # set to None if resource_ids (nullable) is None
        # and model_fields_set contains the field
        if self.resource_ids is None and "resource_ids" in self.model_fields_set:
            _dict['resource_ids'] = None

        # set to None if keyword (nullable) is None
        # and model_fields_set contains the field
        if self.keyword is None and "keyword" in self.model_fields_set:
            _dict['keyword'] = None

        # set to None if extensions (nullable) is None
        # and model_fields_set contains the field
        if self.extensions is None and "extensions" in self.model_fields_set:
            _dict['extensions'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListDatasetResourcesRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dataset_id": obj.get("dataset_id"),
            "resource_ids": obj.get("resource_ids"),
            "keyword": obj.get("keyword"),
            "extensions": obj.get("extensions"),
            "status": StatusFilter.from_dict(obj["status"]) if obj.get("status") is not None else None,
            "graph_counted": obj.get("graph_counted") if obj.get("graph_counted") is not None else False
        })
        return _obj


