# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from talos_aclient.models.relation_filter_config import RelationFilterConfig
from typing import Optional, Set
from typing_extensions import Self

class ListEdgeRequest(BaseModel):
    """
    ListEdgeRequest
    """ # noqa: E501
    trace_info: Optional[Dict[str, Any]] = None
    dataset_id: StrictStr
    resource_id: Optional[StrictStr] = None
    label_ids: Optional[List[StrictStr]] = None
    label_names: Optional[List[StrictStr]] = None
    keyword: Optional[StrictStr] = None
    relation_filter_config: Optional[RelationFilterConfig] = None
    with_node_ontology: Optional[StrictBool] = Field(default=False, description="是否返回节点的本体id")
    order: Optional[StrictStr] = Field(default='DESC', description="排序方式，默认按照创建时间倒序")
    __properties: ClassVar[List[str]] = ["trace_info", "dataset_id", "resource_id", "label_ids", "label_names", "keyword", "relation_filter_config", "with_node_ontology", "order"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListEdgeRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of relation_filter_config
        if self.relation_filter_config:
            _dict['relation_filter_config'] = self.relation_filter_config.to_dict()
        # set to None if trace_info (nullable) is None
        # and model_fields_set contains the field
        if self.trace_info is None and "trace_info" in self.model_fields_set:
            _dict['trace_info'] = None

        # set to None if resource_id (nullable) is None
        # and model_fields_set contains the field
        if self.resource_id is None and "resource_id" in self.model_fields_set:
            _dict['resource_id'] = None

        # set to None if label_ids (nullable) is None
        # and model_fields_set contains the field
        if self.label_ids is None and "label_ids" in self.model_fields_set:
            _dict['label_ids'] = None

        # set to None if label_names (nullable) is None
        # and model_fields_set contains the field
        if self.label_names is None and "label_names" in self.model_fields_set:
            _dict['label_names'] = None

        # set to None if keyword (nullable) is None
        # and model_fields_set contains the field
        if self.keyword is None and "keyword" in self.model_fields_set:
            _dict['keyword'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListEdgeRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "trace_info": obj.get("trace_info"),
            "dataset_id": obj.get("dataset_id"),
            "resource_id": obj.get("resource_id"),
            "label_ids": obj.get("label_ids"),
            "label_names": obj.get("label_names"),
            "keyword": obj.get("keyword"),
            "relation_filter_config": RelationFilterConfig.from_dict(obj["relation_filter_config"]) if obj.get("relation_filter_config") is not None else None,
            "with_node_ontology": obj.get("with_node_ontology") if obj.get("with_node_ontology") is not None else False,
            "order": obj.get("order") if obj.get("order") is not None else 'DESC'
        })
        return _obj


