# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from talos_aclient.models.data import Data
from talos_aclient.models.dataset_resource_index_config import DatasetResourceIndexConfig
from talos_aclient.models.parse_config_input import ParseConfigInput
from talos_aclient.models.queue_config import QueueConfig
from talos_aclient.models.resource_type import ResourceType
from typing import Optional, Set
from typing_extensions import Self

class MigrateResourceRequest(BaseModel):
    """
    MigrateResourceRequest
    """ # noqa: E501
    queue_config: Optional[QueueConfig] = None
    trace_info: Optional[Dict[str, Any]] = None
    type: ResourceType
    dry_run: Optional[StrictBool] = False
    name: StrictStr
    data: Optional[Data] = None
    parse_config: Optional[ParseConfigInput] = None
    index_config: Optional[DatasetResourceIndexConfig] = None
    async_mode: Optional[StrictBool] = True
    should_parser: Optional[StrictBool] = True
    id: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["queue_config", "trace_info", "type", "dry_run", "name", "data", "parse_config", "index_config", "async_mode", "should_parser", "id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MigrateResourceRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of queue_config
        if self.queue_config:
            _dict['queue_config'] = self.queue_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of data
        if self.data:
            _dict['data'] = self.data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of parse_config
        if self.parse_config:
            _dict['parse_config'] = self.parse_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of index_config
        if self.index_config:
            _dict['index_config'] = self.index_config.to_dict()
        # set to None if trace_info (nullable) is None
        # and model_fields_set contains the field
        if self.trace_info is None and "trace_info" in self.model_fields_set:
            _dict['trace_info'] = None

        # set to None if parse_config (nullable) is None
        # and model_fields_set contains the field
        if self.parse_config is None and "parse_config" in self.model_fields_set:
            _dict['parse_config'] = None

        # set to None if index_config (nullable) is None
        # and model_fields_set contains the field
        if self.index_config is None and "index_config" in self.model_fields_set:
            _dict['index_config'] = None

        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MigrateResourceRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "queue_config": QueueConfig.from_dict(obj["queue_config"]) if obj.get("queue_config") is not None else None,
            "trace_info": obj.get("trace_info"),
            "type": obj.get("type"),
            "dry_run": obj.get("dry_run") if obj.get("dry_run") is not None else False,
            "name": obj.get("name"),
            "data": Data.from_dict(obj["data"]) if obj.get("data") is not None else None,
            "parse_config": ParseConfigInput.from_dict(obj["parse_config"]) if obj.get("parse_config") is not None else None,
            "index_config": DatasetResourceIndexConfig.from_dict(obj["index_config"]) if obj.get("index_config") is not None else None,
            "async_mode": obj.get("async_mode") if obj.get("async_mode") is not None else True,
            "should_parser": obj.get("should_parser") if obj.get("should_parser") is not None else True,
            "id": obj.get("id")
        })
        return _obj


