# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class MilvusArgs(BaseModel):
    """
    相关性打分（similarity score）:     L2: 0 到正无穷大。数值越小，表示向量之间的相似度越高。     IP: -∞ 到 +∞。值越高，表示向量之间的相似度越高。     cosine: [-1, 1]。1 表示完全相似，0 表示无相似，-1 表示完全不相似。
    """ # noqa: E501
    metric_type: Optional[StrictStr] = 'COSINE'
    index_type: Optional[StrictStr] = 'HNSW'
    params: Optional[Dict[str, Any]] = None
    __properties: ClassVar[List[str]] = ["metric_type", "index_type", "params"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MilvusArgs from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MilvusArgs from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "metric_type": obj.get("metric_type") if obj.get("metric_type") is not None else 'COSINE',
            "index_type": obj.get("index_type") if obj.get("index_type") is not None else 'HNSW',
            "params": obj.get("params")
        })
        return _obj


