# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from talos_aclient.models.edge import Edge
from talos_aclient.models.node import Node
from typing import Optional, Set
from typing_extensions import Self

class NodeDetail(BaseModel):
    """
    NodeDetail
    """ # noqa: E501
    entry_node: Node
    outgoing_edges: Optional[List[Edge]] = None
    incoming_edges: Optional[List[Edge]] = None
    indirect_edges: Optional[List[Edge]] = None
    __properties: ClassVar[List[str]] = ["entry_node", "outgoing_edges", "incoming_edges", "indirect_edges"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NodeDetail from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of entry_node
        if self.entry_node:
            _dict['entry_node'] = self.entry_node.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in outgoing_edges (list)
        _items = []
        if self.outgoing_edges:
            for _item_outgoing_edges in self.outgoing_edges:
                if _item_outgoing_edges:
                    _items.append(_item_outgoing_edges.to_dict())
            _dict['outgoing_edges'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in incoming_edges (list)
        _items = []
        if self.incoming_edges:
            for _item_incoming_edges in self.incoming_edges:
                if _item_incoming_edges:
                    _items.append(_item_incoming_edges.to_dict())
            _dict['incoming_edges'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in indirect_edges (list)
        _items = []
        if self.indirect_edges:
            for _item_indirect_edges in self.indirect_edges:
                if _item_indirect_edges:
                    _items.append(_item_indirect_edges.to_dict())
            _dict['indirect_edges'] = _items
        # set to None if outgoing_edges (nullable) is None
        # and model_fields_set contains the field
        if self.outgoing_edges is None and "outgoing_edges" in self.model_fields_set:
            _dict['outgoing_edges'] = None

        # set to None if incoming_edges (nullable) is None
        # and model_fields_set contains the field
        if self.incoming_edges is None and "incoming_edges" in self.model_fields_set:
            _dict['incoming_edges'] = None

        # set to None if indirect_edges (nullable) is None
        # and model_fields_set contains the field
        if self.indirect_edges is None and "indirect_edges" in self.model_fields_set:
            _dict['indirect_edges'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NodeDetail from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "entry_node": Node.from_dict(obj["entry_node"]) if obj.get("entry_node") is not None else None,
            "outgoing_edges": [Edge.from_dict(_item) for _item in obj["outgoing_edges"]] if obj.get("outgoing_edges") is not None else None,
            "incoming_edges": [Edge.from_dict(_item) for _item in obj["incoming_edges"]] if obj.get("incoming_edges") is not None else None,
            "indirect_edges": [Edge.from_dict(_item) for _item in obj["indirect_edges"]] if obj.get("indirect_edges") is not None else None
        })
        return _obj


