# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from talos_aclient.models.auto_context_config import AutoContextConfig
from talos_aclient.models.clean_config import CleanConfig
from talos_aclient.models.extractor_config import ExtractorConfig
from talos_aclient.models.loader_config_output import LoaderConfigOutput
from talos_aclient.models.splitter_config import SplitterConfig
from talos_aclient.models.sync_strategy import SyncStrategy
from talos_aclient.models.task_step import TaskStep
from talos_aclient.models.transform_step import TransformStep
from typing import Optional, Set
from typing_extensions import Self

class ParseConfigOutput(BaseModel):
    """
    ParseConfigOutput
    """ # noqa: E501
    clean_config: Optional[CleanConfig] = None
    splitter_config: Optional[SplitterConfig] = None
    loader_config: Optional[LoaderConfigOutput] = None
    extractor_config: Optional[ExtractorConfig] = None
    auto_context_config: Optional[AutoContextConfig] = None
    embedding_model: Optional[StrictStr] = None
    steps: Optional[List[TaskStep]] = None
    transform_steps: Optional[List[TransformStep]] = None
    sync_strategy: Optional[SyncStrategy] = None
    __properties: ClassVar[List[str]] = ["clean_config", "splitter_config", "loader_config", "extractor_config", "auto_context_config", "embedding_model", "steps", "transform_steps", "sync_strategy"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ParseConfigOutput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of clean_config
        if self.clean_config:
            _dict['clean_config'] = self.clean_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of splitter_config
        if self.splitter_config:
            _dict['splitter_config'] = self.splitter_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of loader_config
        if self.loader_config:
            _dict['loader_config'] = self.loader_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of extractor_config
        if self.extractor_config:
            _dict['extractor_config'] = self.extractor_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of auto_context_config
        if self.auto_context_config:
            _dict['auto_context_config'] = self.auto_context_config.to_dict()
        # set to None if embedding_model (nullable) is None
        # and model_fields_set contains the field
        if self.embedding_model is None and "embedding_model" in self.model_fields_set:
            _dict['embedding_model'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ParseConfigOutput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "clean_config": CleanConfig.from_dict(obj["clean_config"]) if obj.get("clean_config") is not None else None,
            "splitter_config": SplitterConfig.from_dict(obj["splitter_config"]) if obj.get("splitter_config") is not None else None,
            "loader_config": LoaderConfigOutput.from_dict(obj["loader_config"]) if obj.get("loader_config") is not None else None,
            "extractor_config": ExtractorConfig.from_dict(obj["extractor_config"]) if obj.get("extractor_config") is not None else None,
            "auto_context_config": AutoContextConfig.from_dict(obj["auto_context_config"]) if obj.get("auto_context_config") is not None else None,
            "embedding_model": obj.get("embedding_model"),
            "steps": obj.get("steps"),
            "transform_steps": obj.get("transform_steps"),
            "sync_strategy": obj.get("sync_strategy")
        })
        return _obj


