# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from talos_aclient.models.format import Format
from talos_aclient.models.structure_sheet import StructureSheet
from typing import Optional, Set
from typing_extensions import Self

class ParseStructureConfigOutput(BaseModel):
    """
    ParseStructureConfigOutput
    """ # noqa: E501
    segment_format: Optional[Format] = None
    sheets: Optional[List[StructureSheet]] = None
    segment_row_span: Optional[Annotated[int, Field(strict=True, ge=1)]] = 1
    __properties: ClassVar[List[str]] = ["segment_format", "sheets", "segment_row_span"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ParseStructureConfigOutput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in sheets (list)
        _items = []
        if self.sheets:
            for _item_sheets in self.sheets:
                if _item_sheets:
                    _items.append(_item_sheets.to_dict())
            _dict['sheets'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ParseStructureConfigOutput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "segment_format": obj.get("segment_format"),
            "sheets": [StructureSheet.from_dict(_item) for _item in obj["sheets"]] if obj.get("sheets") is not None else None,
            "segment_row_span": obj.get("segment_row_span") if obj.get("segment_row_span") is not None else 1
        })
        return _obj


