# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from talos_aclient.models.app_talos_schema_resource_graph_metadata import AppTalosSchemaResourceGraphMetadata
from talos_aclient.models.task_status import TaskStatus
from typing import Optional, Set
from typing_extensions import Self

class Resource(BaseModel):
    """
    Resource
    """ # noqa: E501
    id: StrictStr
    size: Optional[StrictInt] = 0
    metadata: Optional[Dict[str, Any]] = None
    name: Optional[StrictStr] = None
    progress: Optional[StrictInt] = 0
    status: Optional[TaskStatus] = None
    storage_url: Optional[StrictStr] = ''
    storage_type: Optional[StrictStr] = None
    type: Optional[StrictStr] = ''
    extension: Optional[StrictStr] = ''
    document_meta: Optional[Dict[str, Any]] = None
    graph_metadata: Optional[AppTalosSchemaResourceGraphMetadata] = None
    error_message: Optional[StrictStr] = ''
    segment_count: Optional[StrictInt] = 0
    create_time: Optional[datetime] = None
    truncated_count: Optional[StrictInt] = 0
    update_time: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["id", "size", "metadata", "name", "progress", "status", "storage_url", "storage_type", "type", "extension", "document_meta", "graph_metadata", "error_message", "segment_count", "create_time", "truncated_count", "update_time"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Resource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of graph_metadata
        if self.graph_metadata:
            _dict['graph_metadata'] = self.graph_metadata.to_dict()
        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if storage_type (nullable) is None
        # and model_fields_set contains the field
        if self.storage_type is None and "storage_type" in self.model_fields_set:
            _dict['storage_type'] = None

        # set to None if document_meta (nullable) is None
        # and model_fields_set contains the field
        if self.document_meta is None and "document_meta" in self.model_fields_set:
            _dict['document_meta'] = None

        # set to None if graph_metadata (nullable) is None
        # and model_fields_set contains the field
        if self.graph_metadata is None and "graph_metadata" in self.model_fields_set:
            _dict['graph_metadata'] = None

        # set to None if create_time (nullable) is None
        # and model_fields_set contains the field
        if self.create_time is None and "create_time" in self.model_fields_set:
            _dict['create_time'] = None

        # set to None if update_time (nullable) is None
        # and model_fields_set contains the field
        if self.update_time is None and "update_time" in self.model_fields_set:
            _dict['update_time'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Resource from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "size": obj.get("size") if obj.get("size") is not None else 0,
            "metadata": obj.get("metadata"),
            "name": obj.get("name"),
            "progress": obj.get("progress") if obj.get("progress") is not None else 0,
            "status": obj.get("status"),
            "storage_url": obj.get("storage_url") if obj.get("storage_url") is not None else '',
            "storage_type": obj.get("storage_type"),
            "type": obj.get("type") if obj.get("type") is not None else '',
            "extension": obj.get("extension") if obj.get("extension") is not None else '',
            "document_meta": obj.get("document_meta"),
            "graph_metadata": AppTalosSchemaResourceGraphMetadata.from_dict(obj["graph_metadata"]) if obj.get("graph_metadata") is not None else None,
            "error_message": obj.get("error_message") if obj.get("error_message") is not None else '',
            "segment_count": obj.get("segment_count") if obj.get("segment_count") is not None else 0,
            "create_time": obj.get("create_time"),
            "truncated_count": obj.get("truncated_count") if obj.get("truncated_count") is not None else 0,
            "update_time": obj.get("update_time")
        })
        return _obj


