# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from talos_aclient.models.storage_type import StorageType
from talos_aclient.models.storage_url_property import StorageURLProperty
from typing import Optional, Set
from typing_extensions import Self

class ResourceDataTable(BaseModel):
    """
    ResourceDataTable
    """ # noqa: E501
    storage_type: Optional[StorageType] = None
    storage_url: StorageURLProperty
    sheet: StrictStr
    header_row: Annotated[int, Field(strict=True, ge=1)]
    value_starting_row: Annotated[int, Field(strict=True, ge=2)]
    __properties: ClassVar[List[str]] = ["storage_type", "storage_url", "sheet", "header_row", "value_starting_row"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ResourceDataTable from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of storage_url
        if self.storage_url:
            _dict['storage_url'] = self.storage_url.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ResourceDataTable from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "storage_type": obj.get("storage_type"),
            "storage_url": StorageURLProperty.from_dict(obj["storage_url"]) if obj.get("storage_url") is not None else None,
            "sheet": obj.get("sheet"),
            "header_row": obj.get("header_row"),
            "value_starting_row": obj.get("value_starting_row")
        })
        return _obj


