# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from talos_aclient.models.retrieve_args import RetrieveArgs
from talos_aclient.models.retrieve_search_type import RetrieveSearchType
from talos_aclient.models.retrieve_type import RetrieveType
from typing import Optional, Set
from typing_extensions import Self

class RetrieveSegmentsRequest(BaseModel):
    """
    RetrieveSegmentsRequest
    """ # noqa: E501
    trace_info: Optional[Dict[str, Any]] = None
    query: Annotated[str, Field(min_length=1, strict=True)]
    dataset_ids: Optional[List[StrictStr]] = None
    search_type: Optional[RetrieveSearchType] = None
    limit: Optional[Annotated[int, Field(le=100, strict=True, ge=1)]] = 10
    resource_id: Optional[StrictStr] = ''
    retrieve_type: Optional[RetrieveType] = None
    retrieve_args: Optional[RetrieveArgs] = Field(default=None, description="RetrieveSearchType=SIMILARITY时设置")
    auto_add_hit: Optional[StrictBool] = Field(default=False, description="是否自动添加hit")
    metadata_filter: Optional[Dict[str, Dict[str, StrictStr]]] = None
    resource_filter: Optional[Dict[str, List[StrictStr]]] = None
    __properties: ClassVar[List[str]] = ["trace_info", "query", "dataset_ids", "search_type", "limit", "resource_id", "retrieve_type", "retrieve_args", "auto_add_hit", "metadata_filter", "resource_filter"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RetrieveSegmentsRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of retrieve_args
        if self.retrieve_args:
            _dict['retrieve_args'] = self.retrieve_args.to_dict()
        # set to None if trace_info (nullable) is None
        # and model_fields_set contains the field
        if self.trace_info is None and "trace_info" in self.model_fields_set:
            _dict['trace_info'] = None

        # set to None if metadata_filter (nullable) is None
        # and model_fields_set contains the field
        if self.metadata_filter is None and "metadata_filter" in self.model_fields_set:
            _dict['metadata_filter'] = None

        # set to None if resource_filter (nullable) is None
        # and model_fields_set contains the field
        if self.resource_filter is None and "resource_filter" in self.model_fields_set:
            _dict['resource_filter'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RetrieveSegmentsRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "trace_info": obj.get("trace_info"),
            "query": obj.get("query"),
            "dataset_ids": obj.get("dataset_ids"),
            "search_type": obj.get("search_type"),
            "limit": obj.get("limit") if obj.get("limit") is not None else 10,
            "resource_id": obj.get("resource_id") if obj.get("resource_id") is not None else '',
            "retrieve_type": obj.get("retrieve_type"),
            "retrieve_args": RetrieveArgs.from_dict(obj["retrieve_args"]) if obj.get("retrieve_args") is not None else None,
            "auto_add_hit": obj.get("auto_add_hit") if obj.get("auto_add_hit") is not None else False,
            "metadata_filter": obj.get("metadata_filter"),
            "resource_filter": obj.get("resource_filter")
        })
        return _obj


