# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from talos_aclient.models.metadata_filter import MetadataFilter
from talos_aclient.models.retrieve_segment import RetrieveSegment
from typing import Optional, Set
from typing_extensions import Self

class RetrieveSegmentsResponse(BaseModel):
    """
    RetrieveSegmentsResponse
    """ # noqa: E501
    code: Optional[StrictInt] = 200
    detail: Optional[StrictStr] = '请求成功'
    data: List[RetrieveSegment]
    metadata_filters: Optional[List[MetadataFilter]] = None
    __properties: ClassVar[List[str]] = ["code", "detail", "data", "metadata_filters"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RetrieveSegmentsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in data (list)
        _items = []
        if self.data:
            for _item_data in self.data:
                if _item_data:
                    _items.append(_item_data.to_dict())
            _dict['data'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in metadata_filters (list)
        _items = []
        if self.metadata_filters:
            for _item_metadata_filters in self.metadata_filters:
                if _item_metadata_filters:
                    _items.append(_item_metadata_filters.to_dict())
            _dict['metadata_filters'] = _items
        # set to None if metadata_filters (nullable) is None
        # and model_fields_set contains the field
        if self.metadata_filters is None and "metadata_filters" in self.model_fields_set:
            _dict['metadata_filters'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RetrieveSegmentsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "code": obj.get("code") if obj.get("code") is not None else 200,
            "detail": obj.get("detail") if obj.get("detail") is not None else '请求成功',
            "data": [RetrieveSegment.from_dict(_item) for _item in obj["data"]] if obj.get("data") is not None else None,
            "metadata_filters": [MetadataFilter.from_dict(_item) for _item in obj["metadata_filters"]] if obj.get("metadata_filters") is not None else None
        })
        return _obj


