# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from talos_aclient.models.segment_metadata import SegmentMetadata
from talos_aclient.models.status_type import StatusType
from typing import Optional, Set
from typing_extensions import Self

class Segment(BaseModel):
    """
    Segment
    """ # noqa: E501
    id: StrictStr
    position: Optional[StrictInt] = 0
    document_id: StrictStr
    content: StrictStr
    size: Optional[StrictInt] = 0
    hit_count: Optional[StrictInt] = Field(default=0, description="命中次数")
    enabled: Optional[StrictBool] = Field(default=True, description="是否启用")
    truncated: Optional[StrictBool] = Field(default=False, description="是否截断")
    metadata: Optional[SegmentMetadata] = None
    source: Optional[StrictInt] = 0
    status: Optional[StatusType] = None
    create_time: Optional[datetime] = None
    update_time: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["id", "position", "document_id", "content", "size", "hit_count", "enabled", "truncated", "metadata", "source", "status", "create_time", "update_time"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Segment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        # set to None if create_time (nullable) is None
        # and model_fields_set contains the field
        if self.create_time is None and "create_time" in self.model_fields_set:
            _dict['create_time'] = None

        # set to None if update_time (nullable) is None
        # and model_fields_set contains the field
        if self.update_time is None and "update_time" in self.model_fields_set:
            _dict['update_time'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Segment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "position": obj.get("position") if obj.get("position") is not None else 0,
            "document_id": obj.get("document_id"),
            "content": obj.get("content"),
            "size": obj.get("size") if obj.get("size") is not None else 0,
            "hit_count": obj.get("hit_count") if obj.get("hit_count") is not None else 0,
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "truncated": obj.get("truncated") if obj.get("truncated") is not None else False,
            "metadata": SegmentMetadata.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "source": obj.get("source") if obj.get("source") is not None else 0,
            "status": obj.get("status"),
            "create_time": obj.get("create_time"),
            "update_time": obj.get("update_time")
        })
        return _obj


