# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from talos_aclient.models.document_metadata import DocumentMetadata
from talos_aclient.models.position import Position
from typing import Optional, Set
from typing_extensions import Self

class SegmentMetadata(BaseModel):
    """
    SegmentMetadata
    """ # noqa: E501
    position: Optional[StrictInt] = 0
    document_id: Optional[StrictStr] = ''
    file_id: Optional[StrictStr] = ''
    doc_id: Optional[StrictStr] = ''
    doc_hash: Optional[StrictStr] = ''
    from_: Optional[StrictStr] = 'raw'
    document_meta: Optional[DocumentMetadata] = None
    paper_section: Optional[StrictStr] = None
    areas: Optional[List[Position]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["position", "document_id", "file_id", "doc_id", "doc_hash", "from_", "document_meta", "paper_section", "areas"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SegmentMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of document_meta
        if self.document_meta:
            _dict['document_meta'] = self.document_meta.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in areas (list)
        _items = []
        if self.areas:
            for _item_areas in self.areas:
                if _item_areas:
                    _items.append(_item_areas.to_dict())
            _dict['areas'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if document_meta (nullable) is None
        # and model_fields_set contains the field
        if self.document_meta is None and "document_meta" in self.model_fields_set:
            _dict['document_meta'] = None

        # set to None if paper_section (nullable) is None
        # and model_fields_set contains the field
        if self.paper_section is None and "paper_section" in self.model_fields_set:
            _dict['paper_section'] = None

        # set to None if areas (nullable) is None
        # and model_fields_set contains the field
        if self.areas is None and "areas" in self.model_fields_set:
            _dict['areas'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SegmentMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "position": obj.get("position") if obj.get("position") is not None else 0,
            "document_id": obj.get("document_id") if obj.get("document_id") is not None else '',
            "file_id": obj.get("file_id") if obj.get("file_id") is not None else '',
            "doc_id": obj.get("doc_id") if obj.get("doc_id") is not None else '',
            "doc_hash": obj.get("doc_hash") if obj.get("doc_hash") is not None else '',
            "from_": obj.get("from_") if obj.get("from_") is not None else 'raw',
            "document_meta": DocumentMetadata.from_dict(obj["document_meta"]) if obj.get("document_meta") is not None else None,
            "paper_section": obj.get("paper_section"),
            "areas": [Position.from_dict(_item) for _item in obj["areas"]] if obj.get("areas") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


