# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from talos_aclient.models.http_method import HTTPMethod
from talos_aclient.models.pagination_config import PaginationConfig
from talos_aclient.models.url_authentication import URLAuthentication
from typing import Optional, Set
from typing_extensions import Self

class StorageURLProperty(BaseModel):
    """
    StorageURLProperty
    """ # noqa: E501
    url: StrictStr
    cron: Optional[StrictStr] = None
    method: Optional[HTTPMethod] = None
    authentication: Optional[URLAuthentication] = None
    header: Optional[Dict[str, StrictStr]] = None
    body: Optional[Dict[str, Any]] = None
    pagination: Optional[PaginationConfig] = None
    __properties: ClassVar[List[str]] = ["url", "cron", "method", "authentication", "header", "body", "pagination"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StorageURLProperty from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of authentication
        if self.authentication:
            _dict['authentication'] = self.authentication.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pagination
        if self.pagination:
            _dict['pagination'] = self.pagination.to_dict()
        # set to None if cron (nullable) is None
        # and model_fields_set contains the field
        if self.cron is None and "cron" in self.model_fields_set:
            _dict['cron'] = None

        # set to None if authentication (nullable) is None
        # and model_fields_set contains the field
        if self.authentication is None and "authentication" in self.model_fields_set:
            _dict['authentication'] = None

        # set to None if pagination (nullable) is None
        # and model_fields_set contains the field
        if self.pagination is None and "pagination" in self.model_fields_set:
            _dict['pagination'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StorageURLProperty from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "url": obj.get("url"),
            "cron": obj.get("cron"),
            "method": obj.get("method"),
            "authentication": URLAuthentication.from_dict(obj["authentication"]) if obj.get("authentication") is not None else None,
            "header": obj.get("header"),
            "body": obj.get("body"),
            "pagination": PaginationConfig.from_dict(obj["pagination"]) if obj.get("pagination") is not None else None
        })
        return _obj


