# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from talos_aclient.models.resource_info import ResourceInfo
from talos_aclient.models.task_status_info import TaskStatusInfo
from typing import Optional, Set
from typing_extensions import Self

class TaskData(BaseModel):
    """
    TaskData
    """ # noqa: E501
    document_id: StrictStr
    status: TaskStatusInfo
    resources: Optional[List[ResourceInfo]] = None
    merged_node_count: Optional[StrictInt] = None
    merged_relation_count: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["document_id", "status", "resources", "merged_node_count", "merged_relation_count"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TaskData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in resources (list)
        _items = []
        if self.resources:
            for _item_resources in self.resources:
                if _item_resources:
                    _items.append(_item_resources.to_dict())
            _dict['resources'] = _items
        # set to None if resources (nullable) is None
        # and model_fields_set contains the field
        if self.resources is None and "resources" in self.model_fields_set:
            _dict['resources'] = None

        # set to None if merged_node_count (nullable) is None
        # and model_fields_set contains the field
        if self.merged_node_count is None and "merged_node_count" in self.model_fields_set:
            _dict['merged_node_count'] = None

        # set to None if merged_relation_count (nullable) is None
        # and model_fields_set contains the field
        if self.merged_relation_count is None and "merged_relation_count" in self.model_fields_set:
            _dict['merged_relation_count'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TaskData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "document_id": obj.get("document_id"),
            "status": TaskStatusInfo.from_dict(obj["status"]) if obj.get("status") is not None else None,
            "resources": [ResourceInfo.from_dict(_item) for _item in obj["resources"]] if obj.get("resources") is not None else None,
            "merged_node_count": obj.get("merged_node_count"),
            "merged_relation_count": obj.get("merged_relation_count")
        })
        return _obj


