# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from talos_aclient.models.parse_config_input import ParseConfigInput
from talos_aclient.models.update_resource_metadata import UpdateResourceMetadata
from typing import Optional, Set
from typing_extensions import Self

class UpdateDatasetResourceRequest(BaseModel):
    """
    UpdateDatasetResourceRequest
    """ # noqa: E501
    trace_info: Optional[Dict[str, Any]] = None
    dataset_id: StrictStr
    resource_id: StrictStr
    name: StrictStr
    parse_config: Optional[ParseConfigInput] = None
    metadata: Optional[UpdateResourceMetadata] = None
    async_mode: Optional[StrictBool] = True
    __properties: ClassVar[List[str]] = ["trace_info", "dataset_id", "resource_id", "name", "parse_config", "metadata", "async_mode"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateDatasetResourceRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of parse_config
        if self.parse_config:
            _dict['parse_config'] = self.parse_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        # set to None if trace_info (nullable) is None
        # and model_fields_set contains the field
        if self.trace_info is None and "trace_info" in self.model_fields_set:
            _dict['trace_info'] = None

        # set to None if parse_config (nullable) is None
        # and model_fields_set contains the field
        if self.parse_config is None and "parse_config" in self.model_fields_set:
            _dict['parse_config'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateDatasetResourceRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "trace_info": obj.get("trace_info"),
            "dataset_id": obj.get("dataset_id"),
            "resource_id": obj.get("resource_id"),
            "name": obj.get("name"),
            "parse_config": ParseConfigInput.from_dict(obj["parse_config"]) if obj.get("parse_config") is not None else None,
            "metadata": UpdateResourceMetadata.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "async_mode": obj.get("async_mode") if obj.get("async_mode") is not None else True
        })
        return _obj


