# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class UpdateSegmentRequest(BaseModel):
    """
    UpdateSegmentRequest
    """ # noqa: E501
    dataset_id: Optional[Annotated[str, Field(min_length=1, strict=True)]] = 'dataset-default'
    resource_id: Annotated[str, Field(min_length=1, strict=True)]
    segment_id: Annotated[str, Field(min_length=1, strict=True)]
    segment_content: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    truncated: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["dataset_id", "resource_id", "segment_id", "segment_content", "enabled", "truncated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateSegmentRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if segment_content (nullable) is None
        # and model_fields_set contains the field
        if self.segment_content is None and "segment_content" in self.model_fields_set:
            _dict['segment_content'] = None

        # set to None if enabled (nullable) is None
        # and model_fields_set contains the field
        if self.enabled is None and "enabled" in self.model_fields_set:
            _dict['enabled'] = None

        # set to None if truncated (nullable) is None
        # and model_fields_set contains the field
        if self.truncated is None and "truncated" in self.model_fields_set:
            _dict['truncated'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateSegmentRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dataset_id": obj.get("dataset_id") if obj.get("dataset_id") is not None else 'dataset-default',
            "resource_id": obj.get("resource_id"),
            "segment_id": obj.get("segment_id"),
            "segment_content": obj.get("segment_content"),
            "enabled": obj.get("enabled"),
            "truncated": obj.get("truncated")
        })
        return _obj


