# coding: utf-8

"""
    Talos

    FastAPI Best Architecture

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from talos_aclient.models.document_metadata import DocumentMetadata
from talos_aclient.models.position import Position
from typing import Optional, Set
from typing_extensions import Self

class VectorMetadataValueObject(BaseModel):
    """
    VectorMetadataValueObject
    """ # noqa: E501
    dataset_id: Optional[StrictStr] = ''
    file_id: Optional[StrictStr] = ''
    document_id: Optional[StrictStr] = ''
    position: Optional[StrictInt] = 0
    enable: Optional[StrictBool] = True
    doc_id: Optional[StrictStr] = ''
    doc_hash: Optional[StrictStr] = ''
    document_meta: Optional[DocumentMetadata] = None
    relevance_score: Optional[Union[StrictFloat, StrictInt]] = None
    areas: Optional[List[Position]] = None
    __properties: ClassVar[List[str]] = ["dataset_id", "file_id", "document_id", "position", "enable", "doc_id", "doc_hash", "document_meta", "relevance_score", "areas"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of VectorMetadataValueObject from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of document_meta
        if self.document_meta:
            _dict['document_meta'] = self.document_meta.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in areas (list)
        _items = []
        if self.areas:
            for _item_areas in self.areas:
                if _item_areas:
                    _items.append(_item_areas.to_dict())
            _dict['areas'] = _items
        # set to None if document_meta (nullable) is None
        # and model_fields_set contains the field
        if self.document_meta is None and "document_meta" in self.model_fields_set:
            _dict['document_meta'] = None

        # set to None if relevance_score (nullable) is None
        # and model_fields_set contains the field
        if self.relevance_score is None and "relevance_score" in self.model_fields_set:
            _dict['relevance_score'] = None

        # set to None if areas (nullable) is None
        # and model_fields_set contains the field
        if self.areas is None and "areas" in self.model_fields_set:
            _dict['areas'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of VectorMetadataValueObject from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dataset_id": obj.get("dataset_id") if obj.get("dataset_id") is not None else '',
            "file_id": obj.get("file_id") if obj.get("file_id") is not None else '',
            "document_id": obj.get("document_id") if obj.get("document_id") is not None else '',
            "position": obj.get("position") if obj.get("position") is not None else 0,
            "enable": obj.get("enable") if obj.get("enable") is not None else True,
            "doc_id": obj.get("doc_id") if obj.get("doc_id") is not None else '',
            "doc_hash": obj.get("doc_hash") if obj.get("doc_hash") is not None else '',
            "document_meta": DocumentMetadata.from_dict(obj["document_meta"]) if obj.get("document_meta") is not None else None,
            "relevance_score": obj.get("relevance_score"),
            "areas": [Position.from_dict(_item) for _item in obj["areas"]] if obj.get("areas") is not None else None
        })
        return _obj


