"""Custom Plotly Colorscales."""

DEFAULT_PLOTLY_COLORS = [
    '#1f77b4',  # muted blue
    '#ff7f0e',  # safety orange
    '#2ca02c',  # cooked asparagus green
    '#d62728',  # brick red
    '#9467bd',  # muted purple
    '#8c564b',  # chestnut brown
    '#e377c2',  # raspberry yogurt pink
    '#7f7f7f',  # middle gray
    '#bcbd22',  # curry yellow-green
    '#17becf',  # blue-teal
]
"""List of default Plotly colors in Hex strings."""

DEFAULT_PLOTLY_COLORS_RGB = [
    'rgb(31,119,180)',   # 0
    'rgb(255,127,14)',   # 1
    'rgb(44,160,44)',    # 2
    'rgb(214,39,40)',    # 3
    'rgb(148,103,189)',  # 4
    'rgb(140,86,75)',    # 5
    'rgb(227,119,194)',  # 6
    'rgb(127,127,127)',  # 7
    'rgb(188,189,34)',   # 8
    'rgb(23,190,207)',   # 9
]
"""List of default Plotly colors in RGB strings."""

# From SF Example: (#fdae61, #abd9e9, #2c7bb6)

# Plotly Colors:
# ['Blackbody', 'Blackbody_r', 'Bluered', 'Bluered_r', 'Blues', 'Blues_r', 'Cividis', 'Cividis_r', 'Earth', 'Earth_r',
#  'Electric', 'Electric_r', 'Greens', 'Greens_r', 'Greys', 'Greys_r', 'Hot', 'Hot_r', 'Jet', 'Jet_r', 'Picnic',
#  'Picnic_r', 'Portland', 'Portland_r', 'Rainbow', 'Rainbow_r', 'RdBu', 'RdBu_r', 'Reds', 'Reds_r', 'Viridis',
#  'Viridis_r', 'YlGnBu', 'YlGnBu_r', 'YlOrRd', 'YlOrRd_r', 'scale_name', 'scale_name_r', 'scale_pairs',
#  'scale_pairs_r', 'scale_sequence', 'scale_sequence_r']
# plotly.colors.plotlyjs.Hot / `[rgb(0,0,0), rgb(230,0,0), rgb(255,210,0), rgb(255,255,255)]`
