# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['SshCertificateArgs', 'SshCertificate']

@pulumi.input_type
class SshCertificateArgs:
    def __init__(__self__, *,
                 key_id: pulumi.Input[str],
                 template: pulumi.Input[str],
                 destination_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 folder: Optional[pulumi.Input[str]] = None,
                 force_command: Optional[pulumi.Input[str]] = None,
                 key_passphrase: Optional[pulumi.Input[str]] = None,
                 key_size: Optional[pulumi.Input[int]] = None,
                 object_name: Optional[pulumi.Input[str]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 public_key_method: Optional[pulumi.Input[str]] = None,
                 source_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 valid_hours: Optional[pulumi.Input[int]] = None,
                 windows: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a SshCertificate resource.
        :param pulumi.Input[str] key_id: The identifier of the requested SSH certificate.
        :param pulumi.Input[str] template: The SSH certificate issuing template.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_addresses: A list of one or more valid IP or CIDR destination hosts where the certificate will authenticate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] extensions: A list of key-value pairs that contain certificate extensions from the CA template for client certificates. Allowed values (case-sensitive): *permit-X11-forwarding, permit-agent-forwarding, permit-port-forwarding, permit-pty, permit-user-rc*
        :param pulumi.Input[str] folder: The DN of the policy folder where the SSH certificate object will be created.
        :param pulumi.Input[str] force_command: A command to run after successful login.
        :param pulumi.Input[str] key_passphrase: Passphrase for encrypting the private key.
        :param pulumi.Input[int] key_size: Number of bits to use when creating a key pair. (e.g. 3072)
        :param pulumi.Input[str] object_name: The friendly name of the SSH certificate object. When not specified the `key_id` is used for the friendly name. If the object already exists the old certificate is archived and the CA issues a new certificate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] principals: A list of user names for whom the requested certificate will be valid.
        :param pulumi.Input[str] public_key: The OpenSSH formatted public key that will be used to generate the SSH certificate.
        :param pulumi.Input[str] public_key_method: Specifies whether the public key will be "local" (default), "file" or "service" generated.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_addresses: A list of one or more valid IP or CIDR addresses that can use the SSH certificate.
        :param pulumi.Input[int] valid_hours: Desired number of hours for which the certificate will be valid.
        :param pulumi.Input[bool] windows: Specifies whether the private key will use Windows/DOS style line breaks.
        """
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "template", template)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if force_command is not None:
            pulumi.set(__self__, "force_command", force_command)
        if key_passphrase is not None:
            pulumi.set(__self__, "key_passphrase", key_passphrase)
        if key_size is not None:
            pulumi.set(__self__, "key_size", key_size)
        if object_name is not None:
            pulumi.set(__self__, "object_name", object_name)
        if principals is not None:
            pulumi.set(__self__, "principals", principals)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if public_key_method is not None:
            pulumi.set(__self__, "public_key_method", public_key_method)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if valid_hours is not None:
            pulumi.set(__self__, "valid_hours", valid_hours)
        if windows is not None:
            pulumi.set(__self__, "windows", windows)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Input[str]:
        """
        The identifier of the requested SSH certificate.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter
    def template(self) -> pulumi.Input[str]:
        """
        The SSH certificate issuing template.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: pulumi.Input[str]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of one or more valid IP or CIDR destination hosts where the certificate will authenticate.
        """
        return pulumi.get(self, "destination_addresses")

    @destination_addresses.setter
    def destination_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_addresses", value)

    @property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of key-value pairs that contain certificate extensions from the CA template for client certificates. Allowed values (case-sensitive): *permit-X11-forwarding, permit-agent-forwarding, permit-port-forwarding, permit-pty, permit-user-rc*
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "extensions", value)

    @property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[str]]:
        """
        The DN of the policy folder where the SSH certificate object will be created.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder", value)

    @property
    @pulumi.getter(name="forceCommand")
    def force_command(self) -> Optional[pulumi.Input[str]]:
        """
        A command to run after successful login.
        """
        return pulumi.get(self, "force_command")

    @force_command.setter
    def force_command(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "force_command", value)

    @property
    @pulumi.getter(name="keyPassphrase")
    def key_passphrase(self) -> Optional[pulumi.Input[str]]:
        """
        Passphrase for encrypting the private key.
        """
        return pulumi.get(self, "key_passphrase")

    @key_passphrase.setter
    def key_passphrase(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_passphrase", value)

    @property
    @pulumi.getter(name="keySize")
    def key_size(self) -> Optional[pulumi.Input[int]]:
        """
        Number of bits to use when creating a key pair. (e.g. 3072)
        """
        return pulumi.get(self, "key_size")

    @key_size.setter
    def key_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "key_size", value)

    @property
    @pulumi.getter(name="objectName")
    def object_name(self) -> Optional[pulumi.Input[str]]:
        """
        The friendly name of the SSH certificate object. When not specified the `key_id` is used for the friendly name. If the object already exists the old certificate is archived and the CA issues a new certificate.
        """
        return pulumi.get(self, "object_name")

    @object_name.setter
    def object_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_name", value)

    @property
    @pulumi.getter
    def principals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of user names for whom the requested certificate will be valid.
        """
        return pulumi.get(self, "principals")

    @principals.setter
    def principals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "principals", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        The OpenSSH formatted public key that will be used to generate the SSH certificate.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter(name="publicKeyMethod")
    def public_key_method(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the public key will be "local" (default), "file" or "service" generated.
        """
        return pulumi.get(self, "public_key_method")

    @public_key_method.setter
    def public_key_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key_method", value)

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of one or more valid IP or CIDR addresses that can use the SSH certificate.
        """
        return pulumi.get(self, "source_addresses")

    @source_addresses.setter
    def source_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_addresses", value)

    @property
    @pulumi.getter(name="validHours")
    def valid_hours(self) -> Optional[pulumi.Input[int]]:
        """
        Desired number of hours for which the certificate will be valid.
        """
        return pulumi.get(self, "valid_hours")

    @valid_hours.setter
    def valid_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "valid_hours", value)

    @property
    @pulumi.getter
    def windows(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the private key will use Windows/DOS style line breaks.
        """
        return pulumi.get(self, "windows")

    @windows.setter
    def windows(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "windows", value)


@pulumi.input_type
class _SshCertificateState:
    def __init__(__self__, *,
                 certificate: Optional[pulumi.Input[str]] = None,
                 certificate_type: Optional[pulumi.Input[str]] = None,
                 destination_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 folder: Optional[pulumi.Input[str]] = None,
                 force_command: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 key_passphrase: Optional[pulumi.Input[str]] = None,
                 key_size: Optional[pulumi.Input[int]] = None,
                 object_name: Optional[pulumi.Input[str]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 public_key_fingerprint: Optional[pulumi.Input[str]] = None,
                 public_key_method: Optional[pulumi.Input[str]] = None,
                 serial: Optional[pulumi.Input[str]] = None,
                 signing_ca: Optional[pulumi.Input[str]] = None,
                 source_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 template: Optional[pulumi.Input[str]] = None,
                 valid_from: Optional[pulumi.Input[str]] = None,
                 valid_hours: Optional[pulumi.Input[int]] = None,
                 valid_to: Optional[pulumi.Input[str]] = None,
                 windows: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering SshCertificate resources.
        :param pulumi.Input[str] certificate: The issued SSH certificate.
        :param pulumi.Input[str] certificate_type: Indicates whether the SSH certificate is for client or server authentication.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_addresses: A list of one or more valid IP or CIDR destination hosts where the certificate will authenticate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] extensions: A list of key-value pairs that contain certificate extensions from the CA template for client certificates. Allowed values (case-sensitive): *permit-X11-forwarding, permit-agent-forwarding, permit-port-forwarding, permit-pty, permit-user-rc*
        :param pulumi.Input[str] folder: The DN of the policy folder where the SSH certificate object will be created.
        :param pulumi.Input[str] force_command: A command to run after successful login.
        :param pulumi.Input[str] key_id: The identifier of the requested SSH certificate.
        :param pulumi.Input[str] key_passphrase: Passphrase for encrypting the private key.
        :param pulumi.Input[int] key_size: Number of bits to use when creating a key pair. (e.g. 3072)
        :param pulumi.Input[str] object_name: The friendly name of the SSH certificate object. When not specified the `key_id` is used for the friendly name. If the object already exists the old certificate is archived and the CA issues a new certificate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] principals: A list of user names for whom the requested certificate will be valid.
        :param pulumi.Input[str] private_key: The private key for the SSH certificate if generated by Venafi.
        :param pulumi.Input[str] public_key: The OpenSSH formatted public key that will be used to generate the SSH certificate.
        :param pulumi.Input[str] public_key_fingerprint: The SHA256 fingerprint of the SSH certificate's public key.
        :param pulumi.Input[str] public_key_method: Specifies whether the public key will be "local" (default), "file" or "service" generated.
        :param pulumi.Input[str] serial: The serial number of the SSH certificate.
        :param pulumi.Input[str] signing_ca: The SHA256 fingerprint of the CA that signed the SSH certificate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_addresses: A list of one or more valid IP or CIDR addresses that can use the SSH certificate.
        :param pulumi.Input[str] template: The SSH certificate issuing template.
        :param pulumi.Input[str] valid_from: The date the SSH certificate was issued.
        :param pulumi.Input[int] valid_hours: Desired number of hours for which the certificate will be valid.
        :param pulumi.Input[str] valid_to: The date the SSH certificate will expire.
        :param pulumi.Input[bool] windows: Specifies whether the private key will use Windows/DOS style line breaks.
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_type is not None:
            pulumi.set(__self__, "certificate_type", certificate_type)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if force_command is not None:
            pulumi.set(__self__, "force_command", force_command)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if key_passphrase is not None:
            pulumi.set(__self__, "key_passphrase", key_passphrase)
        if key_size is not None:
            pulumi.set(__self__, "key_size", key_size)
        if object_name is not None:
            pulumi.set(__self__, "object_name", object_name)
        if principals is not None:
            pulumi.set(__self__, "principals", principals)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if public_key_fingerprint is not None:
            pulumi.set(__self__, "public_key_fingerprint", public_key_fingerprint)
        if public_key_method is not None:
            pulumi.set(__self__, "public_key_method", public_key_method)
        if serial is not None:
            pulumi.set(__self__, "serial", serial)
        if signing_ca is not None:
            pulumi.set(__self__, "signing_ca", signing_ca)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if valid_from is not None:
            pulumi.set(__self__, "valid_from", valid_from)
        if valid_hours is not None:
            pulumi.set(__self__, "valid_hours", valid_hours)
        if valid_to is not None:
            pulumi.set(__self__, "valid_to", valid_to)
        if windows is not None:
            pulumi.set(__self__, "windows", windows)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The issued SSH certificate.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether the SSH certificate is for client or server authentication.
        """
        return pulumi.get(self, "certificate_type")

    @certificate_type.setter
    def certificate_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_type", value)

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of one or more valid IP or CIDR destination hosts where the certificate will authenticate.
        """
        return pulumi.get(self, "destination_addresses")

    @destination_addresses.setter
    def destination_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "destination_addresses", value)

    @property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of key-value pairs that contain certificate extensions from the CA template for client certificates. Allowed values (case-sensitive): *permit-X11-forwarding, permit-agent-forwarding, permit-port-forwarding, permit-pty, permit-user-rc*
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "extensions", value)

    @property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[str]]:
        """
        The DN of the policy folder where the SSH certificate object will be created.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder", value)

    @property
    @pulumi.getter(name="forceCommand")
    def force_command(self) -> Optional[pulumi.Input[str]]:
        """
        A command to run after successful login.
        """
        return pulumi.get(self, "force_command")

    @force_command.setter
    def force_command(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "force_command", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the requested SSH certificate.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="keyPassphrase")
    def key_passphrase(self) -> Optional[pulumi.Input[str]]:
        """
        Passphrase for encrypting the private key.
        """
        return pulumi.get(self, "key_passphrase")

    @key_passphrase.setter
    def key_passphrase(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_passphrase", value)

    @property
    @pulumi.getter(name="keySize")
    def key_size(self) -> Optional[pulumi.Input[int]]:
        """
        Number of bits to use when creating a key pair. (e.g. 3072)
        """
        return pulumi.get(self, "key_size")

    @key_size.setter
    def key_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "key_size", value)

    @property
    @pulumi.getter(name="objectName")
    def object_name(self) -> Optional[pulumi.Input[str]]:
        """
        The friendly name of the SSH certificate object. When not specified the `key_id` is used for the friendly name. If the object already exists the old certificate is archived and the CA issues a new certificate.
        """
        return pulumi.get(self, "object_name")

    @object_name.setter
    def object_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_name", value)

    @property
    @pulumi.getter
    def principals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of user names for whom the requested certificate will be valid.
        """
        return pulumi.get(self, "principals")

    @principals.setter
    def principals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "principals", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        The private key for the SSH certificate if generated by Venafi.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        The OpenSSH formatted public key that will be used to generate the SSH certificate.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter(name="publicKeyFingerprint")
    def public_key_fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        The SHA256 fingerprint of the SSH certificate's public key.
        """
        return pulumi.get(self, "public_key_fingerprint")

    @public_key_fingerprint.setter
    def public_key_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key_fingerprint", value)

    @property
    @pulumi.getter(name="publicKeyMethod")
    def public_key_method(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the public key will be "local" (default), "file" or "service" generated.
        """
        return pulumi.get(self, "public_key_method")

    @public_key_method.setter
    def public_key_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key_method", value)

    @property
    @pulumi.getter
    def serial(self) -> Optional[pulumi.Input[str]]:
        """
        The serial number of the SSH certificate.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serial", value)

    @property
    @pulumi.getter(name="signingCa")
    def signing_ca(self) -> Optional[pulumi.Input[str]]:
        """
        The SHA256 fingerprint of the CA that signed the SSH certificate.
        """
        return pulumi.get(self, "signing_ca")

    @signing_ca.setter
    def signing_ca(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signing_ca", value)

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of one or more valid IP or CIDR addresses that can use the SSH certificate.
        """
        return pulumi.get(self, "source_addresses")

    @source_addresses.setter
    def source_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_addresses", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[str]]:
        """
        The SSH certificate issuing template.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> Optional[pulumi.Input[str]]:
        """
        The date the SSH certificate was issued.
        """
        return pulumi.get(self, "valid_from")

    @valid_from.setter
    def valid_from(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "valid_from", value)

    @property
    @pulumi.getter(name="validHours")
    def valid_hours(self) -> Optional[pulumi.Input[int]]:
        """
        Desired number of hours for which the certificate will be valid.
        """
        return pulumi.get(self, "valid_hours")

    @valid_hours.setter
    def valid_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "valid_hours", value)

    @property
    @pulumi.getter(name="validTo")
    def valid_to(self) -> Optional[pulumi.Input[str]]:
        """
        The date the SSH certificate will expire.
        """
        return pulumi.get(self, "valid_to")

    @valid_to.setter
    def valid_to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "valid_to", value)

    @property
    @pulumi.getter
    def windows(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the private key will use Windows/DOS style line breaks.
        """
        return pulumi.get(self, "windows")

    @windows.setter
    def windows(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "windows", value)


class SshCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 folder: Optional[pulumi.Input[str]] = None,
                 force_command: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 key_passphrase: Optional[pulumi.Input[str]] = None,
                 key_size: Optional[pulumi.Input[int]] = None,
                 object_name: Optional[pulumi.Input[str]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 public_key_method: Optional[pulumi.Input[str]] = None,
                 source_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 template: Optional[pulumi.Input[str]] = None,
                 valid_hours: Optional[pulumi.Input[int]] = None,
                 windows: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Provides access to request and retrieve SSH certificates from *Venafi Trust Protection Platform*.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_venafi as venafi

        ssh_cert = venafi.SshCertificate("sshCert",
            key_id="my-first-ssh-certificate",
            key_passphrase="passw0rd",
            key_size=3072,
            principals=["seamus"],
            public_key_method="local",
            template="Sample SSH CA",
            valid_hours=24)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_addresses: A list of one or more valid IP or CIDR destination hosts where the certificate will authenticate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] extensions: A list of key-value pairs that contain certificate extensions from the CA template for client certificates. Allowed values (case-sensitive): *permit-X11-forwarding, permit-agent-forwarding, permit-port-forwarding, permit-pty, permit-user-rc*
        :param pulumi.Input[str] folder: The DN of the policy folder where the SSH certificate object will be created.
        :param pulumi.Input[str] force_command: A command to run after successful login.
        :param pulumi.Input[str] key_id: The identifier of the requested SSH certificate.
        :param pulumi.Input[str] key_passphrase: Passphrase for encrypting the private key.
        :param pulumi.Input[int] key_size: Number of bits to use when creating a key pair. (e.g. 3072)
        :param pulumi.Input[str] object_name: The friendly name of the SSH certificate object. When not specified the `key_id` is used for the friendly name. If the object already exists the old certificate is archived and the CA issues a new certificate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] principals: A list of user names for whom the requested certificate will be valid.
        :param pulumi.Input[str] public_key: The OpenSSH formatted public key that will be used to generate the SSH certificate.
        :param pulumi.Input[str] public_key_method: Specifies whether the public key will be "local" (default), "file" or "service" generated.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_addresses: A list of one or more valid IP or CIDR addresses that can use the SSH certificate.
        :param pulumi.Input[str] template: The SSH certificate issuing template.
        :param pulumi.Input[int] valid_hours: Desired number of hours for which the certificate will be valid.
        :param pulumi.Input[bool] windows: Specifies whether the private key will use Windows/DOS style line breaks.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SshCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides access to request and retrieve SSH certificates from *Venafi Trust Protection Platform*.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_venafi as venafi

        ssh_cert = venafi.SshCertificate("sshCert",
            key_id="my-first-ssh-certificate",
            key_passphrase="passw0rd",
            key_size=3072,
            principals=["seamus"],
            public_key_method="local",
            template="Sample SSH CA",
            valid_hours=24)
        ```

        :param str resource_name: The name of the resource.
        :param SshCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SshCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 folder: Optional[pulumi.Input[str]] = None,
                 force_command: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 key_passphrase: Optional[pulumi.Input[str]] = None,
                 key_size: Optional[pulumi.Input[int]] = None,
                 object_name: Optional[pulumi.Input[str]] = None,
                 principals: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 public_key_method: Optional[pulumi.Input[str]] = None,
                 source_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 template: Optional[pulumi.Input[str]] = None,
                 valid_hours: Optional[pulumi.Input[int]] = None,
                 windows: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SshCertificateArgs.__new__(SshCertificateArgs)

            __props__.__dict__["destination_addresses"] = destination_addresses
            __props__.__dict__["extensions"] = extensions
            __props__.__dict__["folder"] = folder
            __props__.__dict__["force_command"] = force_command
            if key_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_id'")
            __props__.__dict__["key_id"] = key_id
            __props__.__dict__["key_passphrase"] = key_passphrase
            __props__.__dict__["key_size"] = key_size
            __props__.__dict__["object_name"] = object_name
            __props__.__dict__["principals"] = principals
            __props__.__dict__["public_key"] = public_key
            __props__.__dict__["public_key_method"] = public_key_method
            __props__.__dict__["source_addresses"] = source_addresses
            if template is None and not opts.urn:
                raise TypeError("Missing required property 'template'")
            __props__.__dict__["template"] = template
            __props__.__dict__["valid_hours"] = valid_hours
            __props__.__dict__["windows"] = windows
            __props__.__dict__["certificate"] = None
            __props__.__dict__["certificate_type"] = None
            __props__.__dict__["private_key"] = None
            __props__.__dict__["public_key_fingerprint"] = None
            __props__.__dict__["serial"] = None
            __props__.__dict__["signing_ca"] = None
            __props__.__dict__["valid_from"] = None
            __props__.__dict__["valid_to"] = None
        super(SshCertificate, __self__).__init__(
            'venafi:index/sshCertificate:SshCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate: Optional[pulumi.Input[str]] = None,
            certificate_type: Optional[pulumi.Input[str]] = None,
            destination_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            extensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            folder: Optional[pulumi.Input[str]] = None,
            force_command: Optional[pulumi.Input[str]] = None,
            key_id: Optional[pulumi.Input[str]] = None,
            key_passphrase: Optional[pulumi.Input[str]] = None,
            key_size: Optional[pulumi.Input[int]] = None,
            object_name: Optional[pulumi.Input[str]] = None,
            principals: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            private_key: Optional[pulumi.Input[str]] = None,
            public_key: Optional[pulumi.Input[str]] = None,
            public_key_fingerprint: Optional[pulumi.Input[str]] = None,
            public_key_method: Optional[pulumi.Input[str]] = None,
            serial: Optional[pulumi.Input[str]] = None,
            signing_ca: Optional[pulumi.Input[str]] = None,
            source_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            template: Optional[pulumi.Input[str]] = None,
            valid_from: Optional[pulumi.Input[str]] = None,
            valid_hours: Optional[pulumi.Input[int]] = None,
            valid_to: Optional[pulumi.Input[str]] = None,
            windows: Optional[pulumi.Input[bool]] = None) -> 'SshCertificate':
        """
        Get an existing SshCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate: The issued SSH certificate.
        :param pulumi.Input[str] certificate_type: Indicates whether the SSH certificate is for client or server authentication.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] destination_addresses: A list of one or more valid IP or CIDR destination hosts where the certificate will authenticate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] extensions: A list of key-value pairs that contain certificate extensions from the CA template for client certificates. Allowed values (case-sensitive): *permit-X11-forwarding, permit-agent-forwarding, permit-port-forwarding, permit-pty, permit-user-rc*
        :param pulumi.Input[str] folder: The DN of the policy folder where the SSH certificate object will be created.
        :param pulumi.Input[str] force_command: A command to run after successful login.
        :param pulumi.Input[str] key_id: The identifier of the requested SSH certificate.
        :param pulumi.Input[str] key_passphrase: Passphrase for encrypting the private key.
        :param pulumi.Input[int] key_size: Number of bits to use when creating a key pair. (e.g. 3072)
        :param pulumi.Input[str] object_name: The friendly name of the SSH certificate object. When not specified the `key_id` is used for the friendly name. If the object already exists the old certificate is archived and the CA issues a new certificate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] principals: A list of user names for whom the requested certificate will be valid.
        :param pulumi.Input[str] private_key: The private key for the SSH certificate if generated by Venafi.
        :param pulumi.Input[str] public_key: The OpenSSH formatted public key that will be used to generate the SSH certificate.
        :param pulumi.Input[str] public_key_fingerprint: The SHA256 fingerprint of the SSH certificate's public key.
        :param pulumi.Input[str] public_key_method: Specifies whether the public key will be "local" (default), "file" or "service" generated.
        :param pulumi.Input[str] serial: The serial number of the SSH certificate.
        :param pulumi.Input[str] signing_ca: The SHA256 fingerprint of the CA that signed the SSH certificate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_addresses: A list of one or more valid IP or CIDR addresses that can use the SSH certificate.
        :param pulumi.Input[str] template: The SSH certificate issuing template.
        :param pulumi.Input[str] valid_from: The date the SSH certificate was issued.
        :param pulumi.Input[int] valid_hours: Desired number of hours for which the certificate will be valid.
        :param pulumi.Input[str] valid_to: The date the SSH certificate will expire.
        :param pulumi.Input[bool] windows: Specifies whether the private key will use Windows/DOS style line breaks.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SshCertificateState.__new__(_SshCertificateState)

        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["certificate_type"] = certificate_type
        __props__.__dict__["destination_addresses"] = destination_addresses
        __props__.__dict__["extensions"] = extensions
        __props__.__dict__["folder"] = folder
        __props__.__dict__["force_command"] = force_command
        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["key_passphrase"] = key_passphrase
        __props__.__dict__["key_size"] = key_size
        __props__.__dict__["object_name"] = object_name
        __props__.__dict__["principals"] = principals
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["public_key"] = public_key
        __props__.__dict__["public_key_fingerprint"] = public_key_fingerprint
        __props__.__dict__["public_key_method"] = public_key_method
        __props__.__dict__["serial"] = serial
        __props__.__dict__["signing_ca"] = signing_ca
        __props__.__dict__["source_addresses"] = source_addresses
        __props__.__dict__["template"] = template
        __props__.__dict__["valid_from"] = valid_from
        __props__.__dict__["valid_hours"] = valid_hours
        __props__.__dict__["valid_to"] = valid_to
        __props__.__dict__["windows"] = windows
        return SshCertificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[str]:
        """
        The issued SSH certificate.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> pulumi.Output[str]:
        """
        Indicates whether the SSH certificate is for client or server authentication.
        """
        return pulumi.get(self, "certificate_type")

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of one or more valid IP or CIDR destination hosts where the certificate will authenticate.
        """
        return pulumi.get(self, "destination_addresses")

    @property
    @pulumi.getter
    def extensions(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of key-value pairs that contain certificate extensions from the CA template for client certificates. Allowed values (case-sensitive): *permit-X11-forwarding, permit-agent-forwarding, permit-port-forwarding, permit-pty, permit-user-rc*
        """
        return pulumi.get(self, "extensions")

    @property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[str]]:
        """
        The DN of the policy folder where the SSH certificate object will be created.
        """
        return pulumi.get(self, "folder")

    @property
    @pulumi.getter(name="forceCommand")
    def force_command(self) -> pulumi.Output[Optional[str]]:
        """
        A command to run after successful login.
        """
        return pulumi.get(self, "force_command")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[str]:
        """
        The identifier of the requested SSH certificate.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="keyPassphrase")
    def key_passphrase(self) -> pulumi.Output[Optional[str]]:
        """
        Passphrase for encrypting the private key.
        """
        return pulumi.get(self, "key_passphrase")

    @property
    @pulumi.getter(name="keySize")
    def key_size(self) -> pulumi.Output[Optional[int]]:
        """
        Number of bits to use when creating a key pair. (e.g. 3072)
        """
        return pulumi.get(self, "key_size")

    @property
    @pulumi.getter(name="objectName")
    def object_name(self) -> pulumi.Output[Optional[str]]:
        """
        The friendly name of the SSH certificate object. When not specified the `key_id` is used for the friendly name. If the object already exists the old certificate is archived and the CA issues a new certificate.
        """
        return pulumi.get(self, "object_name")

    @property
    @pulumi.getter
    def principals(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of user names for whom the requested certificate will be valid.
        """
        return pulumi.get(self, "principals")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[str]:
        """
        The private key for the SSH certificate if generated by Venafi.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output[Optional[str]]:
        """
        The OpenSSH formatted public key that will be used to generate the SSH certificate.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="publicKeyFingerprint")
    def public_key_fingerprint(self) -> pulumi.Output[str]:
        """
        The SHA256 fingerprint of the SSH certificate's public key.
        """
        return pulumi.get(self, "public_key_fingerprint")

    @property
    @pulumi.getter(name="publicKeyMethod")
    def public_key_method(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether the public key will be "local" (default), "file" or "service" generated.
        """
        return pulumi.get(self, "public_key_method")

    @property
    @pulumi.getter
    def serial(self) -> pulumi.Output[str]:
        """
        The serial number of the SSH certificate.
        """
        return pulumi.get(self, "serial")

    @property
    @pulumi.getter(name="signingCa")
    def signing_ca(self) -> pulumi.Output[str]:
        """
        The SHA256 fingerprint of the CA that signed the SSH certificate.
        """
        return pulumi.get(self, "signing_ca")

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of one or more valid IP or CIDR addresses that can use the SSH certificate.
        """
        return pulumi.get(self, "source_addresses")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output[str]:
        """
        The SSH certificate issuing template.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> pulumi.Output[str]:
        """
        The date the SSH certificate was issued.
        """
        return pulumi.get(self, "valid_from")

    @property
    @pulumi.getter(name="validHours")
    def valid_hours(self) -> pulumi.Output[Optional[int]]:
        """
        Desired number of hours for which the certificate will be valid.
        """
        return pulumi.get(self, "valid_hours")

    @property
    @pulumi.getter(name="validTo")
    def valid_to(self) -> pulumi.Output[str]:
        """
        The date the SSH certificate will expire.
        """
        return pulumi.get(self, "valid_to")

    @property
    @pulumi.getter
    def windows(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the private key will use Windows/DOS style line breaks.
        """
        return pulumi.get(self, "windows")

