# coding: utf-8

"""
    Data Repository API

    This document defines the REST API for Data Repository. **Status: design in progress** There are four top-level endpoints (besides some used by swagger):  * /swagger-ui.html - generated by swagger: swagger API page that provides this documentation and a live UI for      submitting REST requests  * /status - provides the operational status of the service  * /api    - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The overall API (/api) currently supports two interfaces:  * Repository - a general and default interface for initial setup, managing ingest and repository metadata  * Resource - an interface for managing billing accounts and resources  The API endpoints are organized by interface. Each interface is separately versioned. ## Notes on Naming All of the reference items are suffixed with \"Model\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. ## Editing and debugging I have found it best to edit this file directly to make changes and then use the swagger-editor to validate. The errors out of swagger-codegen are not that helpful. In the swagger-editor, it gives you nice errors and links to the place in the YAML where the errors are. But... the swagger-editor has been a bit of a pain for me to run. I tried the online website and was not able to load my YAML. Instead, I run it locally in a docker container, like this: ``` docker pull swaggerapi/swagger-editor docker run -p 9090:8080 swaggerapi/swagger-editor ``` Then navigate to localhost:9090 in your browser. I have not been able to get the file upload to work. It is a bit of a PITA, but I copy-paste the source code, replacing what is in the editor. Then make any fixes. Then copy-paste the resulting, valid file back into our source code. Not elegant, but easier than playing detective with the swagger-codegen errors. This might be something about my browser or environment, so give it a try yourself and see how it goes. ## Merging the DRS standard swagger into this swagger ## The merging is done in three sections:  1. Merging the security definitions into our security definitions  2. This section of paths. We make all paths explicit (prefixed with /ga4gh/drs/v1)     All standard DRS definitions and parameters are prefixed with 'DRS' to separate them     from our native definitions and parameters. We remove the x-swagger-router-controller lines.  3. A separate part of the definitions section for the DRS definitions  NOTE: the code here does not relect the DRS spec anymore. See DR-409.   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class DatasetRequestModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'description': 'str',
        'default_profile_id': 'str',
        'schema': 'DatasetSpecificationModel',
        'region': 'str',
        'gcp_region': 'str',
        'cloud_platform': 'CloudPlatform'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'default_profile_id': 'defaultProfileId',
        'schema': 'schema',
        'region': 'region',
        'gcp_region': 'gcpRegion',
        'cloud_platform': 'cloudPlatform'
    }

    def __init__(self, name=None, description=None, default_profile_id=None, schema=None, region=None, gcp_region=None, cloud_platform=None, local_vars_configuration=None):  # noqa: E501
        """DatasetRequestModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._description = None
        self._default_profile_id = None
        self._schema = None
        self._region = None
        self._gcp_region = None
        self._cloud_platform = None
        self.discriminator = None

        self.name = name
        if description is not None:
            self.description = description
        self.default_profile_id = default_profile_id
        self.schema = schema
        if region is not None:
            self.region = region
        if gcp_region is not None:
            self.gcp_region = gcp_region
        if cloud_platform is not None:
            self.cloud_platform = cloud_platform

    @property
    def name(self):
        """Gets the name of this DatasetRequestModel.  # noqa: E501

        Dataset and snapshot names follow this pattern. It is the same as ObjectNameProperty, but has a greater maxLength.   # noqa: E501

        :return: The name of this DatasetRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this DatasetRequestModel.

        Dataset and snapshot names follow this pattern. It is the same as ObjectNameProperty, but has a greater maxLength.   # noqa: E501

        :param name: The name of this DatasetRequestModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 511):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `511`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and not re.search(r'^[a-zA-Z0-9][_a-zA-Z0-9]*$', name)):  # noqa: E501
            raise ValueError(r"Invalid value for `name`, must be a follow pattern or equal to `/^[a-zA-Z0-9][_a-zA-Z0-9]*$/`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this DatasetRequestModel.  # noqa: E501

        Description of the dataset  # noqa: E501

        :return: The description of this DatasetRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this DatasetRequestModel.

        Description of the dataset  # noqa: E501

        :param description: The description of this DatasetRequestModel.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def default_profile_id(self):
        """Gets the default_profile_id of this DatasetRequestModel.  # noqa: E501

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :return: The default_profile_id of this DatasetRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._default_profile_id

    @default_profile_id.setter
    def default_profile_id(self, default_profile_id):
        """Sets the default_profile_id of this DatasetRequestModel.

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :param default_profile_id: The default_profile_id of this DatasetRequestModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and default_profile_id is None:  # noqa: E501
            raise ValueError("Invalid value for `default_profile_id`, must not be `None`")  # noqa: E501

        self._default_profile_id = default_profile_id

    @property
    def schema(self):
        """Gets the schema of this DatasetRequestModel.  # noqa: E501


        :return: The schema of this DatasetRequestModel.  # noqa: E501
        :rtype: DatasetSpecificationModel
        """
        return self._schema

    @schema.setter
    def schema(self, schema):
        """Sets the schema of this DatasetRequestModel.


        :param schema: The schema of this DatasetRequestModel.  # noqa: E501
        :type: DatasetSpecificationModel
        """
        if self.local_vars_configuration.client_side_validation and schema is None:  # noqa: E501
            raise ValueError("Invalid value for `schema`, must not be `None`")  # noqa: E501

        self._schema = schema

    @property
    def region(self):
        """Gets the region of this DatasetRequestModel.  # noqa: E501


        :return: The region of this DatasetRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """Sets the region of this DatasetRequestModel.


        :param region: The region of this DatasetRequestModel.  # noqa: E501
        :type: str
        """

        self._region = region

    @property
    def gcp_region(self):
        """Gets the gcp_region of this DatasetRequestModel.  # noqa: E501

        This is a temporary parameter until GCP and Azure resources are no longer entwined.  This parameter will disappear shortly   # noqa: E501

        :return: The gcp_region of this DatasetRequestModel.  # noqa: E501
        :rtype: str
        """
        return self._gcp_region

    @gcp_region.setter
    def gcp_region(self, gcp_region):
        """Sets the gcp_region of this DatasetRequestModel.

        This is a temporary parameter until GCP and Azure resources are no longer entwined.  This parameter will disappear shortly   # noqa: E501

        :param gcp_region: The gcp_region of this DatasetRequestModel.  # noqa: E501
        :type: str
        """

        self._gcp_region = gcp_region

    @property
    def cloud_platform(self):
        """Gets the cloud_platform of this DatasetRequestModel.  # noqa: E501


        :return: The cloud_platform of this DatasetRequestModel.  # noqa: E501
        :rtype: CloudPlatform
        """
        return self._cloud_platform

    @cloud_platform.setter
    def cloud_platform(self, cloud_platform):
        """Sets the cloud_platform of this DatasetRequestModel.


        :param cloud_platform: The cloud_platform of this DatasetRequestModel.  # noqa: E501
        :type: CloudPlatform
        """

        self._cloud_platform = cloud_platform

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DatasetRequestModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DatasetRequestModel):
            return True

        return self.to_dict() != other.to_dict()
