"""
    ChannelEngine Channel API

    ChannelEngine API for channels  # noqa: E501

    The version of the OpenAPI document: 2.10.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from channelengine_channel_api_client.api_client import ApiClient, Endpoint as _Endpoint
from channelengine_channel_api_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from channelengine_channel_api_client.model.api_response import ApiResponse
from channelengine_channel_api_client.model.channel_order_request import ChannelOrderRequest


class OrderApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __order_create(
            self,
            **kwargs
        ):
            """Create Order.  # noqa: E501

            Create a new order in ChannelEngine.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.order_create(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                channel_order_request (ChannelOrderRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ApiResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.order_create = _Endpoint(
            settings={
                'response_type': (ApiResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/v2/orders',
                'operation_id': 'order_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'channel_order_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'channel_order_request':
                        (ChannelOrderRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'channel_order_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json-patch+json',
                    'application/json',
                    'application/*+json'
                ]
            },
            api_client=api_client,
            callable=__order_create
        )

        def __order_invoice(
            self,
            merchant_order_no,
            **kwargs
        ):
            """Download Invoice.  # noqa: E501

            Generates the ChannelEngine VAT invoice for this order in PDF.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.order_invoice(merchant_order_no, async_req=True)
            >>> result = thread.get()

            Args:
                merchant_order_no (str): The unique order reference as used by the merchant.

            Keyword Args:
                use_customer_culture (bool): Generate the invoice in the billing address' country's language.. [optional] if omitted the server will use the default value of False
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                file
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['merchant_order_no'] = \
                merchant_order_no
            return self.call_with_http_info(**kwargs)

        self.order_invoice = _Endpoint(
            settings={
                'response_type': (file,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/v2/orders/{merchantOrderNo}/invoice',
                'operation_id': 'order_invoice',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'merchant_order_no',
                    'use_customer_culture',
                ],
                'required': [
                    'merchant_order_no',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'merchant_order_no':
                        (str,),
                    'use_customer_culture':
                        (bool,),
                },
                'attribute_map': {
                    'merchant_order_no': 'merchantOrderNo',
                    'use_customer_culture': 'useCustomerCulture',
                },
                'location_map': {
                    'merchant_order_no': 'path',
                    'use_customer_culture': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/pdf',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__order_invoice
        )

        def __order_packing_slip(
            self,
            merchant_order_no,
            **kwargs
        ):
            """Download Packing Slip.  # noqa: E501

            Generates the ChannelEngine packing slip for this order in PDF.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.order_packing_slip(merchant_order_no, async_req=True)
            >>> result = thread.get()

            Args:
                merchant_order_no (str): The unique order reference as used by the merchant.

            Keyword Args:
                use_customer_culture (bool): Generate the invoice in the billing address' country's language.. [optional] if omitted the server will use the default value of False
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                file
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['merchant_order_no'] = \
                merchant_order_no
            return self.call_with_http_info(**kwargs)

        self.order_packing_slip = _Endpoint(
            settings={
                'response_type': (file,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/v2/orders/{merchantOrderNo}/packingslip',
                'operation_id': 'order_packing_slip',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'merchant_order_no',
                    'use_customer_culture',
                ],
                'required': [
                    'merchant_order_no',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'merchant_order_no':
                        (str,),
                    'use_customer_culture':
                        (bool,),
                },
                'attribute_map': {
                    'merchant_order_no': 'merchantOrderNo',
                    'use_customer_culture': 'useCustomerCulture',
                },
                'location_map': {
                    'merchant_order_no': 'path',
                    'use_customer_culture': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/pdf',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__order_packing_slip
        )
