"""
    ChannelEngine Channel API

    ChannelEngine API for channels  # noqa: E501

    The version of the OpenAPI document: 2.10.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from channelengine_channel_api_client.api_client import ApiClient, Endpoint as _Endpoint
from channelengine_channel_api_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from channelengine_channel_api_client.model.api_response import ApiResponse
from channelengine_channel_api_client.model.channel_return_request import ChannelReturnRequest
from channelengine_channel_api_client.model.collection_of_channel_return_response import CollectionOfChannelReturnResponse
from channelengine_channel_api_client.model.return_reason import ReturnReason
from channelengine_channel_api_client.model.return_status import ReturnStatus


class ReturnApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __return_declare_for_channel(
            self,
            **kwargs
        ):
            """Create Return.  # noqa: E501

            Mark (part of) an order as returned by the customer.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.return_declare_for_channel(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                channel_return_request (ChannelReturnRequest): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ApiResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.return_declare_for_channel = _Endpoint(
            settings={
                'response_type': (ApiResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/v2/returns/channel',
                'operation_id': 'return_declare_for_channel',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'channel_return_request',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'channel_return_request':
                        (ChannelReturnRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'channel_return_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json-patch+json',
                    'application/json',
                    'application/*+json'
                ]
            },
            api_client=api_client,
            callable=__return_declare_for_channel
        )

        def __return_get_declared_by_merchant(
            self,
            **kwargs
        ):
            """Get Returns.  # noqa: E501

            Get all returns created by the merchant. This call is supposed<br />to be used by channels. Merchants should use the 'GET /v2/returns/merchant'<br />call.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.return_get_declared_by_merchant(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                statuses ([ReturnStatus]): Return status(es) to filter on.. [optional]
                reasons ([ReturnReason]): Return reason(s) to filter on.. [optional]
                from_date (datetime): Filter on the creation date, starting from this date. This date is inclusive.. [optional]
                to_date (datetime): Filter on the creation date, until this date. This date is exclusive.. [optional]
                page (int): The page to filter on. Starts at 1.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                CollectionOfChannelReturnResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.return_get_declared_by_merchant = _Endpoint(
            settings={
                'response_type': (CollectionOfChannelReturnResponse,),
                'auth': [
                    'apiKey'
                ],
                'endpoint_path': '/v2/returns/channel',
                'operation_id': 'return_get_declared_by_merchant',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'statuses',
                    'reasons',
                    'from_date',
                    'to_date',
                    'page',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'statuses':
                        ([ReturnStatus],),
                    'reasons':
                        ([ReturnReason],),
                    'from_date':
                        (datetime,),
                    'to_date':
                        (datetime,),
                    'page':
                        (int,),
                },
                'attribute_map': {
                    'statuses': 'statuses',
                    'reasons': 'reasons',
                    'from_date': 'fromDate',
                    'to_date': 'toDate',
                    'page': 'page',
                },
                'location_map': {
                    'statuses': 'query',
                    'reasons': 'query',
                    'from_date': 'query',
                    'to_date': 'query',
                    'page': 'query',
                },
                'collection_format_map': {
                    'statuses': 'multi',
                    'reasons': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__return_get_declared_by_merchant
        )
