"""
    ChannelEngine Channel API

    ChannelEngine API for channels  # noqa: E501

    The version of the OpenAPI document: 2.10.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from channelengine_channel_api_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from channelengine_channel_api_client.model.gender import Gender
    globals()['Gender'] = Gender


class ChannelAddressRequest(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('company_name',): {
            'max_length': 50,
            'min_length': 0,
        },
        ('first_name',): {
            'max_length': 50,
            'min_length': 0,
        },
        ('last_name',): {
            'max_length': 50,
            'min_length': 0,
        },
        ('street_name',): {
            'max_length': 50,
            'min_length': 0,
        },
        ('house_nr',): {
            'max_length': 50,
            'min_length': 0,
        },
        ('house_nr_addition',): {
            'max_length': 50,
            'min_length': 0,
        },
        ('city',): {
            'max_length': 50,
            'min_length': 0,
        },
        ('region',): {
            'max_length': 50,
            'min_length': 0,
        },
        ('country_iso',): {
            'max_length': 2,
            'min_length': 0,
        },
        ('original',): {
            'max_length': 256,
            'min_length': 0,
        },
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'gender': (Gender,),  # noqa: E501
            'company_name': (str, none_type,),  # noqa: E501
            'first_name': (str, none_type,),  # noqa: E501
            'last_name': (str, none_type,),  # noqa: E501
            'street_name': (str, none_type,),  # noqa: E501
            'house_nr': (str, none_type,),  # noqa: E501
            'house_nr_addition': (str, none_type,),  # noqa: E501
            'zip_code': (str, none_type,),  # noqa: E501
            'city': (str, none_type,),  # noqa: E501
            'region': (str, none_type,),  # noqa: E501
            'country_iso': (str, none_type,),  # noqa: E501
            'original': (str, none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'gender': 'Gender',  # noqa: E501
        'company_name': 'CompanyName',  # noqa: E501
        'first_name': 'FirstName',  # noqa: E501
        'last_name': 'LastName',  # noqa: E501
        'street_name': 'StreetName',  # noqa: E501
        'house_nr': 'HouseNr',  # noqa: E501
        'house_nr_addition': 'HouseNrAddition',  # noqa: E501
        'zip_code': 'ZipCode',  # noqa: E501
        'city': 'City',  # noqa: E501
        'region': 'Region',  # noqa: E501
        'country_iso': 'CountryIso',  # noqa: E501
        'original': 'Original',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """ChannelAddressRequest - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            gender (Gender): [optional]  # noqa: E501
            company_name (str, none_type): Optional. Company addressed too.. [optional]  # noqa: E501
            first_name (str, none_type): The first name of the customer.. [optional]  # noqa: E501
            last_name (str, none_type): The last name of the customer (includes the surname prefix [tussenvoegsel] like 'de', 'van', 'du').. [optional]  # noqa: E501
            street_name (str, none_type): The name of the street (without house number information)  This field might be empty if address validation is disabled in ChannelEngine.. [optional]  # noqa: E501
            house_nr (str, none_type): The house number  This field might be empty if address validation is disabled in ChannelEngine.. [optional]  # noqa: E501
            house_nr_addition (str, none_type): Optional. Addition to the house number  If the address is: Groenhazengracht 2c, the address will be:  StreetName: Groenhazengracht  HouseNo: 2  HouseNrAddition: c  This field might be empty if address validation is disabled in ChannelEngine.. [optional]  # noqa: E501
            zip_code (str, none_type): The zip or postal code.. [optional]  # noqa: E501
            city (str, none_type): The name of the city.. [optional]  # noqa: E501
            region (str, none_type): Optional. State/province/region.. [optional]  # noqa: E501
            country_iso (str, none_type): For example: NL, BE, FR.. [optional]  # noqa: E501
            original (str, none_type): Optional. The address as a single string: use in case the address lines are entered  as single lines and later parsed into street, house number and house number addition.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
