# coding: utf-8

"""
    ChannelEngine Channel API

    ChannelEngine API for channels  # noqa: E501

    The version of the OpenAPI document: 2.9.10
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from channelengine_channel_api_client.configuration import Configuration


class ChannelOrderLineRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'channel_product_no': 'str',
        'merchant_product_no': 'str',
        'quantity': 'int',
        'cancellation_requested_quantity': 'int',
        'unit_price_incl_vat': 'float',
        'fee_fixed': 'float',
        'fee_rate': 'float',
        'condition': 'Condition',
        'expected_delivery_date': 'datetime'
    }

    attribute_map = {
        'channel_product_no': 'ChannelProductNo',
        'merchant_product_no': 'MerchantProductNo',
        'quantity': 'Quantity',
        'cancellation_requested_quantity': 'CancellationRequestedQuantity',
        'unit_price_incl_vat': 'UnitPriceInclVat',
        'fee_fixed': 'FeeFixed',
        'fee_rate': 'FeeRate',
        'condition': 'Condition',
        'expected_delivery_date': 'ExpectedDeliveryDate'
    }

    def __init__(self, channel_product_no=None, merchant_product_no=None, quantity=None, cancellation_requested_quantity=None, unit_price_incl_vat=None, fee_fixed=None, fee_rate=None, condition=None, expected_delivery_date=None, local_vars_configuration=None):  # noqa: E501
        """ChannelOrderLineRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._channel_product_no = None
        self._merchant_product_no = None
        self._quantity = None
        self._cancellation_requested_quantity = None
        self._unit_price_incl_vat = None
        self._fee_fixed = None
        self._fee_rate = None
        self._condition = None
        self._expected_delivery_date = None
        self.discriminator = None

        self.channel_product_no = channel_product_no
        self.merchant_product_no = merchant_product_no
        self.quantity = quantity
        if cancellation_requested_quantity is not None:
            self.cancellation_requested_quantity = cancellation_requested_quantity
        self.unit_price_incl_vat = unit_price_incl_vat
        if fee_fixed is not None:
            self.fee_fixed = fee_fixed
        if fee_rate is not None:
            self.fee_rate = fee_rate
        if condition is not None:
            self.condition = condition
        self.expected_delivery_date = expected_delivery_date

    @property
    def channel_product_no(self):
        """Gets the channel_product_no of this ChannelOrderLineRequest.  # noqa: E501

        The unique product reference used by the channel.  # noqa: E501

        :return: The channel_product_no of this ChannelOrderLineRequest.  # noqa: E501
        :rtype: str
        """
        return self._channel_product_no

    @channel_product_no.setter
    def channel_product_no(self, channel_product_no):
        """Sets the channel_product_no of this ChannelOrderLineRequest.

        The unique product reference used by the channel.  # noqa: E501

        :param channel_product_no: The channel_product_no of this ChannelOrderLineRequest.  # noqa: E501
        :type channel_product_no: str
        """
        if self.local_vars_configuration.client_side_validation and channel_product_no is None:  # noqa: E501
            raise ValueError("Invalid value for `channel_product_no`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                channel_product_no is not None and len(channel_product_no) > 60):
            raise ValueError("Invalid value for `channel_product_no`, length must be less than or equal to `60`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                channel_product_no is not None and len(channel_product_no) < 0):
            raise ValueError("Invalid value for `channel_product_no`, length must be greater than or equal to `0`")  # noqa: E501

        self._channel_product_no = channel_product_no

    @property
    def merchant_product_no(self):
        """Gets the merchant_product_no of this ChannelOrderLineRequest.  # noqa: E501

        The unique product reference used by the merchant.  # noqa: E501

        :return: The merchant_product_no of this ChannelOrderLineRequest.  # noqa: E501
        :rtype: str
        """
        return self._merchant_product_no

    @merchant_product_no.setter
    def merchant_product_no(self, merchant_product_no):
        """Sets the merchant_product_no of this ChannelOrderLineRequest.

        The unique product reference used by the merchant.  # noqa: E501

        :param merchant_product_no: The merchant_product_no of this ChannelOrderLineRequest.  # noqa: E501
        :type merchant_product_no: str
        """
        if (self.local_vars_configuration.client_side_validation and
                merchant_product_no is not None and len(merchant_product_no) > 50):
            raise ValueError("Invalid value for `merchant_product_no`, length must be less than or equal to `50`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                merchant_product_no is not None and len(merchant_product_no) < 0):
            raise ValueError("Invalid value for `merchant_product_no`, length must be greater than or equal to `0`")  # noqa: E501

        self._merchant_product_no = merchant_product_no

    @property
    def quantity(self):
        """Gets the quantity of this ChannelOrderLineRequest.  # noqa: E501

        The number of items of the product.  # noqa: E501

        :return: The quantity of this ChannelOrderLineRequest.  # noqa: E501
        :rtype: int
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this ChannelOrderLineRequest.

        The number of items of the product.  # noqa: E501

        :param quantity: The quantity of this ChannelOrderLineRequest.  # noqa: E501
        :type quantity: int
        """
        if self.local_vars_configuration.client_side_validation and quantity is None:  # noqa: E501
            raise ValueError("Invalid value for `quantity`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                quantity is not None and quantity < 0):  # noqa: E501
            raise ValueError("Invalid value for `quantity`, must be a value greater than or equal to `0`")  # noqa: E501

        self._quantity = quantity

    @property
    def cancellation_requested_quantity(self):
        """Gets the cancellation_requested_quantity of this ChannelOrderLineRequest.  # noqa: E501

        The number of items for which cancellation was requested by the customer.  Some channels allow a customer to cancel an order until it has been shipped.  When an order has already been acknowledged in ChannelEngine, it can only be cancelled by creating a cancellation.  Use this field to check whether it is still possible to cancel the order. If this is the case, submit a cancellation to ChannelEngine.  # noqa: E501

        :return: The cancellation_requested_quantity of this ChannelOrderLineRequest.  # noqa: E501
        :rtype: int
        """
        return self._cancellation_requested_quantity

    @cancellation_requested_quantity.setter
    def cancellation_requested_quantity(self, cancellation_requested_quantity):
        """Sets the cancellation_requested_quantity of this ChannelOrderLineRequest.

        The number of items for which cancellation was requested by the customer.  Some channels allow a customer to cancel an order until it has been shipped.  When an order has already been acknowledged in ChannelEngine, it can only be cancelled by creating a cancellation.  Use this field to check whether it is still possible to cancel the order. If this is the case, submit a cancellation to ChannelEngine.  # noqa: E501

        :param cancellation_requested_quantity: The cancellation_requested_quantity of this ChannelOrderLineRequest.  # noqa: E501
        :type cancellation_requested_quantity: int
        """
        if (self.local_vars_configuration.client_side_validation and
                cancellation_requested_quantity is not None and cancellation_requested_quantity < 0):  # noqa: E501
            raise ValueError("Invalid value for `cancellation_requested_quantity`, must be a value greater than or equal to `0`")  # noqa: E501

        self._cancellation_requested_quantity = cancellation_requested_quantity

    @property
    def unit_price_incl_vat(self):
        """Gets the unit_price_incl_vat of this ChannelOrderLineRequest.  # noqa: E501

        The value of a single unit of the ordered product including VAT  (in the shop's base currency calculated using the exchange rate at the time of ordering).  # noqa: E501

        :return: The unit_price_incl_vat of this ChannelOrderLineRequest.  # noqa: E501
        :rtype: float
        """
        return self._unit_price_incl_vat

    @unit_price_incl_vat.setter
    def unit_price_incl_vat(self, unit_price_incl_vat):
        """Sets the unit_price_incl_vat of this ChannelOrderLineRequest.

        The value of a single unit of the ordered product including VAT  (in the shop's base currency calculated using the exchange rate at the time of ordering).  # noqa: E501

        :param unit_price_incl_vat: The unit_price_incl_vat of this ChannelOrderLineRequest.  # noqa: E501
        :type unit_price_incl_vat: float
        """
        if self.local_vars_configuration.client_side_validation and unit_price_incl_vat is None:  # noqa: E501
            raise ValueError("Invalid value for `unit_price_incl_vat`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                unit_price_incl_vat is not None and unit_price_incl_vat < 0):  # noqa: E501
            raise ValueError("Invalid value for `unit_price_incl_vat`, must be a value greater than or equal to `0`")  # noqa: E501

        self._unit_price_incl_vat = unit_price_incl_vat

    @property
    def fee_fixed(self):
        """Gets the fee_fixed of this ChannelOrderLineRequest.  # noqa: E501

        A fixed fee that is charged by the Channel for this orderline.  This fee rate is based on the currency of the Channel  This field is optional, send 0 if not applicable.  # noqa: E501

        :return: The fee_fixed of this ChannelOrderLineRequest.  # noqa: E501
        :rtype: float
        """
        return self._fee_fixed

    @fee_fixed.setter
    def fee_fixed(self, fee_fixed):
        """Sets the fee_fixed of this ChannelOrderLineRequest.

        A fixed fee that is charged by the Channel for this orderline.  This fee rate is based on the currency of the Channel  This field is optional, send 0 if not applicable.  # noqa: E501

        :param fee_fixed: The fee_fixed of this ChannelOrderLineRequest.  # noqa: E501
        :type fee_fixed: float
        """
        if (self.local_vars_configuration.client_side_validation and
                fee_fixed is not None and fee_fixed < 0):  # noqa: E501
            raise ValueError("Invalid value for `fee_fixed`, must be a value greater than or equal to `0`")  # noqa: E501

        self._fee_fixed = fee_fixed

    @property
    def fee_rate(self):
        """Gets the fee_rate of this ChannelOrderLineRequest.  # noqa: E501

        A percentage fee that is charged by the Channel for this orderline.  This field is optional, send 0 if not applicable.  # noqa: E501

        :return: The fee_rate of this ChannelOrderLineRequest.  # noqa: E501
        :rtype: float
        """
        return self._fee_rate

    @fee_rate.setter
    def fee_rate(self, fee_rate):
        """Sets the fee_rate of this ChannelOrderLineRequest.

        A percentage fee that is charged by the Channel for this orderline.  This field is optional, send 0 if not applicable.  # noqa: E501

        :param fee_rate: The fee_rate of this ChannelOrderLineRequest.  # noqa: E501
        :type fee_rate: float
        """
        if (self.local_vars_configuration.client_side_validation and
                fee_rate is not None and fee_rate < 0):  # noqa: E501
            raise ValueError("Invalid value for `fee_rate`, must be a value greater than or equal to `0`")  # noqa: E501

        self._fee_rate = fee_rate

    @property
    def condition(self):
        """Gets the condition of this ChannelOrderLineRequest.  # noqa: E501

        The condition of the product, this can be used to indicate that a product is a second-hand product.  # noqa: E501

        :return: The condition of this ChannelOrderLineRequest.  # noqa: E501
        :rtype: Condition
        """
        return self._condition

    @condition.setter
    def condition(self, condition):
        """Sets the condition of this ChannelOrderLineRequest.

        The condition of the product, this can be used to indicate that a product is a second-hand product.  # noqa: E501

        :param condition: The condition of this ChannelOrderLineRequest.  # noqa: E501
        :type condition: Condition
        """

        self._condition = condition

    @property
    def expected_delivery_date(self):
        """Gets the expected_delivery_date of this ChannelOrderLineRequest.  # noqa: E501

        Expected delivery date from channels, empty if channels not support this value  # noqa: E501

        :return: The expected_delivery_date of this ChannelOrderLineRequest.  # noqa: E501
        :rtype: datetime
        """
        return self._expected_delivery_date

    @expected_delivery_date.setter
    def expected_delivery_date(self, expected_delivery_date):
        """Sets the expected_delivery_date of this ChannelOrderLineRequest.

        Expected delivery date from channels, empty if channels not support this value  # noqa: E501

        :param expected_delivery_date: The expected_delivery_date of this ChannelOrderLineRequest.  # noqa: E501
        :type expected_delivery_date: datetime
        """

        self._expected_delivery_date = expected_delivery_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ChannelOrderLineRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ChannelOrderLineRequest):
            return True

        return self.to_dict() != other.to_dict()
