# coding: utf-8

"""
    ChannelEngine Channel API

    ChannelEngine API for channels  # noqa: E501

    The version of the OpenAPI document: 2.9.10
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from channelengine_channel_api_client.configuration import Configuration


class ChannelReturnRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'channel_order_no': 'str',
        'merchant_order_no': 'str',
        'channel_reference': 'str',
        'key_is_merchant_order_no': 'bool',
        'key_is_merchant_product_no': 'bool',
        'lines': 'list[ChannelReturnLineRequest]',
        'id': 'int',
        'reason': 'ReturnReason',
        'customer_comment': 'str',
        'merchant_comment': 'str',
        'refund_incl_vat': 'float',
        'refund_excl_vat': 'float'
    }

    attribute_map = {
        'channel_order_no': 'ChannelOrderNo',
        'merchant_order_no': 'MerchantOrderNo',
        'channel_reference': 'ChannelReference',
        'key_is_merchant_order_no': 'KeyIsMerchantOrderNo',
        'key_is_merchant_product_no': 'KeyIsMerchantProductNo',
        'lines': 'Lines',
        'id': 'Id',
        'reason': 'Reason',
        'customer_comment': 'CustomerComment',
        'merchant_comment': 'MerchantComment',
        'refund_incl_vat': 'RefundInclVat',
        'refund_excl_vat': 'RefundExclVat'
    }

    def __init__(self, channel_order_no=None, merchant_order_no=None, channel_reference=None, key_is_merchant_order_no=None, key_is_merchant_product_no=None, lines=None, id=None, reason=None, customer_comment=None, merchant_comment=None, refund_incl_vat=None, refund_excl_vat=None, local_vars_configuration=None):  # noqa: E501
        """ChannelReturnRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._channel_order_no = None
        self._merchant_order_no = None
        self._channel_reference = None
        self._key_is_merchant_order_no = None
        self._key_is_merchant_product_no = None
        self._lines = None
        self._id = None
        self._reason = None
        self._customer_comment = None
        self._merchant_comment = None
        self._refund_incl_vat = None
        self._refund_excl_vat = None
        self.discriminator = None

        self.channel_order_no = channel_order_no
        self.merchant_order_no = merchant_order_no
        self.channel_reference = channel_reference
        if key_is_merchant_order_no is not None:
            self.key_is_merchant_order_no = key_is_merchant_order_no
        if key_is_merchant_product_no is not None:
            self.key_is_merchant_product_no = key_is_merchant_product_no
        self.lines = lines
        if id is not None:
            self.id = id
        if reason is not None:
            self.reason = reason
        self.customer_comment = customer_comment
        self.merchant_comment = merchant_comment
        if refund_incl_vat is not None:
            self.refund_incl_vat = refund_incl_vat
        if refund_excl_vat is not None:
            self.refund_excl_vat = refund_excl_vat

    @property
    def channel_order_no(self):
        """Gets the channel_order_no of this ChannelReturnRequest.  # noqa: E501

        The unique order reference used by the Channel.  # noqa: E501

        :return: The channel_order_no of this ChannelReturnRequest.  # noqa: E501
        :rtype: str
        """
        return self._channel_order_no

    @channel_order_no.setter
    def channel_order_no(self, channel_order_no):
        """Sets the channel_order_no of this ChannelReturnRequest.

        The unique order reference used by the Channel.  # noqa: E501

        :param channel_order_no: The channel_order_no of this ChannelReturnRequest.  # noqa: E501
        :type channel_order_no: str
        """

        self._channel_order_no = channel_order_no

    @property
    def merchant_order_no(self):
        """Gets the merchant_order_no of this ChannelReturnRequest.  # noqa: E501

        The unique order reference used by the Merchant (sku).  # noqa: E501

        :return: The merchant_order_no of this ChannelReturnRequest.  # noqa: E501
        :rtype: str
        """
        return self._merchant_order_no

    @merchant_order_no.setter
    def merchant_order_no(self, merchant_order_no):
        """Sets the merchant_order_no of this ChannelReturnRequest.

        The unique order reference used by the Merchant (sku).  # noqa: E501

        :param merchant_order_no: The merchant_order_no of this ChannelReturnRequest.  # noqa: E501
        :type merchant_order_no: str
        """

        self._merchant_order_no = merchant_order_no

    @property
    def channel_reference(self):
        """Gets the channel_reference of this ChannelReturnRequest.  # noqa: E501

        The unique return reference used by the Channel.  # noqa: E501

        :return: The channel_reference of this ChannelReturnRequest.  # noqa: E501
        :rtype: str
        """
        return self._channel_reference

    @channel_reference.setter
    def channel_reference(self, channel_reference):
        """Sets the channel_reference of this ChannelReturnRequest.

        The unique return reference used by the Channel.  # noqa: E501

        :param channel_reference: The channel_reference of this ChannelReturnRequest.  # noqa: E501
        :type channel_reference: str
        """
        if self.local_vars_configuration.client_side_validation and channel_reference is None:  # noqa: E501
            raise ValueError("Invalid value for `channel_reference`, must not be `None`")  # noqa: E501

        self._channel_reference = channel_reference

    @property
    def key_is_merchant_order_no(self):
        """Gets the key_is_merchant_order_no of this ChannelReturnRequest.  # noqa: E501

        Optional. Is the MON used as key for the order (default value is false).  # noqa: E501

        :return: The key_is_merchant_order_no of this ChannelReturnRequest.  # noqa: E501
        :rtype: bool
        """
        return self._key_is_merchant_order_no

    @key_is_merchant_order_no.setter
    def key_is_merchant_order_no(self, key_is_merchant_order_no):
        """Sets the key_is_merchant_order_no of this ChannelReturnRequest.

        Optional. Is the MON used as key for the order (default value is false).  # noqa: E501

        :param key_is_merchant_order_no: The key_is_merchant_order_no of this ChannelReturnRequest.  # noqa: E501
        :type key_is_merchant_order_no: bool
        """

        self._key_is_merchant_order_no = key_is_merchant_order_no

    @property
    def key_is_merchant_product_no(self):
        """Gets the key_is_merchant_product_no of this ChannelReturnRequest.  # noqa: E501

        Optional. Is the MPN used as key for the product (default value is false).  # noqa: E501

        :return: The key_is_merchant_product_no of this ChannelReturnRequest.  # noqa: E501
        :rtype: bool
        """
        return self._key_is_merchant_product_no

    @key_is_merchant_product_no.setter
    def key_is_merchant_product_no(self, key_is_merchant_product_no):
        """Sets the key_is_merchant_product_no of this ChannelReturnRequest.

        Optional. Is the MPN used as key for the product (default value is false).  # noqa: E501

        :param key_is_merchant_product_no: The key_is_merchant_product_no of this ChannelReturnRequest.  # noqa: E501
        :type key_is_merchant_product_no: bool
        """

        self._key_is_merchant_product_no = key_is_merchant_product_no

    @property
    def lines(self):
        """Gets the lines of this ChannelReturnRequest.  # noqa: E501


        :return: The lines of this ChannelReturnRequest.  # noqa: E501
        :rtype: list[ChannelReturnLineRequest]
        """
        return self._lines

    @lines.setter
    def lines(self, lines):
        """Sets the lines of this ChannelReturnRequest.


        :param lines: The lines of this ChannelReturnRequest.  # noqa: E501
        :type lines: list[ChannelReturnLineRequest]
        """
        if self.local_vars_configuration.client_side_validation and lines is None:  # noqa: E501
            raise ValueError("Invalid value for `lines`, must not be `None`")  # noqa: E501

        self._lines = lines

    @property
    def id(self):
        """Gets the id of this ChannelReturnRequest.  # noqa: E501

        The unique return reference used by ChannelEngine.  # noqa: E501

        :return: The id of this ChannelReturnRequest.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ChannelReturnRequest.

        The unique return reference used by ChannelEngine.  # noqa: E501

        :param id: The id of this ChannelReturnRequest.  # noqa: E501
        :type id: int
        """

        self._id = id

    @property
    def reason(self):
        """Gets the reason of this ChannelReturnRequest.  # noqa: E501

        The reason code of the return.  # noqa: E501

        :return: The reason of this ChannelReturnRequest.  # noqa: E501
        :rtype: ReturnReason
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """Sets the reason of this ChannelReturnRequest.

        The reason code of the return.  # noqa: E501

        :param reason: The reason of this ChannelReturnRequest.  # noqa: E501
        :type reason: ReturnReason
        """

        self._reason = reason

    @property
    def customer_comment(self):
        """Gets the customer_comment of this ChannelReturnRequest.  # noqa: E501

        Optional. Comment of customer on the (reason of) the return.  # noqa: E501

        :return: The customer_comment of this ChannelReturnRequest.  # noqa: E501
        :rtype: str
        """
        return self._customer_comment

    @customer_comment.setter
    def customer_comment(self, customer_comment):
        """Sets the customer_comment of this ChannelReturnRequest.

        Optional. Comment of customer on the (reason of) the return.  # noqa: E501

        :param customer_comment: The customer_comment of this ChannelReturnRequest.  # noqa: E501
        :type customer_comment: str
        """
        if (self.local_vars_configuration.client_side_validation and
                customer_comment is not None and len(customer_comment) > 4001):
            raise ValueError("Invalid value for `customer_comment`, length must be less than or equal to `4001`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                customer_comment is not None and len(customer_comment) < 0):
            raise ValueError("Invalid value for `customer_comment`, length must be greater than or equal to `0`")  # noqa: E501

        self._customer_comment = customer_comment

    @property
    def merchant_comment(self):
        """Gets the merchant_comment of this ChannelReturnRequest.  # noqa: E501

        Optional. Comment of merchant on the return.  # noqa: E501

        :return: The merchant_comment of this ChannelReturnRequest.  # noqa: E501
        :rtype: str
        """
        return self._merchant_comment

    @merchant_comment.setter
    def merchant_comment(self, merchant_comment):
        """Sets the merchant_comment of this ChannelReturnRequest.

        Optional. Comment of merchant on the return.  # noqa: E501

        :param merchant_comment: The merchant_comment of this ChannelReturnRequest.  # noqa: E501
        :type merchant_comment: str
        """
        if (self.local_vars_configuration.client_side_validation and
                merchant_comment is not None and len(merchant_comment) > 4001):
            raise ValueError("Invalid value for `merchant_comment`, length must be less than or equal to `4001`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                merchant_comment is not None and len(merchant_comment) < 0):
            raise ValueError("Invalid value for `merchant_comment`, length must be greater than or equal to `0`")  # noqa: E501

        self._merchant_comment = merchant_comment

    @property
    def refund_incl_vat(self):
        """Gets the refund_incl_vat of this ChannelReturnRequest.  # noqa: E501

        Refund amount incl. VAT.  # noqa: E501

        :return: The refund_incl_vat of this ChannelReturnRequest.  # noqa: E501
        :rtype: float
        """
        return self._refund_incl_vat

    @refund_incl_vat.setter
    def refund_incl_vat(self, refund_incl_vat):
        """Sets the refund_incl_vat of this ChannelReturnRequest.

        Refund amount incl. VAT.  # noqa: E501

        :param refund_incl_vat: The refund_incl_vat of this ChannelReturnRequest.  # noqa: E501
        :type refund_incl_vat: float
        """
        if (self.local_vars_configuration.client_side_validation and
                refund_incl_vat is not None and refund_incl_vat < 0):  # noqa: E501
            raise ValueError("Invalid value for `refund_incl_vat`, must be a value greater than or equal to `0`")  # noqa: E501

        self._refund_incl_vat = refund_incl_vat

    @property
    def refund_excl_vat(self):
        """Gets the refund_excl_vat of this ChannelReturnRequest.  # noqa: E501

        Refund amount excl. VAT.  # noqa: E501

        :return: The refund_excl_vat of this ChannelReturnRequest.  # noqa: E501
        :rtype: float
        """
        return self._refund_excl_vat

    @refund_excl_vat.setter
    def refund_excl_vat(self, refund_excl_vat):
        """Sets the refund_excl_vat of this ChannelReturnRequest.

        Refund amount excl. VAT.  # noqa: E501

        :param refund_excl_vat: The refund_excl_vat of this ChannelReturnRequest.  # noqa: E501
        :type refund_excl_vat: float
        """
        if (self.local_vars_configuration.client_side_validation and
                refund_excl_vat is not None and refund_excl_vat < 0):  # noqa: E501
            raise ValueError("Invalid value for `refund_excl_vat`, must be a value greater than or equal to `0`")  # noqa: E501

        self._refund_excl_vat = refund_excl_vat

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ChannelReturnRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ChannelReturnRequest):
            return True

        return self.to_dict() != other.to_dict()
