"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const gws_generated_1 = require("./gws.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return gws_generated_1.RosInstance; } });
/**
 * A ROS resource type:  `ALIYUN::GWS::Instance`
 */
class Instance extends ros.Resource {
    /**
     * Create a new `ALIYUN::GWS::Instance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosInstance = new gws_generated_1.RosInstance(this, id, {
            clusterId: props.clusterId,
            systemDiskSize: props.systemDiskSize,
            instanceChargeType: props.instanceChargeType,
            autoRenew: props.autoRenew,
            vSwitchId: props.vSwitchId,
            period: props.period,
            allocatePublicAddress: props.allocatePublicAddress,
            systemDiskCategory: props.systemDiskCategory,
            name: props.name,
            internetChargeType: props.internetChargeType,
            internetMaxBandwidthOut: props.internetMaxBandwidthOut,
            imageId: props.imageId,
            instanceType: props.instanceType,
            appList: props.appList,
            workMode: props.workMode,
            periodUnit: props.periodUnit,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrClusterId = rosInstance.attrClusterId;
        this.attrInstanceChargeType = rosInstance.attrInstanceChargeType;
        this.attrInstanceId = rosInstance.attrInstanceId;
        this.attrMaxBandwidthIn = rosInstance.attrMaxBandwidthIn;
        this.attrMaxBandwidthOut = rosInstance.attrMaxBandwidthOut;
        this.attrName = rosInstance.attrName;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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