# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = ['MaintenanceWindow']


class MaintenanceWindow(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 end_time_in_seconds: Optional[pulumi.Input[float]] = None,
                 host_tag_group_host_names_group_anded: Optional[pulumi.Input[bool]] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 relevant_customer_tags: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 relevant_host_names: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 relevant_host_tags: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 relevant_host_tags_anded: Optional[pulumi.Input[bool]] = None,
                 start_time_in_seconds: Optional[pulumi.Input[float]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a Wavefront Maintenance Window Resource. This allows maintenance windows to be created, updated, and deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        basic = wavefront.MaintenanceWindow("basic",
            end_time_in_seconds=1601123456,
            reason="Routine maintenance for 2020",
            relevant_host_names=[
                "my_hostname",
                "my_other_hostname",
            ],
            start_time_in_seconds=1600123456,
            title="Routine maintenance")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] end_time_in_seconds: end time in seconds after 1 Jan 1970 GMT.
        :param pulumi.Input[bool] host_tag_group_host_names_group_anded: If true, a source/host must be in 'relevantHostNames' and have tags matching the specification formed by 'relevantHostTags' and 'relevantHostTagsAnded' in order for this maintenance window to apply. If false, a source/host must either be in 'relevantHostNames' or match 'relevantHostTags' and 'relevantHostTagsAnded'. Default: false
        :param pulumi.Input[str] reason: The reason for the maintenance window
        :param pulumi.Input[List[pulumi.Input[str]]] relevant_customer_tags: List of alert tags whose matching alerts will be put into maintenance because of this maintenance window. At least one of relevant_customer_tags, relevant_host_tags, or relevant_host_names is required.
        :param pulumi.Input[List[pulumi.Input[str]]] relevant_host_names: List of source/host names that will be put into maintenance because of this maintenance window. At least one of relevant_customer_tags, relevant_host_tags, or relevant_host_names is required.
        :param pulumi.Input[List[pulumi.Input[str]]] relevant_host_tags: List of source/host tags whose matching sources/hosts will be put into maintenance because of this maintenance window. At least one of relevant_customer_tags, relevant_host_tags, or relevant_host_names is required.
        :param pulumi.Input[bool] relevant_host_tags_anded: Whether to AND source/host tags listed in relevantHostTags. If true, a source/host must contain all tags in order for the maintenance window to apply. If false, the tags are OR'ed, and a source/host must contain one of the tags. Default: false
        :param pulumi.Input[float] start_time_in_seconds: start time in seconds after 1 Jan 1970 GMT.
        :param pulumi.Input[str] title: The title of the maintenance window
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if end_time_in_seconds is None:
                raise TypeError("Missing required property 'end_time_in_seconds'")
            __props__['end_time_in_seconds'] = end_time_in_seconds
            __props__['host_tag_group_host_names_group_anded'] = host_tag_group_host_names_group_anded
            if reason is None:
                raise TypeError("Missing required property 'reason'")
            __props__['reason'] = reason
            __props__['relevant_customer_tags'] = relevant_customer_tags
            __props__['relevant_host_names'] = relevant_host_names
            __props__['relevant_host_tags'] = relevant_host_tags
            __props__['relevant_host_tags_anded'] = relevant_host_tags_anded
            if start_time_in_seconds is None:
                raise TypeError("Missing required property 'start_time_in_seconds'")
            __props__['start_time_in_seconds'] = start_time_in_seconds
            if title is None:
                raise TypeError("Missing required property 'title'")
            __props__['title'] = title
        super(MaintenanceWindow, __self__).__init__(
            'wavefront:index/maintenanceWindow:MaintenanceWindow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            end_time_in_seconds: Optional[pulumi.Input[float]] = None,
            host_tag_group_host_names_group_anded: Optional[pulumi.Input[bool]] = None,
            reason: Optional[pulumi.Input[str]] = None,
            relevant_customer_tags: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
            relevant_host_names: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
            relevant_host_tags: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
            relevant_host_tags_anded: Optional[pulumi.Input[bool]] = None,
            start_time_in_seconds: Optional[pulumi.Input[float]] = None,
            title: Optional[pulumi.Input[str]] = None) -> 'MaintenanceWindow':
        """
        Get an existing MaintenanceWindow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] end_time_in_seconds: end time in seconds after 1 Jan 1970 GMT.
        :param pulumi.Input[bool] host_tag_group_host_names_group_anded: If true, a source/host must be in 'relevantHostNames' and have tags matching the specification formed by 'relevantHostTags' and 'relevantHostTagsAnded' in order for this maintenance window to apply. If false, a source/host must either be in 'relevantHostNames' or match 'relevantHostTags' and 'relevantHostTagsAnded'. Default: false
        :param pulumi.Input[str] reason: The reason for the maintenance window
        :param pulumi.Input[List[pulumi.Input[str]]] relevant_customer_tags: List of alert tags whose matching alerts will be put into maintenance because of this maintenance window. At least one of relevant_customer_tags, relevant_host_tags, or relevant_host_names is required.
        :param pulumi.Input[List[pulumi.Input[str]]] relevant_host_names: List of source/host names that will be put into maintenance because of this maintenance window. At least one of relevant_customer_tags, relevant_host_tags, or relevant_host_names is required.
        :param pulumi.Input[List[pulumi.Input[str]]] relevant_host_tags: List of source/host tags whose matching sources/hosts will be put into maintenance because of this maintenance window. At least one of relevant_customer_tags, relevant_host_tags, or relevant_host_names is required.
        :param pulumi.Input[bool] relevant_host_tags_anded: Whether to AND source/host tags listed in relevantHostTags. If true, a source/host must contain all tags in order for the maintenance window to apply. If false, the tags are OR'ed, and a source/host must contain one of the tags. Default: false
        :param pulumi.Input[float] start_time_in_seconds: start time in seconds after 1 Jan 1970 GMT.
        :param pulumi.Input[str] title: The title of the maintenance window
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["end_time_in_seconds"] = end_time_in_seconds
        __props__["host_tag_group_host_names_group_anded"] = host_tag_group_host_names_group_anded
        __props__["reason"] = reason
        __props__["relevant_customer_tags"] = relevant_customer_tags
        __props__["relevant_host_names"] = relevant_host_names
        __props__["relevant_host_tags"] = relevant_host_tags
        __props__["relevant_host_tags_anded"] = relevant_host_tags_anded
        __props__["start_time_in_seconds"] = start_time_in_seconds
        __props__["title"] = title
        return MaintenanceWindow(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="endTimeInSeconds")
    def end_time_in_seconds(self) -> pulumi.Output[float]:
        """
        end time in seconds after 1 Jan 1970 GMT.
        """
        return pulumi.get(self, "end_time_in_seconds")

    @property
    @pulumi.getter(name="hostTagGroupHostNamesGroupAnded")
    def host_tag_group_host_names_group_anded(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, a source/host must be in 'relevantHostNames' and have tags matching the specification formed by 'relevantHostTags' and 'relevantHostTagsAnded' in order for this maintenance window to apply. If false, a source/host must either be in 'relevantHostNames' or match 'relevantHostTags' and 'relevantHostTagsAnded'. Default: false
        """
        return pulumi.get(self, "host_tag_group_host_names_group_anded")

    @property
    @pulumi.getter
    def reason(self) -> pulumi.Output[str]:
        """
        The reason for the maintenance window
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="relevantCustomerTags")
    def relevant_customer_tags(self) -> pulumi.Output[Optional[List[str]]]:
        """
        List of alert tags whose matching alerts will be put into maintenance because of this maintenance window. At least one of relevant_customer_tags, relevant_host_tags, or relevant_host_names is required.
        """
        return pulumi.get(self, "relevant_customer_tags")

    @property
    @pulumi.getter(name="relevantHostNames")
    def relevant_host_names(self) -> pulumi.Output[Optional[List[str]]]:
        """
        List of source/host names that will be put into maintenance because of this maintenance window. At least one of relevant_customer_tags, relevant_host_tags, or relevant_host_names is required.
        """
        return pulumi.get(self, "relevant_host_names")

    @property
    @pulumi.getter(name="relevantHostTags")
    def relevant_host_tags(self) -> pulumi.Output[Optional[List[str]]]:
        """
        List of source/host tags whose matching sources/hosts will be put into maintenance because of this maintenance window. At least one of relevant_customer_tags, relevant_host_tags, or relevant_host_names is required.
        """
        return pulumi.get(self, "relevant_host_tags")

    @property
    @pulumi.getter(name="relevantHostTagsAnded")
    def relevant_host_tags_anded(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to AND source/host tags listed in relevantHostTags. If true, a source/host must contain all tags in order for the maintenance window to apply. If false, the tags are OR'ed, and a source/host must contain one of the tags. Default: false
        """
        return pulumi.get(self, "relevant_host_tags_anded")

    @property
    @pulumi.getter(name="startTimeInSeconds")
    def start_time_in_seconds(self) -> pulumi.Output[float]:
        """
        start time in seconds after 1 Jan 1970 GMT.
        """
        return pulumi.get(self, "start_time_in_seconds")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[str]:
        """
        The title of the maintenance window
        """
        return pulumi.get(self, "title")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

