# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables


class ResourceServer(pulumi.CustomResource):
    allow_offline_access: pulumi.Output[bool]
    """
    Boolean. Indicates whether or not refresh tokens can be issued for this resource server.
    """
    enforce_policies: pulumi.Output[bool]
    """
    Boolean. Indicates whether or not authorization polices are enforced.
    """
    identifier: pulumi.Output[str]
    """
    String. Unique identifier for the resource server. Used as the audience parameter for authorization calls. Can not be changed once set.
    """
    name: pulumi.Output[str]
    """
    String. Friendly name for the resource server. Cannot include `<` or `>` characters.
    """
    options: pulumi.Output[dict]
    """
    Map(String). Used to store additional metadata
    """
    scopes: pulumi.Output[list]
    """
    Set(Resource).  List of permissions (scopes) used by this resource server. For details, see Scopes.

      * `description` (`str`) - String. Description of the permission (scope).
      * `value` (`str`) - String. Name of the permission (scope). Examples include `read:appointments` or `delete:appointments`.
    """
    signing_alg: pulumi.Output[str]
    """
    String. Algorithm used to sign JWTs. Options include `HS256` and `RS256`.
    """
    signing_secret: pulumi.Output[str]
    """
    String. Secret used to sign tokens when using symmetric algorithms (HS256).
    """
    skip_consent_for_verifiable_first_party_clients: pulumi.Output[bool]
    """
    Boolean. Indicates whether or not to skip user consent for applications flagged as first party.
    """
    token_dialect: pulumi.Output[str]
    """
    String. Dialect of access tokens that should be issued for this resource server. Options include `access_token` or `access_token_authz` (includes permissions).
    """
    token_lifetime: pulumi.Output[float]
    """
    Integer. Number of seconds during which access tokens issued for this resource server from the token endpoint remain valid.
    """
    token_lifetime_for_web: pulumi.Output[float]
    """
    Integer. Number of seconds during which access tokens issued for this resource server via implicit or hybrid flows remain valid. Cannot be greater than the `token_lifetime` value.
    """
    verification_location: pulumi.Output[str]
    """
    String
    """
    def __init__(__self__, resource_name, opts=None, allow_offline_access=None, enforce_policies=None, identifier=None, name=None, options=None, scopes=None, signing_alg=None, signing_secret=None, skip_consent_for_verifiable_first_party_clients=None, token_dialect=None, token_lifetime=None, token_lifetime_for_web=None, verification_location=None, __props__=None, __name__=None, __opts__=None):
        """
        With this resource, you can set up APIs that can be consumed from your authorized applications.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        my_resource_server = auth0.ResourceServer("myResourceServer",
            allow_offline_access=True,
            identifier="https://api.example.com",
            scopes=[
                {
                    "description": "Create foos",
                    "value": "create:foo",
                },
                {
                    "description": "Create bars",
                    "value": "create:bar",
                },
            ],
            signing_alg="RS256",
            skip_consent_for_verifiable_first_party_clients=True,
            token_lifetime=8600)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_offline_access: Boolean. Indicates whether or not refresh tokens can be issued for this resource server.
        :param pulumi.Input[bool] enforce_policies: Boolean. Indicates whether or not authorization polices are enforced.
        :param pulumi.Input[str] identifier: String. Unique identifier for the resource server. Used as the audience parameter for authorization calls. Can not be changed once set.
        :param pulumi.Input[str] name: String. Friendly name for the resource server. Cannot include `<` or `>` characters.
        :param pulumi.Input[dict] options: Map(String). Used to store additional metadata
        :param pulumi.Input[list] scopes: Set(Resource).  List of permissions (scopes) used by this resource server. For details, see Scopes.
        :param pulumi.Input[str] signing_alg: String. Algorithm used to sign JWTs. Options include `HS256` and `RS256`.
        :param pulumi.Input[str] signing_secret: String. Secret used to sign tokens when using symmetric algorithms (HS256).
        :param pulumi.Input[bool] skip_consent_for_verifiable_first_party_clients: Boolean. Indicates whether or not to skip user consent for applications flagged as first party.
        :param pulumi.Input[str] token_dialect: String. Dialect of access tokens that should be issued for this resource server. Options include `access_token` or `access_token_authz` (includes permissions).
        :param pulumi.Input[float] token_lifetime: Integer. Number of seconds during which access tokens issued for this resource server from the token endpoint remain valid.
        :param pulumi.Input[float] token_lifetime_for_web: Integer. Number of seconds during which access tokens issued for this resource server via implicit or hybrid flows remain valid. Cannot be greater than the `token_lifetime` value.
        :param pulumi.Input[str] verification_location: String

        The **scopes** object supports the following:

          * `description` (`pulumi.Input[str]`) - String. Description of the permission (scope).
          * `value` (`pulumi.Input[str]`) - String. Name of the permission (scope). Examples include `read:appointments` or `delete:appointments`.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['allow_offline_access'] = allow_offline_access
            __props__['enforce_policies'] = enforce_policies
            __props__['identifier'] = identifier
            __props__['name'] = name
            __props__['options'] = options
            __props__['scopes'] = scopes
            __props__['signing_alg'] = signing_alg
            __props__['signing_secret'] = signing_secret
            __props__['skip_consent_for_verifiable_first_party_clients'] = skip_consent_for_verifiable_first_party_clients
            __props__['token_dialect'] = token_dialect
            __props__['token_lifetime'] = token_lifetime
            __props__['token_lifetime_for_web'] = token_lifetime_for_web
            __props__['verification_location'] = verification_location
        super(ResourceServer, __self__).__init__(
            'auth0:index/resourceServer:ResourceServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, allow_offline_access=None, enforce_policies=None, identifier=None, name=None, options=None, scopes=None, signing_alg=None, signing_secret=None, skip_consent_for_verifiable_first_party_clients=None, token_dialect=None, token_lifetime=None, token_lifetime_for_web=None, verification_location=None):
        """
        Get an existing ResourceServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_offline_access: Boolean. Indicates whether or not refresh tokens can be issued for this resource server.
        :param pulumi.Input[bool] enforce_policies: Boolean. Indicates whether or not authorization polices are enforced.
        :param pulumi.Input[str] identifier: String. Unique identifier for the resource server. Used as the audience parameter for authorization calls. Can not be changed once set.
        :param pulumi.Input[str] name: String. Friendly name for the resource server. Cannot include `<` or `>` characters.
        :param pulumi.Input[dict] options: Map(String). Used to store additional metadata
        :param pulumi.Input[list] scopes: Set(Resource).  List of permissions (scopes) used by this resource server. For details, see Scopes.
        :param pulumi.Input[str] signing_alg: String. Algorithm used to sign JWTs. Options include `HS256` and `RS256`.
        :param pulumi.Input[str] signing_secret: String. Secret used to sign tokens when using symmetric algorithms (HS256).
        :param pulumi.Input[bool] skip_consent_for_verifiable_first_party_clients: Boolean. Indicates whether or not to skip user consent for applications flagged as first party.
        :param pulumi.Input[str] token_dialect: String. Dialect of access tokens that should be issued for this resource server. Options include `access_token` or `access_token_authz` (includes permissions).
        :param pulumi.Input[float] token_lifetime: Integer. Number of seconds during which access tokens issued for this resource server from the token endpoint remain valid.
        :param pulumi.Input[float] token_lifetime_for_web: Integer. Number of seconds during which access tokens issued for this resource server via implicit or hybrid flows remain valid. Cannot be greater than the `token_lifetime` value.
        :param pulumi.Input[str] verification_location: String

        The **scopes** object supports the following:

          * `description` (`pulumi.Input[str]`) - String. Description of the permission (scope).
          * `value` (`pulumi.Input[str]`) - String. Name of the permission (scope). Examples include `read:appointments` or `delete:appointments`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["allow_offline_access"] = allow_offline_access
        __props__["enforce_policies"] = enforce_policies
        __props__["identifier"] = identifier
        __props__["name"] = name
        __props__["options"] = options
        __props__["scopes"] = scopes
        __props__["signing_alg"] = signing_alg
        __props__["signing_secret"] = signing_secret
        __props__["skip_consent_for_verifiable_first_party_clients"] = skip_consent_for_verifiable_first_party_clients
        __props__["token_dialect"] = token_dialect
        __props__["token_lifetime"] = token_lifetime
        __props__["token_lifetime_for_web"] = token_lifetime_for_web
        __props__["verification_location"] = verification_location
        return ResourceServer(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop
