import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [activate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsactivate.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Activate extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [activate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsactivate.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to submit an Activate application form
     *
     * Access Level: Write
     */
    toCreateForm(): this;
    /**
     * Grants permission to get the AWS account contact information
     *
     * Access Level: Read
     */
    toGetAccountContact(): this;
    /**
     * Grants permission to get Activate tech posts and offer information
     *
     * Access Level: Read
     */
    toGetContentInfo(): this;
    /**
     * Grants permission to get the AWS cost information
     *
     * Access Level: Read
     */
    toGetCosts(): this;
    /**
     * Grants permission to get the AWS credit information
     *
     * Access Level: Read
     */
    toGetCredits(): this;
    /**
     * Grants permission to get the Activate member information
     *
     * Access Level: Read
     */
    toGetMemberInfo(): this;
    /**
     * Grants permission to get an Activate program
     *
     * Access Level: Read
     */
    toGetProgram(): this;
    /**
     * Grants permission to create or update the Activate member information
     *
     * Access Level: Write
     */
    toPutMemberInfo(): this;
    protected accessLevelList: AccessLevelList;
}
//# sourceMappingURL=activate.d.ts.map