import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [comprehendmedical](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncomprehendmedical.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Comprehendmedical extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [comprehendmedical](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncomprehendmedical.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to describe the properties of a medical entity detection job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_DescribeEntitiesDetectionV2Job.html
     */
    toDescribeEntitiesDetectionV2Job(): this;
    /**
     * Grants permission to describe the properties of an ICD-10-CM linking job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_DescribeICD10CMInferenceJob.html
     */
    toDescribeICD10CMInferenceJob(): this;
    /**
     * Grants permission to describe the properties of a PHI entity detection job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_DescribePHIDetectionJob.html
     */
    toDescribePHIDetectionJob(): this;
    /**
     * Grants permission to describe the properties of an RxNorm linking job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_DescribeRxNormInferenceJob.html
     */
    toDescribeRxNormInferenceJob(): this;
    /**
     * Grants permission to describe the properties of a SNOMED-CT linking job that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_DescribeSNOMEDCTInferenceJob.html
     */
    toDescribeSNOMEDCTInferenceJob(): this;
    /**
     * Grants permission to detect the named medical entities, and their relationships and traits within the given text document
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_DetectEntitiesV2.html
     */
    toDetectEntitiesV2(): this;
    /**
     * Grants permission to detect the protected health information (PHI) entities within the given text document
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_DetectPHI.html
     */
    toDetectPHI(): this;
    /**
     * Grants permission to detect the medical condition entities within the given text document and link them to ICD-10-CM codes
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_InferICD10CM.html
     */
    toInferICD10CM(): this;
    /**
     * Grants permission to detect the medication entities within the given text document and link them to RxCUI concept identifiers from the National Library of Medicine RxNorm database
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_InferRxNorm.html
     */
    toInferRxNorm(): this;
    /**
     * Grants permission to detect the medical condition, anatomy, and test, treatment, and procedure entities within the given text document and link them to SNOMED-CT codes
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_InferSNOMEDCT.html
     */
    toInferSNOMEDCT(): this;
    /**
     * Grants permission to list the medical entity detection jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_ListEntitiesDetectionV2Jobs.html
     */
    toListEntitiesDetectionV2Jobs(): this;
    /**
     * Grants permission to list the ICD-10-CM linking jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_ListICD10CMInferenceJobs.html
     */
    toListICD10CMInferenceJobs(): this;
    /**
     * Grants permission to list the PHI entity detection jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_ListPHIDetectionJobs.html
     */
    toListPHIDetectionJobs(): this;
    /**
     * Grants permission to list the RxNorm linking jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_ListRxNormInferenceJobs.html
     */
    toListRxNormInferenceJobs(): this;
    /**
     * Grants permission to list the SNOMED-CT linking jobs that you have submitted
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_ListSNOMEDCTInferenceJobs.html
     */
    toListSNOMEDCTInferenceJobs(): this;
    /**
     * Grants permission to start an asynchronous medical entity detection job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_StartEntitiesDetectionV2Job.html
     */
    toStartEntitiesDetectionV2Job(): this;
    /**
     * Grants permission to start an asynchronous ICD-10-CM linking job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_StartICD10CMInferenceJob.html
     */
    toStartICD10CMInferenceJob(): this;
    /**
     * Grants permission to start an asynchronous PHI entity detection job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_StartPHIDetectionJob.html
     */
    toStartPHIDetectionJob(): this;
    /**
     * Grants permission to start an asynchronous RxNorm linking job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_StartRxNormInferenceJob.html
     */
    toStartRxNormInferenceJob(): this;
    /**
     * Grants permission to start an asynchronous SNOMED-CT linking job for a collection of documents
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_StartSNOMEDCTInferenceJob.html
     */
    toStartSNOMEDCTInferenceJob(): this;
    /**
     * Grants permission to stop a medical entity detection job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_StopEntitiesDetectionV2Job.html
     */
    toStopEntitiesDetectionV2Job(): this;
    /**
     * Grants permission to stop an ICD-10-CM linking job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_StopICD10CMInferenceJob.html
     */
    toStopICD10CMInferenceJob(): this;
    /**
     * Grants permission to stop a PHI entity detection job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_StopPHIDetectionJob.html
     */
    toStopPHIDetectionJob(): this;
    /**
     * Grants permission to stop an RxNorm linking job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_StopRxNormInferenceJob.html
     */
    toStopRxNormInferenceJob(): this;
    /**
     * Grants permission to stop a SNOMED-CT linking job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/comprehend-medical/latest/dev/API_medical_StopSNOMEDCTInferenceJob.html
     */
    toStopSNOMEDCTInferenceJob(): this;
    protected accessLevelList: AccessLevelList;
}
//# sourceMappingURL=comprehendmedical.d.ts.map