"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Connect = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [connect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Connect extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [connect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'connect';
        this.accessLevelList = {
            Write: [
                'AssociateApprovedOrigin',
                'AssociateBot',
                'AssociateCustomerProfilesDomain',
                'AssociateDefaultVocabulary',
                'AssociateInstanceStorageConfig',
                'AssociateLambdaFunction',
                'AssociateLexBot',
                'AssociatePhoneNumberContactFlow',
                'AssociateQueueQuickConnects',
                'AssociateRoutingProfileQueues',
                'AssociateSecurityKey',
                'BatchAssociateAnalyticsDataSet',
                'BatchDisassociateAnalyticsDataSet',
                'ClaimPhoneNumber',
                'CreateAgentStatus',
                'CreateContactFlow',
                'CreateContactFlowModule',
                'CreateHoursOfOperation',
                'CreateInstance',
                'CreateIntegrationAssociation',
                'CreateQueue',
                'CreateQuickConnect',
                'CreateRoutingProfile',
                'CreateSecurityProfile',
                'CreateUseCase',
                'CreateUser',
                'CreateUserHierarchyGroup',
                'CreateVocabulary',
                'DeleteContactFlow',
                'DeleteContactFlowModule',
                'DeleteHoursOfOperation',
                'DeleteInstance',
                'DeleteIntegrationAssociation',
                'DeleteQuickConnect',
                'DeleteSecurityProfile',
                'DeleteUseCase',
                'DeleteUser',
                'DeleteUserHierarchyGroup',
                'DeleteVocabulary',
                'DisassociateApprovedOrigin',
                'DisassociateBot',
                'DisassociateCustomerProfilesDomain',
                'DisassociateInstanceStorageConfig',
                'DisassociateLambdaFunction',
                'DisassociateLexBot',
                'DisassociatePhoneNumberContactFlow',
                'DisassociateQueueQuickConnects',
                'DisassociateRoutingProfileQueues',
                'DisassociateSecurityKey',
                'GetFederationTokens',
                'PutUserStatus',
                'ReleasePhoneNumber',
                'ResumeContactRecording',
                'StartChatContact',
                'StartContactRecording',
                'StartContactStreaming',
                'StartOutboundVoiceContact',
                'StartTaskContact',
                'StopContact',
                'StopContactRecording',
                'StopContactStreaming',
                'SuspendContactRecording',
                'UpdateAgentStatus',
                'UpdateContact',
                'UpdateContactAttributes',
                'UpdateContactFlowContent',
                'UpdateContactFlowMetadata',
                'UpdateContactFlowModuleContent',
                'UpdateContactFlowModuleMetadata',
                'UpdateContactFlowName',
                'UpdateContactSchedule',
                'UpdateHoursOfOperation',
                'UpdateInstanceAttribute',
                'UpdateInstanceStorageConfig',
                'UpdatePhoneNumber',
                'UpdateQueueHoursOfOperation',
                'UpdateQueueMaxContacts',
                'UpdateQueueName',
                'UpdateQueueOutboundCallerConfig',
                'UpdateQueueStatus',
                'UpdateQuickConnectConfig',
                'UpdateQuickConnectName',
                'UpdateRoutingProfileConcurrency',
                'UpdateRoutingProfileDefaultOutboundQueue',
                'UpdateRoutingProfileName',
                'UpdateRoutingProfileQueues',
                'UpdateSecurityProfile',
                'UpdateUserHierarchy',
                'UpdateUserHierarchyGroupName',
                'UpdateUserHierarchyStructure',
                'UpdateUserIdentityInfo',
                'UpdateUserPhoneConfig',
                'UpdateUserRoutingProfile',
                'UpdateUserSecurityProfiles',
                'UpdatedescribeContent'
            ],
            Read: [
                'DescribeAgentStatus',
                'DescribeContact',
                'DescribeContactFlow',
                'DescribeContactFlowModule',
                'DescribeHoursOfOperation',
                'DescribeInstance',
                'DescribeInstanceAttribute',
                'DescribeInstanceStorageConfig',
                'DescribeQueue',
                'DescribeQuickConnect',
                'DescribeRoutingProfile',
                'DescribeSecurityProfile',
                'DescribeUser',
                'DescribeUserHierarchyGroup',
                'DescribeUserHierarchyStructure',
                'DescribeVocabulary',
                'GetContactAttributes',
                'GetCurrentMetricData',
                'GetFederationToken',
                'GetMetricData',
                'ListRealtimeContactAnalysisSegments',
                'ListTagsForResource',
                'SearchUsers'
            ],
            List: [
                'DescribePhoneNumber',
                'ListAgentStatuses',
                'ListApprovedOrigins',
                'ListBots',
                'ListContactFlowModules',
                'ListContactFlows',
                'ListContactReferences',
                'ListDefaultVocabularies',
                'ListHoursOfOperations',
                'ListInstanceAttributes',
                'ListInstanceStorageConfigs',
                'ListInstances',
                'ListIntegrationAssociations',
                'ListLambdaFunctions',
                'ListLexBots',
                'ListPhoneNumbers',
                'ListPhoneNumbersV2',
                'ListPrompts',
                'ListQueueQuickConnects',
                'ListQueues',
                'ListQuickConnects',
                'ListRoutingProfileQueues',
                'ListRoutingProfiles',
                'ListSecurityKeys',
                'ListSecurityProfilePermissions',
                'ListSecurityProfiles',
                'ListUseCases',
                'ListUserHierarchyGroups',
                'ListUsers',
                'SearchAvailablePhoneNumbers',
                'SearchVocabularies'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to associate approved origin for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toAssociateApprovedOrigin() {
        return this.to('AssociateApprovedOrigin');
    }
    /**
     * Grants permission to associate a Lex bot for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - lex:CreateResourcePolicy
     * - lex:DescribeBotAlias
     * - lex:GetBot
     * - lex:UpdateResourcePolicy
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toAssociateBot() {
        return this.to('AssociateBot');
    }
    /**
     * Grants permission to associate a Customer Profiles domain for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - profile:GetDomain
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toAssociateCustomerProfilesDomain() {
        return this.to('AssociateCustomerProfilesDomain');
    }
    /**
     * Grants permission to default vocabulary for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     */
    toAssociateDefaultVocabulary() {
        return this.to('AssociateDefaultVocabulary');
    }
    /**
     * Grants permission to associate instance storage for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifStorageResourceType()
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - ds:DescribeDirectories
     * - firehose:DescribeDeliveryStream
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - kinesis:DescribeStream
     * - kms:CreateGrant
     * - kms:DescribeKey
     * - s3:GetBucketAcl
     * - s3:GetBucketLocation
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toAssociateInstanceStorageConfig() {
        return this.to('AssociateInstanceStorageConfig');
    }
    /**
     * Grants permission to associate a Lambda function for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - lambda:AddPermission
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toAssociateLambdaFunction() {
        return this.to('AssociateLambdaFunction');
    }
    /**
     * Grants permission to associate a Lex bot for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - lex:GetBot
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toAssociateLexBot() {
        return this.to('AssociateLexBot');
    }
    /**
     * Grants permission to associate contact flow resources to phone number resources in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_AssociatePhoneNumberContactFlow.html
     */
    toAssociatePhoneNumberContactFlow() {
        return this.to('AssociatePhoneNumberContactFlow');
    }
    /**
     * Grants permission to associate quick connects with a queue in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_AssociateQueueQuickConnects.html
     */
    toAssociateQueueQuickConnects() {
        return this.to('AssociateQueueQuickConnects');
    }
    /**
     * Grants permission to associate queues with a routing profile in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_AssociateRoutingProfileQueues.html
     */
    toAssociateRoutingProfileQueues() {
        return this.to('AssociateRoutingProfileQueues');
    }
    /**
     * Grants permission to associate a security key for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toAssociateSecurityKey() {
        return this.to('AssociateSecurityKey');
    }
    /**
     * Grants permission to grant access and to associate the datasets with the specified AWS account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/optimization-apis.html
     */
    toBatchAssociateAnalyticsDataSet() {
        return this.to('BatchAssociateAnalyticsDataSet');
    }
    /**
     * Grants permission to revoke access and to disassociate the datasets with the specified AWS account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/optimization-apis.html
     */
    toBatchDisassociateAnalyticsDataSet() {
        return this.to('BatchDisassociateAnalyticsDataSet');
    }
    /**
     * Grants permission to claim phone number resources in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html
     */
    toClaimPhoneNumber() {
        return this.to('ClaimPhoneNumber');
    }
    /**
     * Grants permission to create agent status in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateAgentStatus.html
     */
    toCreateAgentStatus() {
        return this.to('CreateAgentStatus');
    }
    /**
     * Grants permission to create a contact flow in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateContactFlow.html
     */
    toCreateContactFlow() {
        return this.to('CreateContactFlow');
    }
    /**
     * Grants permission to create a contact flow module in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateContactFlowModule.html
     */
    toCreateContactFlowModule() {
        return this.to('CreateContactFlowModule');
    }
    /**
     * Grants permission to create hours of operation in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateHoursOfOperation.html
     */
    toCreateHoursOfOperation() {
        return this.to('CreateHoursOfOperation');
    }
    /**
     * Grants permission to create a new Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - ds:AuthorizeApplication
     * - ds:CheckAlias
     * - ds:CreateAlias
     * - ds:CreateDirectory
     * - ds:CreateIdentityPoolDirectory
     * - ds:DeleteDirectory
     * - ds:DescribeDirectories
     * - ds:UnauthorizeApplication
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toCreateInstance() {
        return this.to('CreateInstance');
    }
    /**
     * Grants permission to create an integration association with an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - app-integrations:CreateEventIntegrationAssociation
     * - connect:DescribeInstance
     * - ds:DescribeDirectories
     * - events:PutRule
     * - events:PutTargets
     * - mobiletargeting:GetApp
     * - voiceid:DescribeDomain
     * - wisdom:GetAssistant
     * - wisdom:GetKnowledgeBase
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateIntegrationAssociation.html
     */
    toCreateIntegrationAssociation() {
        return this.to('CreateIntegrationAssociation');
    }
    /**
     * Grants permission to create a queue in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateQueue.html
     */
    toCreateQueue() {
        return this.to('CreateQueue');
    }
    /**
     * Grants permission to create a quick connect in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateQuickConnect.html
     */
    toCreateQuickConnect() {
        return this.to('CreateQuickConnect');
    }
    /**
     * Grants permission to create a routing profile in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateRoutingProfile.html
     */
    toCreateRoutingProfile() {
        return this.to('CreateRoutingProfile');
    }
    /**
     * Grants permission to create a security profile for the specified Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateSecurityProfile.html
     */
    toCreateSecurityProfile() {
        return this.to('CreateSecurityProfile');
    }
    /**
     * Grants permission to create a use case for an integration association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - connect:DescribeInstance
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateUseCase.html
     */
    toCreateUseCase() {
        return this.to('CreateUseCase');
    }
    /**
     * Grants permission to create a user for the specified Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateUser.html
     */
    toCreateUser() {
        return this.to('CreateUser');
    }
    /**
     * Grants permission to create a user hierarchy group in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateUserHierarchyGroup.html
     */
    toCreateUserHierarchyGroup() {
        return this.to('CreateUserHierarchyGroup');
    }
    /**
     * Grants permission to create a vocabulary in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateVocabulary.html
     */
    toCreateVocabulary() {
        return this.to('CreateVocabulary');
    }
    /**
     * Grants permission to delete a contact flow in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteContactFlow.html
     */
    toDeleteContactFlow() {
        return this.to('DeleteContactFlow');
    }
    /**
     * Grants permission to delete a contact flow module in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteContactFlowModule.html
     */
    toDeleteContactFlowModule() {
        return this.to('DeleteContactFlowModule');
    }
    /**
     * Grants permission to delete hours of operation in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteHoursOfOperation.html
     */
    toDeleteHoursOfOperation() {
        return this.to('DeleteHoursOfOperation');
    }
    /**
     * Grants permission to delete an Amazon Connect instance. When you remove an instance, the link to an existing AWS directory is also removed
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ds:DeleteDirectory
     * - ds:DescribeDirectories
     * - ds:UnauthorizeApplication
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDeleteInstance() {
        return this.to('DeleteInstance');
    }
    /**
     * Grants permission to delete an integration association from an Amazon Connect instance. The association must not have any use cases associated with it
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - app-integrations:DeleteEventIntegrationAssociation
     * - connect:DescribeInstance
     * - ds:DescribeDirectories
     * - events:DeleteRule
     * - events:ListTargetsByRule
     * - events:RemoveTargets
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteIntegrationAssociation.html
     */
    toDeleteIntegrationAssociation() {
        return this.to('DeleteIntegrationAssociation');
    }
    /**
     * Grants permission to delete a quick connect in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteQuickConnect.html
     */
    toDeleteQuickConnect() {
        return this.to('DeleteQuickConnect');
    }
    /**
     * Grants permission to delete a security profile in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteSecurityProfile.html
     */
    toDeleteSecurityProfile() {
        return this.to('DeleteSecurityProfile');
    }
    /**
     * Grants permission to delete a use case from an integration association
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - connect:DescribeInstance
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteUseCase.html
     */
    toDeleteUseCase() {
        return this.to('DeleteUseCase');
    }
    /**
     * Grants permission to delete a user in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteUser.html
     */
    toDeleteUser() {
        return this.to('DeleteUser');
    }
    /**
     * Grants permission to delete a user hierarchy group in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteUserHierarchyGroup.html
     */
    toDeleteUserHierarchyGroup() {
        return this.to('DeleteUserHierarchyGroup');
    }
    /**
     * Grants permission to delete a vocabulary in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteVocabulary.html
     */
    toDeleteVocabulary() {
        return this.to('DeleteVocabulary');
    }
    /**
     * Grants permission to describe agent status in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeAgentStatus.html
     */
    toDescribeAgentStatus() {
        return this.to('DescribeAgentStatus');
    }
    /**
     * Grants permission to describe a contact in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeContact.html
     */
    toDescribeContact() {
        return this.to('DescribeContact');
    }
    /**
     * Grants permission to describe a contact flow in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeContactFlow.html
     */
    toDescribeContactFlow() {
        return this.to('DescribeContactFlow');
    }
    /**
     * Grants permission to describe a contact flow module in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeContactFlowModule.html
     */
    toDescribeContactFlowModule() {
        return this.to('DescribeContactFlowModule');
    }
    /**
     * Grants permission to describe hours of operation in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeHoursOfOperation.html
     */
    toDescribeHoursOfOperation() {
        return this.to('DescribeHoursOfOperation');
    }
    /**
     * Grants permission to view details of an Amazon Connect instance and is also required to create an instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     * - .ifAwsResourceTag()
     *
     * Dependent actions:
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDescribeInstance() {
        return this.to('DescribeInstance');
    }
    /**
     * Grants permission to view the attribute details of an existing Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAttributeType()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDescribeInstanceAttribute() {
        return this.to('DescribeInstanceAttribute');
    }
    /**
     * Grants permission to view the instance storage configuration for an existing Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifStorageResourceType()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDescribeInstanceStorageConfig() {
        return this.to('DescribeInstanceStorageConfig');
    }
    /**
     * Grants permission to describe phone number resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html
     */
    toDescribePhoneNumber() {
        return this.to('DescribePhoneNumber');
    }
    /**
     * Grants permission to describe a queue in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeQueue.html
     */
    toDescribeQueue() {
        return this.to('DescribeQueue');
    }
    /**
     * Grants permission to describe a quick connect in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeQuickConnect.html
     */
    toDescribeQuickConnect() {
        return this.to('DescribeQuickConnect');
    }
    /**
     * Grants permission to describe a routing profile in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeRoutingProfile.html
     */
    toDescribeRoutingProfile() {
        return this.to('DescribeRoutingProfile');
    }
    /**
     * Grants permission to describe a security profile in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeSecurityProfile.html
     */
    toDescribeSecurityProfile() {
        return this.to('DescribeSecurityProfile');
    }
    /**
     * Grants permission to describe a user in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeUser.html
     */
    toDescribeUser() {
        return this.to('DescribeUser');
    }
    /**
     * Grants permission to describe a hierarchy group for an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeUserHierarchyGroup.html
     */
    toDescribeUserHierarchyGroup() {
        return this.to('DescribeUserHierarchyGroup');
    }
    /**
     * Grants permission to describe the hierarchy structure for an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeUserHierarchyStructure.html
     */
    toDescribeUserHierarchyStructure() {
        return this.to('DescribeUserHierarchyStructure');
    }
    /**
     * Grants permission to describe a vocabulary in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeVocabulary.html
     */
    toDescribeVocabulary() {
        return this.to('DescribeVocabulary');
    }
    /**
     * Grants permission to disassociate approved origin for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDisassociateApprovedOrigin() {
        return this.to('DisassociateApprovedOrigin');
    }
    /**
     * Grants permission to disassociate a Lex bot for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - lex:DeleteResourcePolicy
     * - lex:UpdateResourcePolicy
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDisassociateBot() {
        return this.to('DisassociateBot');
    }
    /**
     * Grants permission to disassociate a Customer Profiles domain for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:AttachRolePolicy
     * - iam:DeleteRolePolicy
     * - iam:DetachRolePolicy
     * - iam:GetPolicy
     * - iam:GetPolicyVersion
     * - iam:GetRolePolicy
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDisassociateCustomerProfilesDomain() {
        return this.to('DisassociateCustomerProfilesDomain');
    }
    /**
     * Grants permission to disassociate instance storage for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifStorageResourceType()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDisassociateInstanceStorageConfig() {
        return this.to('DisassociateInstanceStorageConfig');
    }
    /**
     * Grants permission to disassociate a Lambda function for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - lambda:RemovePermission
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDisassociateLambdaFunction() {
        return this.to('DisassociateLambdaFunction');
    }
    /**
     * Grants permission to disassociate a Lex bot for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDisassociateLexBot() {
        return this.to('DisassociateLexBot');
    }
    /**
     * Grants permission to disassociate contact flow resources from phone number resources in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DisassociatePhoneNumberContactFlow.html
     */
    toDisassociatePhoneNumberContactFlow() {
        return this.to('DisassociatePhoneNumberContactFlow');
    }
    /**
     * Grants permission to disassociate quick connects from a queue in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DisassociateQueueQuickConnects.html
     */
    toDisassociateQueueQuickConnects() {
        return this.to('DisassociateQueueQuickConnects');
    }
    /**
     * Grants permission to disassociate queues from a routing profile in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_DisassociateRoutingProfileQueues.html
     */
    toDisassociateRoutingProfileQueues() {
        return this.to('DisassociateRoutingProfileQueues');
    }
    /**
     * Grants permission to disassociate the security key for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toDisassociateSecurityKey() {
        return this.to('DisassociateSecurityKey');
    }
    /**
     * Grants permission to retrieve the contact attributes for the specified contact
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_GetContactAttributes.html
     */
    toGetContactAttributes() {
        return this.to('GetContactAttributes');
    }
    /**
     * Grants permission to retrieve current metric data for the queues in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_GetCurrentMetricData.html
     */
    toGetCurrentMetricData() {
        return this.to('GetCurrentMetricData');
    }
    /**
     * Grants permission to federate into an Amazon Connect instance when using SAML-based authentication for identity management
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_GetFederationToken.html
     */
    toGetFederationToken() {
        return this.to('GetFederationToken');
    }
    /**
     * Grants permission to federate into an Amazon Connect instance (Log in for emergency access functionality in the Amazon Connect console)
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - connect:DescribeInstance
     * - connect:ListInstances
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/emergency-admin-login.html
     */
    toGetFederationTokens() {
        return this.to('GetFederationTokens');
    }
    /**
     * Grants permission to retrieve historical metric data for queues in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricData.html
     */
    toGetMetricData() {
        return this.to('GetMetricData');
    }
    /**
     * Grants permission to list agent statuses in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListAgentStatuses.html
     */
    toListAgentStatuses() {
        return this.to('ListAgentStatuses');
    }
    /**
     * Grants permission to view approved origins of an existing Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListApprovedOrigins() {
        return this.to('ListApprovedOrigins');
    }
    /**
     * Grants permission to view the Lex bots of an existing Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListBots() {
        return this.to('ListBots');
    }
    /**
     * Grants permission to list contact flow module resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListContactFlowModules.html
     */
    toListContactFlowModules() {
        return this.to('ListContactFlowModules');
    }
    /**
     * Grants permission to list contact flow resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListContactFlows.html
     */
    toListContactFlows() {
        return this.to('ListContactFlows');
    }
    /**
     * Grants permission to list references associated with a contact in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListContactReferences.html
     */
    toListContactReferences() {
        return this.to('ListContactReferences');
    }
    /**
     * Grants permission to list default vocabularies associated with a Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListDefaultVocabularies.html
     */
    toListDefaultVocabularies() {
        return this.to('ListDefaultVocabularies');
    }
    /**
     * Grants permission to list hours of operation resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListHoursOfOperations.html
     */
    toListHoursOfOperations() {
        return this.to('ListHoursOfOperations');
    }
    /**
     * Grants permission to view the attributes of an existing Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListInstanceAttributes() {
        return this.to('ListInstanceAttributes');
    }
    /**
     * Grants permission to view storage configurations of an existing Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListInstanceStorageConfigs() {
        return this.to('ListInstanceStorageConfigs');
    }
    /**
     * Grants permission to view the Amazon Connect instances associated with an AWS account
     *
     * Access Level: List
     *
     * Dependent actions:
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListInstances() {
        return this.to('ListInstances');
    }
    /**
     * Grants permission to list summary information about the integration associations for the specified Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - connect:DescribeInstance
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListIntegrationAssociations.html
     */
    toListIntegrationAssociations() {
        return this.to('ListIntegrationAssociations');
    }
    /**
     * Grants permission to view the Lambda functions of an existing Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListLambdaFunctions() {
        return this.to('ListLambdaFunctions');
    }
    /**
     * Grants permission to view the Lex bots of an existing Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListLexBots() {
        return this.to('ListLexBots');
    }
    /**
     * Grants permission to list phone number resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbers.html
     */
    toListPhoneNumbers() {
        return this.to('ListPhoneNumbers');
    }
    /**
     * Grants permission to list phone number resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html
     */
    toListPhoneNumbersV2() {
        return this.to('ListPhoneNumbersV2');
    }
    /**
     * Grants permission to list prompt resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPrompts.html
     */
    toListPrompts() {
        return this.to('ListPrompts');
    }
    /**
     * Grants permission to list quick connect resources in a queue in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListQueueQuickConnects.html
     */
    toListQueueQuickConnects() {
        return this.to('ListQueueQuickConnects');
    }
    /**
     * Grants permission to list queue resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListQueues.html
     */
    toListQueues() {
        return this.to('ListQueues');
    }
    /**
     * Grants permission to list quick connect resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListQuickConnects.html
     */
    toListQuickConnects() {
        return this.to('ListQuickConnects');
    }
    /**
     * Grants permission to list the analysis segments for a real-time analysis session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/contact-lens/latest/APIReference/API_ListRealtimeContactAnalysisSegments.html
     */
    toListRealtimeContactAnalysisSegments() {
        return this.to('ListRealtimeContactAnalysisSegments');
    }
    /**
     * Grants permission to list queue resources in a routing profile in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListRoutingProfileQueues.html
     */
    toListRoutingProfileQueues() {
        return this.to('ListRoutingProfileQueues');
    }
    /**
     * Grants permission to list routing profile resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListRoutingProfiles.html
     */
    toListRoutingProfiles() {
        return this.to('ListRoutingProfiles');
    }
    /**
     * Grants permission to view the security keys of an existing Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toListSecurityKeys() {
        return this.to('ListSecurityKeys');
    }
    /**
     * Grants permission to list permissions associated with security profile in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListSecurityProfilePermissions.html
     */
    toListSecurityProfilePermissions() {
        return this.to('ListSecurityProfilePermissions');
    }
    /**
     * Grants permission to list security profile resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListSecurityProfiles.html
     */
    toListSecurityProfiles() {
        return this.to('ListSecurityProfiles');
    }
    /**
     * Grants permission to list tags for an Amazon Connect resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list the use cases of an integration association
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - connect:DescribeInstance
     * - ds:DescribeDirectories
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListUseCases.html
     */
    toListUseCases() {
        return this.to('ListUseCases');
    }
    /**
     * Grants permission to list the hierarchy group resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListUserHierarchyGroups.html
     */
    toListUserHierarchyGroups() {
        return this.to('ListUserHierarchyGroups');
    }
    /**
     * Grants permission to list user resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ListUsers.html
     */
    toListUsers() {
        return this.to('ListUsers');
    }
    /**
     * Grants permission to switch User Status in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_PutUserStatus.html
     */
    toPutUserStatus() {
        return this.to('PutUserStatus');
    }
    /**
     * Grants permission to release phone number resources in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ReleasePhoneNumber.html
     */
    toReleasePhoneNumber() {
        return this.to('ReleasePhoneNumber');
    }
    /**
     * Grants permission to resume recording for the specified contact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_ResumeContactRecording.html
     */
    toResumeContactRecording() {
        return this.to('ResumeContactRecording');
    }
    /**
     * Grants permission to search phone number resources in an Amazon Connect instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchAvailablePhoneNumbers.html
     */
    toSearchAvailablePhoneNumbers() {
        return this.to('SearchAvailablePhoneNumbers');
    }
    /**
     * Grants permission to search user resources in an Amazon Connect instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifInstanceId()
     * - .ifSearchTag()
     *
     * Dependent actions:
     * - connect:DescribeUser
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchUsers.html
     */
    toSearchUsers() {
        return this.to('SearchUsers');
    }
    /**
     * Grants permission to search vocabularies in a Amazon Connect instance
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchVocabularies.html
     */
    toSearchVocabularies() {
        return this.to('SearchVocabularies');
    }
    /**
     * Grants permission to initiate a chat using the Amazon Connect API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_StartChatContact.html
     */
    toStartChatContact() {
        return this.to('StartChatContact');
    }
    /**
     * Grants permission to start recording for the specified contact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactRecording.html
     */
    toStartContactRecording() {
        return this.to('StartContactRecording');
    }
    /**
     * Grants permission to start chat streaming using the Amazon Connect API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactStreaming.html
     */
    toStartContactStreaming() {
        return this.to('StartContactStreaming');
    }
    /**
     * Grants permission to initiate outbound calls using the Amazon Connect API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_StartOutboundVoiceContact.html
     */
    toStartOutboundVoiceContact() {
        return this.to('StartOutboundVoiceContact');
    }
    /**
     * Grants permission to initiate a task using the Amazon Connect API
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_StartTaskContact.html
     */
    toStartTaskContact() {
        return this.to('StartTaskContact');
    }
    /**
     * Grants permission to stop contacts that were initiated using the Amazon Connect API. If you use this operation on an active contact the contact ends, even if the agent is active on a call with a customer
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_StopContact.html
     */
    toStopContact() {
        return this.to('StopContact');
    }
    /**
     * Grants permission to stop recording for the specified contact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_StopContactRecording.html
     */
    toStopContactRecording() {
        return this.to('StopContactRecording');
    }
    /**
     * Grants permission to stop chat streaming using the Amazon Connect API
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_StopContactStreaming.html
     */
    toStopContactStreaming() {
        return this.to('StopContactStreaming');
    }
    /**
     * Grants permission to suspend recording for the specified contact
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_SuspendContactRecording.html
     */
    toSuspendContactRecording() {
        return this.to('SuspendContactRecording');
    }
    /**
     * Grants permission to tag an Amazon Connect resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to untag an Amazon Connect resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update agent status in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateAgentStatus.html
     */
    toUpdateAgentStatus() {
        return this.to('UpdateAgentStatus');
    }
    /**
     * Grants permission to update a contact in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContact.html
     */
    toUpdateContact() {
        return this.to('UpdateContact');
    }
    /**
     * Grants permission to create or update the contact attributes associated with the specified contact
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContactAttributes.html
     */
    toUpdateContactAttributes() {
        return this.to('UpdateContactAttributes');
    }
    /**
     * Grants permission to update contact flow content in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContactFlowContent.html
     */
    toUpdateContactFlowContent() {
        return this.to('UpdateContactFlowContent');
    }
    /**
     * Grants permission to update the metadata of a contact flow in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContactFlowMetadata.html
     */
    toUpdateContactFlowMetadata() {
        return this.to('UpdateContactFlowMetadata');
    }
    /**
     * Grants permission to update contact flow module content in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContactFlowModuleContent.html
     */
    toUpdateContactFlowModuleContent() {
        return this.to('UpdateContactFlowModuleContent');
    }
    /**
     * Grants permission to update the metadata of a contact flow module in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContactFlowModuleMetadata.html
     */
    toUpdateContactFlowModuleMetadata() {
        return this.to('UpdateContactFlowModuleMetadata');
    }
    /**
     * Grants permission to update the name and description of a contact flow in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContactFlowName.html
     */
    toUpdateContactFlowName() {
        return this.to('UpdateContactFlowName');
    }
    /**
     * Grants permission to update the schedule of a contact that is already scheduled in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateContactSchedule.html
     */
    toUpdateContactSchedule() {
        return this.to('UpdateContactSchedule');
    }
    /**
     * Grants permission to update hours of operation in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateHoursOfOperation.html
     */
    toUpdateHoursOfOperation() {
        return this.to('UpdateHoursOfOperation');
    }
    /**
     * Grants permission to update the attribute for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAttributeType()
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - ds:DescribeDirectories
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - logs:CreateLogGroup
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toUpdateInstanceAttribute() {
        return this.to('UpdateInstanceAttribute');
    }
    /**
     * Grants permission to update the storage configuration for an existing Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifStorageResourceType()
     * - .ifInstanceId()
     *
     * Dependent actions:
     * - ds:DescribeDirectories
     * - firehose:DescribeDeliveryStream
     * - iam:AttachRolePolicy
     * - iam:CreateServiceLinkedRole
     * - iam:PutRolePolicy
     * - kinesis:DescribeStream
     * - kms:CreateGrant
     * - kms:DescribeKey
     * - s3:GetBucketAcl
     * - s3:GetBucketLocation
     *
     * https://docs.aws.amazon.com/console/connect/amazon-connect-console/grant-instance-permissions
     */
    toUpdateInstanceStorageConfig() {
        return this.to('UpdateInstanceStorageConfig');
    }
    /**
     * Grants permission to update phone number resources in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html
     */
    toUpdatePhoneNumber() {
        return this.to('UpdatePhoneNumber');
    }
    /**
     * Grants permission to update queue hours of operation in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateQueueHoursOfOperation.html
     */
    toUpdateQueueHoursOfOperation() {
        return this.to('UpdateQueueHoursOfOperation');
    }
    /**
     * Grants permission to update queue capacity in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateQueueMaxContacts.html
     */
    toUpdateQueueMaxContacts() {
        return this.to('UpdateQueueMaxContacts');
    }
    /**
     * Grants permission to update a queue name and description in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateQueueName.html
     */
    toUpdateQueueName() {
        return this.to('UpdateQueueName');
    }
    /**
     * Grants permission to update queue outbound caller config in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateQueueOutboundCallerConfig.html
     */
    toUpdateQueueOutboundCallerConfig() {
        return this.to('UpdateQueueOutboundCallerConfig');
    }
    /**
     * Grants permission to update queue status in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateQueueStatus.html
     */
    toUpdateQueueStatus() {
        return this.to('UpdateQueueStatus');
    }
    /**
     * Grants permission to update the configuration of a quick connect in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateQuickConnectConfig.html
     */
    toUpdateQuickConnectConfig() {
        return this.to('UpdateQuickConnectConfig');
    }
    /**
     * Grants permission to update a quick connect name and description in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateQuickConnectName.html
     */
    toUpdateQuickConnectName() {
        return this.to('UpdateQuickConnectName');
    }
    /**
     * Grants permission to update the concurrency in a routing profile in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateRoutingProfileConcurrency.html
     */
    toUpdateRoutingProfileConcurrency() {
        return this.to('UpdateRoutingProfileConcurrency');
    }
    /**
     * Grants permission to update the outbound queue in a routing profile in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateRoutingProfileDefaultOutboundQueue.html
     */
    toUpdateRoutingProfileDefaultOutboundQueue() {
        return this.to('UpdateRoutingProfileDefaultOutboundQueue');
    }
    /**
     * Grants permission to update a routing profile name and description in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateRoutingProfileName.html
     */
    toUpdateRoutingProfileName() {
        return this.to('UpdateRoutingProfileName');
    }
    /**
     * Grants permission to update the queues in routing profile in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateRoutingProfileQueues.html
     */
    toUpdateRoutingProfileQueues() {
        return this.to('UpdateRoutingProfileQueues');
    }
    /**
     * Grants permission to update a security profile group for a user in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateSecurityProfile.html
     */
    toUpdateSecurityProfile() {
        return this.to('UpdateSecurityProfile');
    }
    /**
     * Grants permission to update a hierarchy group for a user in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateUserHierarchy.html
     */
    toUpdateUserHierarchy() {
        return this.to('UpdateUserHierarchy');
    }
    /**
     * Grants permission to update a user hierarchy group name in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateUserHierarchyGroupName.html
     */
    toUpdateUserHierarchyGroupName() {
        return this.to('UpdateUserHierarchyGroupName');
    }
    /**
     * Grants permission to update user hierarchy structure in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateUserHierarchyStructure.html
     */
    toUpdateUserHierarchyStructure() {
        return this.to('UpdateUserHierarchyStructure');
    }
    /**
     * Grants permission to update identity information for a user in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateUserIdentityInfo.html
     */
    toUpdateUserIdentityInfo() {
        return this.to('UpdateUserIdentityInfo');
    }
    /**
     * Grants permission to update phone configuration settings for a user in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateUserPhoneConfig.html
     */
    toUpdateUserPhoneConfig() {
        return this.to('UpdateUserPhoneConfig');
    }
    /**
     * Grants permission to update a routing profile for a user in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateUserRoutingProfile.html
     */
    toUpdateUserRoutingProfile() {
        return this.to('UpdateUserRoutingProfile');
    }
    /**
     * Grants permission to update security profiles for a user in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateUserSecurityProfiles.html
     */
    toUpdateUserSecurityProfiles() {
        return this.to('UpdateUserSecurityProfiles');
    }
    /**
     * Grants permission to update contact flow module content in an Amazon Connect instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInstanceId()
     *
     * https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatedescribeContent.html
     */
    toUpdatedescribeContent() {
        return this.to('UpdatedescribeContent');
    }
    /**
     * Adds a resource of type instance to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-instances.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onInstance(instanceId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}`);
    }
    /**
     * Adds a resource of type contact to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/connect-contact-attributes.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param contactId - Identifier for the contactId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onContact(instanceId, contactId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/contact/${contactId}`);
    }
    /**
     * Adds a resource of type user to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/connect-agents.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param userId - Identifier for the userId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onUser(instanceId, userId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/agent/${userId}`);
    }
    /**
     * Adds a resource of type routing-profile to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/routing-profiles.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param routingProfileId - Identifier for the routingProfileId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRoutingProfile(instanceId, routingProfileId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/routing-profile/${routingProfileId}`);
    }
    /**
     * Adds a resource of type security-profile to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param securityProfileId - Identifier for the securityProfileId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSecurityProfile(instanceId, securityProfileId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/security-profile/${securityProfileId}`);
    }
    /**
     * Adds a resource of type hierarchy-group to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/agent-hierarchy.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param hierarchyGroupId - Identifier for the hierarchyGroupId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onHierarchyGroup(instanceId, hierarchyGroupId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/agent-group/${hierarchyGroupId}`);
    }
    /**
     * Adds a resource of type queue to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/API_Queue.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param queueId - Identifier for the queueId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onQueue(instanceId, queueId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/queue/${queueId}`);
    }
    /**
     * Adds a resource of type wildcard-queue to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/API_Queue.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onWildcardQueue(instanceId, resourceName, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/queue/${resourceName}`);
    }
    /**
     * Adds a resource of type quick-connect to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/quick-connects.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param quickConnectId - Identifier for the quickConnectId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onQuickConnect(instanceId, quickConnectId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/transfer-destination/${quickConnectId}`);
    }
    /**
     * Adds a resource of type wildcard-quick-connect to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/quick-connects.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onWildcardQuickConnect(instanceId, resourceName, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/transfer-destination/${resourceName}`);
    }
    /**
     * Adds a resource of type contact-flow to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/connect-contact-flows.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param contactFlowId - Identifier for the contactFlowId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onContactFlow(instanceId, contactFlowId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/contact-flow/${contactFlowId}`);
    }
    /**
     * Adds a resource of type contact-flow-module to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/contact-flow-modules.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param contactFlowModuleId - Identifier for the contactFlowModuleId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onContactFlowModule(instanceId, contactFlowModuleId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/flow-module/${contactFlowModuleId}`);
    }
    /**
     * Adds a resource of type wildcard-contact-flow to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/connect-contact-flows.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onWildcardContactFlow(instanceId, resourceName, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/contact-flow/${resourceName}`);
    }
    /**
     * Adds a resource of type hours-of-operation to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/API_HoursOfOperation.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param hoursOfOperationId - Identifier for the hoursOfOperationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onHoursOfOperation(instanceId, hoursOfOperationId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/operating-hours/${hoursOfOperationId}`);
    }
    /**
     * Adds a resource of type agent-status to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/agent-status.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param agentStatusId - Identifier for the agentStatusId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAgentStatus(instanceId, agentStatusId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/agent-state/${agentStatusId}`);
    }
    /**
     * Adds a resource of type wildcard-agent-status to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/agent-status.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onWildcardAgentStatus(instanceId, resourceName, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/agent-state/${resourceName}`);
    }
    /**
     * Adds a resource of type legacy-phone-number to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param phoneNumberId - Identifier for the phoneNumberId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onLegacyPhoneNumber(instanceId, phoneNumberId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/phone-number/${phoneNumberId}`);
    }
    /**
     * Adds a resource of type wildcard-legacy-phone-number to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onWildcardLegacyPhoneNumber(instanceId, resourceName, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/phone-number/${resourceName}`);
    }
    /**
     * Adds a resource of type phone-number to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html
     *
     * @param phoneNumberId - Identifier for the phoneNumberId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPhoneNumber(phoneNumberId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:phone-number/${phoneNumberId}`);
    }
    /**
     * Adds a resource of type wildcard-phone-number to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html
     *
     * @param resourceName - Identifier for the resourceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWildcardPhoneNumber(resourceName, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:phone-number/${resourceName}`);
    }
    /**
     * Adds a resource of type integration-association to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/API_IntegrationAssociationSummary.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param integrationAssociationId - Identifier for the integrationAssociationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onIntegrationAssociation(instanceId, integrationAssociationId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/integration-association/${integrationAssociationId}`);
    }
    /**
     * Adds a resource of type use-case to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/API_UseCase.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param useCaseId - Identifier for the useCaseId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onUseCase(instanceId, useCaseId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/use-case/${useCaseId}`);
    }
    /**
     * Adds a resource of type vocabulary to the statement
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/API_Vocabulary.html
     *
     * @param instanceId - Identifier for the instanceId.
     * @param vocabularyId - Identifier for the vocabularyId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onVocabulary(instanceId, vocabularyId, account, region, partition) {
        return this.on(`arn:${partition || Connect.defaultPartition}:connect:${region || '*'}:${account || '*'}:instance/${instanceId}/vocabulary/${vocabularyId}`);
    }
    /**
     * Filters access by the attribute type of the Amazon Connect instance
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_service-with-iam.html
     *
     * Applies to actions:
     * - .toDescribeInstanceAttribute()
     * - .toUpdateInstanceAttribute()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifAttributeType(value, operator) {
        return this.if(`AttributeType`, value, operator || 'StringLike');
    }
    /**
     * Filters access by restricting federation into specified Amazon Connect instances
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_service-with-iam.html
     *
     * Applies to actions:
     * - .toAssociateApprovedOrigin()
     * - .toAssociateBot()
     * - .toAssociateDefaultVocabulary()
     * - .toAssociateInstanceStorageConfig()
     * - .toAssociateLambdaFunction()
     * - .toAssociateLexBot()
     * - .toAssociatePhoneNumberContactFlow()
     * - .toAssociateQueueQuickConnects()
     * - .toAssociateRoutingProfileQueues()
     * - .toAssociateSecurityKey()
     * - .toBatchAssociateAnalyticsDataSet()
     * - .toBatchDisassociateAnalyticsDataSet()
     * - .toCreateAgentStatus()
     * - .toCreateContactFlow()
     * - .toCreateContactFlowModule()
     * - .toCreateHoursOfOperation()
     * - .toCreateIntegrationAssociation()
     * - .toCreateQueue()
     * - .toCreateQuickConnect()
     * - .toCreateRoutingProfile()
     * - .toCreateSecurityProfile()
     * - .toCreateUseCase()
     * - .toCreateUser()
     * - .toCreateUserHierarchyGroup()
     * - .toCreateVocabulary()
     * - .toDeleteContactFlow()
     * - .toDeleteContactFlowModule()
     * - .toDeleteHoursOfOperation()
     * - .toDeleteInstance()
     * - .toDeleteIntegrationAssociation()
     * - .toDeleteQuickConnect()
     * - .toDeleteSecurityProfile()
     * - .toDeleteUseCase()
     * - .toDeleteUser()
     * - .toDeleteUserHierarchyGroup()
     * - .toDeleteVocabulary()
     * - .toDescribeAgentStatus()
     * - .toDescribeContact()
     * - .toDescribeContactFlow()
     * - .toDescribeContactFlowModule()
     * - .toDescribeHoursOfOperation()
     * - .toDescribeInstance()
     * - .toDescribeInstanceAttribute()
     * - .toDescribeInstanceStorageConfig()
     * - .toDescribeQueue()
     * - .toDescribeQuickConnect()
     * - .toDescribeRoutingProfile()
     * - .toDescribeSecurityProfile()
     * - .toDescribeUser()
     * - .toDescribeUserHierarchyGroup()
     * - .toDescribeUserHierarchyStructure()
     * - .toDescribeVocabulary()
     * - .toDisassociateApprovedOrigin()
     * - .toDisassociateBot()
     * - .toDisassociateInstanceStorageConfig()
     * - .toDisassociateLambdaFunction()
     * - .toDisassociateLexBot()
     * - .toDisassociatePhoneNumberContactFlow()
     * - .toDisassociateQueueQuickConnects()
     * - .toDisassociateRoutingProfileQueues()
     * - .toDisassociateSecurityKey()
     * - .toGetContactAttributes()
     * - .toGetCurrentMetricData()
     * - .toGetFederationToken()
     * - .toGetMetricData()
     * - .toListApprovedOrigins()
     * - .toListBots()
     * - .toListContactReferences()
     * - .toListDefaultVocabularies()
     * - .toListHoursOfOperations()
     * - .toListInstanceAttributes()
     * - .toListInstanceStorageConfigs()
     * - .toListIntegrationAssociations()
     * - .toListLambdaFunctions()
     * - .toListLexBots()
     * - .toListPrompts()
     * - .toListQueueQuickConnects()
     * - .toListRoutingProfileQueues()
     * - .toListRoutingProfiles()
     * - .toListSecurityKeys()
     * - .toListSecurityProfilePermissions()
     * - .toListSecurityProfiles()
     * - .toListUseCases()
     * - .toListUserHierarchyGroups()
     * - .toListUsers()
     * - .toPutUserStatus()
     * - .toSearchUsers()
     * - .toSearchVocabularies()
     * - .toStartTaskContact()
     * - .toStopContact()
     * - .toUpdateAgentStatus()
     * - .toUpdateContact()
     * - .toUpdateContactAttributes()
     * - .toUpdateContactFlowContent()
     * - .toUpdateContactFlowMetadata()
     * - .toUpdateContactFlowModuleContent()
     * - .toUpdateContactFlowModuleMetadata()
     * - .toUpdateContactFlowName()
     * - .toUpdateContactSchedule()
     * - .toUpdateHoursOfOperation()
     * - .toUpdateInstanceAttribute()
     * - .toUpdateInstanceStorageConfig()
     * - .toUpdateQueueHoursOfOperation()
     * - .toUpdateQueueMaxContacts()
     * - .toUpdateQueueName()
     * - .toUpdateQueueOutboundCallerConfig()
     * - .toUpdateQueueStatus()
     * - .toUpdateQuickConnectConfig()
     * - .toUpdateQuickConnectName()
     * - .toUpdateRoutingProfileConcurrency()
     * - .toUpdateRoutingProfileDefaultOutboundQueue()
     * - .toUpdateRoutingProfileName()
     * - .toUpdateRoutingProfileQueues()
     * - .toUpdateSecurityProfile()
     * - .toUpdateUserHierarchy()
     * - .toUpdateUserHierarchyGroupName()
     * - .toUpdateUserHierarchyStructure()
     * - .toUpdateUserIdentityInfo()
     * - .toUpdateUserPhoneConfig()
     * - .toUpdateUserRoutingProfile()
     * - .toUpdateUserSecurityProfiles()
     * - .toUpdatedescribeContent()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifInstanceId(value, operator) {
        return this.if(`InstanceId`, value, operator || 'StringLike');
    }
    /**
     * Filters access by TagFilter condition passed in the search request
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_service-with-iam.html
     *
     * Applies to actions:
     * - .toSearchUsers()
     *
     * @param tagKey The tag key to check
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSearchTag(tagKey, value, operator) {
        return this.if(`SearchTag/${tagKey}`, value, operator || 'StringLike');
    }
    /**
     * Filters access by restricting the storage resource type of the Amazon Connect instance storage configuration
     *
     * https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_service-with-iam.html
     *
     * Applies to actions:
     * - .toAssociateInstanceStorageConfig()
     * - .toDescribeInstanceStorageConfig()
     * - .toDisassociateInstanceStorageConfig()
     * - .toUpdateInstanceStorageConfig()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifStorageResourceType(value, operator) {
        return this.if(`StorageResourceType`, value, operator || 'StringLike');
    }
}
exports.Connect = Connect;
_a = JSII_RTTI_SYMBOL_1;
Connect[_a] = { fqn: "iam-floyd.Connect", version: "0.374.0" };
//# sourceMappingURL=data:application/json;base64,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