import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [iq-permission](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiqpermissions.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class IqPermission extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [iq-permission](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiqpermissions.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to approve an access grant
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toApproveAccessGrant(): this;
    protected accessLevelList: AccessLevelList;
}
//# sourceMappingURL=iqpermissions.d.ts.map