import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [aws-marketplace-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemanagementportal.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class AwsMarketplaceManagement extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [aws-marketplace-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemanagementportal.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Allows access to the File Upload page inside the AWS Marketplace Management Portal.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toUploadFiles(): this;
    /**
     * Allows access to the Marketing page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toViewMarketing(): this;
    /**
     * Allows access to the Reports page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toViewReports(): this;
    /**
     * Allows access to the Settings page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toViewSettings(): this;
    /**
     * Allows access to the Customer Support Eligibility page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toViewSupport(): this;
    protected accessLevelList: AccessLevelList;
}
//# sourceMappingURL=marketplacemanagementportal.d.ts.map