import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [mechanicalturk](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmechanicalturk.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Mechanicalturk extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [mechanicalturk](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmechanicalturk.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * The AcceptQualificationRequest operation grants a Worker's request for a Qualification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AcceptQualificationRequestOperation.html
     */
    toAcceptQualificationRequest(): this;
    /**
     * The ApproveAssignment operation approves the results of a completed assignment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ApproveAssignmentOperation.html
     */
    toApproveAssignment(): this;
    /**
     * The AssociateQualificationWithWorker operation gives a Worker a Qualification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AssociateQualificationWithWorkerOperation.html
     */
    toAssociateQualificationWithWorker(): this;
    /**
     * The CreateAdditionalAssignmentsForHIT operation increases the maximum number of assignments of an existing HIT
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateAdditionalAssignmentsForHITOperation.html
     */
    toCreateAdditionalAssignmentsForHIT(): this;
    /**
     * The CreateHIT operation creates a new HIT (Human Intelligence Task)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITOperation.html
     */
    toCreateHIT(): this;
    /**
     * The CreateHITType operation creates a new HIT type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITTypeOperation.html
     */
    toCreateHITType(): this;
    /**
     * The CreateHITWithHITType operation creates a new Human Intelligence Task (HIT) using an existing HITTypeID generated by the CreateHITType operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITWithHITTypeOperation.html
     */
    toCreateHITWithHITType(): this;
    /**
     * The CreateQualificationType operation creates a new Qualification type, which is represented by a QualificationType data structure
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateQualificationTypeOperation.html
     */
    toCreateQualificationType(): this;
    /**
     * The CreateWorkerBlock operation allows you to prevent a Worker from working on your HITs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateWorkerBlockOperation.html
     */
    toCreateWorkerBlock(): this;
    /**
     * The DeleteHIT operation disposes of a HIT that is no longer needed
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteHITOperation.html
     */
    toDeleteHIT(): this;
    /**
     * The DeleteQualificationType disposes a Qualification type and disposes any HIT types that are associated with the Qualification type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteQualificationTypeOperation.html
     */
    toDeleteQualificationType(): this;
    /**
     * The DeleteWorkerBlock operation allows you to reinstate a blocked Worker to work on your HITs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteWorkerBlockOperation.html
     */
    toDeleteWorkerBlock(): this;
    /**
     * The DisassociateQualificationFromWorker revokes a previously granted Qualification from a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DisassociateQualificationFromWorkerOperation.html
     */
    toDisassociateQualificationFromWorker(): this;
    /**
     * The GetAccountBalance operation retrieves the amount of money in your Amazon Mechanical Turk account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAccountBalanceOperation.html
     */
    toGetAccountBalance(): this;
    /**
     * The GetAssignment retrieves an assignment with an AssignmentStatus value of Submitted, Approved, or Rejected, using the assignment's ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAssignmentOperation.html
     */
    toGetAssignment(): this;
    /**
     * The GetFileUploadURL operation generates and returns a temporary URL
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetFileUploadURLOperation.html
     */
    toGetFileUploadURL(): this;
    /**
     * The GetHIT operation retrieves the details of the specified HIT
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetHITOperation.html
     */
    toGetHIT(): this;
    /**
     * The GetQualificationScore operation returns the value of a Worker's Qualification for a given Qualification type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationScoreOperation.html
     */
    toGetQualificationScore(): this;
    /**
     * The GetQualificationType operation retrieves information about a Qualification type using its ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationTypeOperation.html
     */
    toGetQualificationType(): this;
    /**
     * The ListAssignmentsForHIT operation retrieves completed assignments for a HIT
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListAssignmentsForHITOperation.html
     */
    toListAssignmentsForHIT(): this;
    /**
     * The ListBonusPayments operation retrieves the amounts of bonuses you have paid to Workers for a given HIT or assignment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListBonusPaymentsOperation.html
     */
    toListBonusPayments(): this;
    /**
     * The ListHITs operation returns all of a Requester's HITs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsOperation.html
     */
    toListHITs(): this;
    /**
     * The ListHITsForQualificationType operation returns the HITs that use the given QualififcationType for a QualificationRequirement
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsForQualificationTypeOperation.html
     */
    toListHITsForQualificationType(): this;
    /**
     * The ListQualificationRequests operation retrieves requests for Qualifications of a particular Qualification type
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationRequestsOperation.html
     */
    toListQualificationRequests(): this;
    /**
     * The ListQualificationTypes operation searches for Qualification types using the specified search query, and returns a list of Qualification types
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationTypesOperation.html
     */
    toListQualificationTypes(): this;
    /**
     * The ListReviewPolicyResultsForHIT operation retrieves the computed results and the actions taken in the course of executing your Review Policies during a CreateHIT operation
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewPolicyResultsForHITOperation.html
     */
    toListReviewPolicyResultsForHIT(): this;
    /**
     * The ListReviewableHITs operation returns all of a Requester's HITs that have not been approved or rejected
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewableHITsOperation.html
     */
    toListReviewableHITs(): this;
    /**
     * The ListWorkersBlocks operation retrieves a list of Workers who are blocked from working on your HITs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkerBlocksOperation.html
     */
    toListWorkerBlocks(): this;
    /**
     * The ListWorkersWithQualificationType operation returns all of the Workers with a given Qualification type
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkersWithQualificationTypeOperation.html
     */
    toListWorkersWithQualificationType(): this;
    /**
     * The NotifyWorkers operation sends an email to one or more Workers that you specify with the Worker ID
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_NotifyWorkersOperation.html
     */
    toNotifyWorkers(): this;
    /**
     * The RejectAssignment operation rejects the results of a completed assignment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectAssignmentOperation.html
     */
    toRejectAssignment(): this;
    /**
     * The RejectQualificationRequest operation rejects a user's request for a Qualification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectQualificationRequestOperation.html
     */
    toRejectQualificationRequest(): this;
    /**
     * The SendBonus operation issues a payment of money from your account to a Worker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendBonusOperation.html
     */
    toSendBonus(): this;
    /**
     * The SendTestEventNotification operation causes Amazon Mechanical Turk to send a notification message as if a HIT event occurred, according to the provided notification specification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendTestEventNotificationOperation.html
     */
    toSendTestEventNotification(): this;
    /**
     * The UpdateExpirationForHIT operation allows you extend the expiration time of a HIT beyond is current expiration or expire a HIT immediately
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateExpirationForHITOperation.html
     */
    toUpdateExpirationForHIT(): this;
    /**
     * The UpdateHITReviewStatus operation toggles the status of a HIT
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITReviewStatusOperation.html
     */
    toUpdateHITReviewStatus(): this;
    /**
     * The UpdateHITTypeOfHIT operation allows you to change the HITType properties of a HIT
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITTypeOfHITOperation.html
     */
    toUpdateHITTypeOfHIT(): this;
    /**
     * The UpdateNotificationSettings operation creates, updates, disables or re-enables notifications for a HIT type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateNotificationSettingsOperation.html
     */
    toUpdateNotificationSettings(): this;
    /**
     * The UpdateQualificationType operation modifies the attributes of an existing Qualification type, which is represented by a QualificationType data structure
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateQualificationTypeOperation.html
     */
    toUpdateQualificationType(): this;
    protected accessLevelList: AccessLevelList;
}
//# sourceMappingURL=mechanicalturk.d.ts.map