import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [migrationhub-orchestrator](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmigrationhuborchestrator.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class MigrationhubOrchestrator extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [migrationhub-orchestrator](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmigrationhuborchestrator.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a workflow based on the selected template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_CreateWorkflow.html
     */
    toCreateWorkflow(): this;
    /**
     * Grants permission to create a step under a workflow and a specific step group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_CreateWorkflowStep.html
     */
    toCreateWorkflowStep(): this;
    /**
     * Grants permission to to create a custom step group for a given workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_CreateWorkflowStepGroup.html
     */
    toCreateWorkflowStepGroup(): this;
    /**
     * Grants permission to a workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_DeleteWorkflow.html
     */
    toDeleteWorkflow(): this;
    /**
     * Grants permission to delete a step from a specific step group under a workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_DeleteWorkflowStep.html
     */
    toDeleteWorkflowStep(): this;
    /**
     * Grants permission to delete a step group associated with a workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_DeleteWorkflowStepGroup.html
     */
    toDeleteWorkflowStepGroup(): this;
    /**
     * Grants permission to the plugin to receive information from the service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_GetMessage.html
     */
    toGetMessage(): this;
    /**
     * Grants permission to get retrieve metadata for a Template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_GetTemplate.html
     */
    toGetTemplate(): this;
    /**
     * Grants permission to retrieve details of a step associated with a template and a step group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_GetTemplateStep.html
     */
    toGetTemplateStep(): this;
    /**
     * Grants permission to retrieve metadata of a step group under a template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_GetTemplateStepGroup.html
     */
    toGetTemplateStepGroup(): this;
    /**
     * Grants permission to retrieve metadata asscociated with a workflow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_GetWorkflow.html
     */
    toGetWorkflow(): this;
    /**
     * Grants permission to get details of step associated with a workflow and a step group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_GetWorkflowStep.html
     */
    toGetWorkflowStep(): this;
    /**
     * Grants permission to get details of a step group associated with a workflow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_GetWorkflowStepGroup.html
     */
    toGetWorkflowStepGroup(): this;
    /**
     * Grants permission to get a list all registered Plugins
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_ListPlugins.html
     */
    toListPlugins(): this;
    /**
     * Grants permission to get a list of all the tags tied to a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to lists step groups of a template
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_ListTemplateStepGroups.html
     */
    toListTemplateStepGroups(): this;
    /**
     * Grants permission to get a list of steps in a step group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_ListServers.html
     */
    toListTemplateSteps(): this;
    /**
     * Grants permission to get a list of all Templates available to customer
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_ListTemplates.html
     */
    toListTemplates(): this;
    /**
     * Grants permission to get list of step groups associated with a workflow
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_ListWorkflowStepGroups.html
     */
    toListWorkflowStepGroups(): this;
    /**
     * Grants permission to get a list of steps within step group associated with a workflow
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_ListAntiPatterns.html
     */
    toListWorkflowSteps(): this;
    /**
     * Grants permission to list all workflows
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_ListWorkflows.html
     */
    toListWorkflows(): this;
    /**
     * Grants permission to register the plugin to receive an ID and to start receiving messages from the service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_RegisterPlugin.html
     */
    toRegisterPlugin(): this;
    /**
     * Grants permission to retry a failed step within a workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_RetryWorkflowStep.html
     */
    toRetryWorkflowStep(): this;
    /**
     * Grants permission to the plugin to send information to the service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_SendMessage.html
     */
    toSendMessage(): this;
    /**
     * Grants permission to start a workflow or resume a stopped workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_StartWorkflow.html
     */
    toStartWorkflow(): this;
    /**
     * Grants permission to stop a workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_StopWorkflow.html
     */
    toStopWorkflow(): this;
    /**
     * Grants permission to add tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update the metadata associated with the workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_UpdateWorkflow.html
     */
    toUpdateWorkflow(): this;
    /**
     * Grants permission to update metadata and status of a custom step within a workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_UpdateWorkflowStep.html
     */
    toUpdateWorkflowStep(): this;
    /**
     * Grants permission to update metadata associated with a step group in a given workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_UpdateWorkflowStepGroup.html
     */
    toUpdateWorkflowStepGroup(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type workflow to the statement
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/userguide/workflow.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWorkflow(resourceId: string, account?: string, region?: string, partition?: string): this;
}
//# sourceMappingURL=migrationhuborchestrator.d.ts.map