import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [sdb](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsimpledb.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Sdb extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [sdb](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonsimpledb.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Performs multiple DeleteAttributes operations in a single call, which reduces round trips and latencies
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonSimpleDB/latest/DeveloperGuide/SDB_API_BatchDeleteAttributes.html
     */
    toBatchDeleteAttributes(): this;
    /**
     * With the BatchPutAttributes operation, you can perform multiple PutAttribute operations in a single call. With the BatchPutAttributes operation, you can perform multiple PutAttribute operations in a single call
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonSimpleDB/latest/DeveloperGuide/SDB_API_BatchPutAttributes.html
     */
    toBatchPutAttributes(): this;
    /**
     * The CreateDomain operation creates a new domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonSimpleDB/latest/DeveloperGuide/SDB_API_CreateDomain.html
     */
    toCreateDomain(): this;
    /**
     * Deletes one or more attributes associated with the item
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonSimpleDB/latest/DeveloperGuide/SDB_API_DeleteAttributes.html
     */
    toDeleteAttributes(): this;
    /**
     * The DeleteDomain operation deletes a domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonSimpleDB/latest/DeveloperGuide/SDB_API_DeleteDomain.html
     */
    toDeleteDomain(): this;
    /**
     * Returns information about the domain, including when the domain was created, the number of items and attributes, and the size of attribute names and values
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonSimpleDB/latest/DeveloperGuide/SDB_API_DomainMetadata.html
     */
    toDomainMetadata(): this;
    /**
     * Returns all of the attributes associated with the item
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonSimpleDB/latest/DeveloperGuide/SDB_API_GetAttributes.html
     */
    toGetAttributes(): this;
    /**
     * Description for ListDomains
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AmazonSimpleDB/latest/DeveloperGuide/SDB_API_ListDomains.html
     */
    toListDomains(): this;
    /**
     * The PutAttributes operation creates or replaces attributes in an item
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AmazonSimpleDB/latest/DeveloperGuide/SDB_API_PutAttributes.html
     */
    toPutAttributes(): this;
    /**
     * Description for Select
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AmazonSimpleDB/latest/DeveloperGuide/SDB_API_Select.html
     */
    toSelect(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type domain to the statement
     *
     * https://docs.aws.amazon.com/AmazonSimpleDB/latest/DeveloperGuide/DataModel.html
     *
     * @param domainName - Identifier for the domainName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onDomain(domainName: string, account?: string, region?: string, partition?: string): this;
}
//# sourceMappingURL=simpledb.d.ts.map