import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [textract](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontextract.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Textract extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [textract](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontextract.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to detect instances of real-world document entities within an image provided as input
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_AnalyzeDocument.html
     */
    toAnalyzeDocument(): this;
    /**
     * Grants permission to detect instances of real-world document entities within an image provided as input
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_AnalyzeExpense.html
     */
    toAnalyzeExpense(): this;
    /**
     * Grants permission to detect relevant information from identity documents provided as input
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_AnalyzeID.html
     */
    toAnalyzeID(): this;
    /**
     * Grants permission to detect text in document images
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_DetectDocumentText.html
     */
    toDetectDocumentText(): this;
    /**
     * Grants permission to return information about a document analysis job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetDocumentAnalysis.html
     */
    toGetDocumentAnalysis(): this;
    /**
     * Grants permission to return information about a document text detection job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetDocumentTextDetection.html
     */
    toGetDocumentTextDetection(): this;
    /**
     * Grants permission to return information about an expense analysis job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetExpenseAnalysis.html
     */
    toGetExpenseAnalysis(): this;
    /**
     * Grants permission to start an asynchronous job to detect instances of real-world document entities within an image or pdf provided as input
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartDocumentAnalysis.html
     */
    toStartDocumentAnalysis(): this;
    /**
     * Grants permission to start an asynchronous job to detect text in document images or pdfs
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartDocumentTextDetection.html
     */
    toStartDocumentTextDetection(): this;
    /**
     * Grants permission to start an asynchronous job to detect instances of invoices or receipts within an image or pdf provided as input
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartExpenseAnalysis.html
     */
    toStartExpenseAnalysis(): this;
    protected accessLevelList: AccessLevelList;
}
//# sourceMappingURL=textract.d.ts.map