"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Translate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [translate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontranslate.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Translate extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [translate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontranslate.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'translate';
        this.accessLevelList = {
            Write: [
                'CreateParallelData',
                'DeleteParallelData',
                'DeleteTerminology',
                'ImportTerminology',
                'StartTextTranslationJob',
                'StopTextTranslationJob',
                'UpdateParallelData'
            ],
            Read: [
                'DescribeTextTranslationJob',
                'GetParallelData',
                'GetTerminology',
                'TranslateText'
            ],
            List: [
                'ListParallelData',
                'ListTerminologies',
                'ListTextTranslationJobs'
            ]
        };
    }
    /**
     * Grants permission to create a Parallel Data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_CreateParallelData.html
     */
    toCreateParallelData() {
        return this.to('CreateParallelData');
    }
    /**
     * Grants permission to delete a Parallel Data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_DeleteParallelData.html
     */
    toDeleteParallelData() {
        return this.to('DeleteParallelData');
    }
    /**
     * Grants permission to delete a terminology
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_DeleteTerminology.html
     */
    toDeleteTerminology() {
        return this.to('DeleteTerminology');
    }
    /**
     * Grants permission to get the properties associated with an asynchronous batch translation job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_DescribeTextTranslationJob.html
     */
    toDescribeTextTranslationJob() {
        return this.to('DescribeTextTranslationJob');
    }
    /**
     * Grants permission to get a Parallel Data
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_GetParallelData.html
     */
    toGetParallelData() {
        return this.to('GetParallelData');
    }
    /**
     * Grants permission to retrieve a terminology
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_GetTerminology.html
     */
    toGetTerminology() {
        return this.to('GetTerminology');
    }
    /**
     * Grants permission to create or update a terminology, depending on whether or not one already exists for the given terminology name
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ImportTerminology.html
     */
    toImportTerminology() {
        return this.to('ImportTerminology');
    }
    /**
     * Grants permission to list Parallel Data associated with your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListParallelData.html
     */
    toListParallelData() {
        return this.to('ListParallelData');
    }
    /**
     * Grants permission to list terminologies associated with your account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListTerminologies.html
     */
    toListTerminologies() {
        return this.to('ListTerminologies');
    }
    /**
     * Grants permission to list batch translation jobs that you have submitted
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_ListTextTranslationJobs.html
     */
    toListTextTranslationJobs() {
        return this.to('ListTextTranslationJobs');
    }
    /**
     * Grants permission to start an asynchronous batch translation job. Batch translation jobs can be used to translate large volumes of text across multiple documents at once
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_StartTextTranslationJob.html
     */
    toStartTextTranslationJob() {
        return this.to('StartTextTranslationJob');
    }
    /**
     * Grants permission to stop an asynchronous batch translation job that is in progress
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_StopTextTranslationJob.html
     */
    toStopTextTranslationJob() {
        return this.to('StopTextTranslationJob');
    }
    /**
     * Grants permission to translate text from a source language to a target language
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_TranslateText.html
     */
    toTranslateText() {
        return this.to('TranslateText');
    }
    /**
     * Grants permission to update an existing Parallel Data
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/translate/latest/dg/API_UpdateParallelData.html
     */
    toUpdateParallelData() {
        return this.to('UpdateParallelData');
    }
}
exports.Translate = Translate;
_a = JSII_RTTI_SYMBOL_1;
Translate[_a] = { fqn: "iam-floyd.Translate", version: "0.374.0" };
//# sourceMappingURL=data:application/json;base64,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