"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementWithEffect = exports.Effect = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _4_resources_1 = require("./4-resources");
/**
 * Policy effects
 */
var Effect;
(function (Effect) {
    Effect["ALLOW"] = "Allow";
    Effect["DENY"] = "Deny";
})(Effect = exports.Effect || (exports.Effect = {}));
/**
 * Adds "effect" functionality to the Policy Statement
 */
class PolicyStatementWithEffect extends _4_resources_1.PolicyStatementWithResources {
    constructor() {
        super(...arguments);
        this.effect = Effect.ALLOW;
    }
    /**
     * Injects effect into the statement.
     *
     * Only relevant for the main package. In CDK mode this only calls super.
     */
    toJSON() {
        // @ts-ignore only available after swapping 1-base
        if (typeof this.addResources == 'function') {
            return super.toJSON();
        }
        const statement = super.toJSON();
        statement.Effect = this.effect;
        return statement;
    }
    /**
     * Allow the actions in this statement
     */
    allow() {
        this.effect = Effect.ALLOW;
        return this;
    }
    /**
     * Deny the actions in this statement
     */
    deny() {
        this.effect = Effect.DENY;
        return this;
    }
}
exports.PolicyStatementWithEffect = PolicyStatementWithEffect;
_a = JSII_RTTI_SYMBOL_1;
PolicyStatementWithEffect[_a] = { fqn: "iam-floyd.PolicyStatementWithEffect", version: "0.374.0" };
//# sourceMappingURL=data:application/json;base64,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