# AUTOGENERATED! DO NOT EDIT! File to edit: 00r_database.ipynb (unless otherwise specified).

__all__ = ['DEFAULT_CONFIGS', 'Configs', 'Database']

# Cell
import pandas as pd
from pathlib import Path
from typing import List, Tuple, Dict, Optional

# Cell
DEFAULT_CONFIGS = {# General features:
                  'fig_width': 28,
                  'fig_height': 16,
                  'show_legend': True,
                  'marker_size': 5,
                  'color_palette': 'colorblind',
                  'save_plot': False,

                  # Axes of the plot:
                  'axes_linewidth': 1,
                  'axes_color': '#000000',
                  'axes_tick_size': 10,
                  'yaxis_label_text': 'data',
                  'yaxis_label_fontsize': 12,
                  'yaxis_label_color': '#000000',
                  'xaxis_label_text': 'groups',
                  'xaxis_label_fontsize': 12,
                  'xaxis_label_color': '#000000',
                  'yaxis_scaling_mode': 'auto',
                  'yaxis_lower_lim_value': 0,
                  'yaxis_upper_lim_value': 1,

                  # Annotations:
                  'distance_brackets_to_data': 0.1,
                  'annotation_brackets_factor': 1,
                  'distance_stars_to_brackets': 0.5,
                  'linewidth_annotations': 1.5,
                  'fontsize_stars': 10,
                  'fontweight_stars': 'bold',
                  'l_stats_to_annotate': []
                 }

# Cell
class Configs:

    def __init__(self):
        self.update(updates = DEFAULT_CONFIGS)


    def update(self, updates: Dict) -> None:
        for key, value in updates.items():
            setattr(self, key, value)

# Cell
class Database:

    def __init__(self) -> None:
        self.configs = Configs()
        self.undo_configs_version = Configs()
        self.redo_configs_version = Configs()


    def update_configs(self, updates: Dict) -> None:
        self.undo_configs_version = self.configs.copy()
        self.configs.update(updates = updates)
        self.redo_configs_version = self.configs.copy()


    def undo_configs_changes(self) -> None:
        self.configs = self.undo_configs_version.copy()


    def redo_configs_changes(self) -> None:
        self.configs = self.redo_configs_version.copy()