// Copyright 2022 Alibaba Group Holding Limited.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "Pemja.h"

#include "java_class/Iterable.h"

static jmethodID iterator = 0;

jobject
JavaIterable_iterator(JNIEnv* env, jobject jval)
{
    if (!iterator) {
        iterator = (*env)->GetMethodID(env, JITERABLE_TYPE, "iterator", "()Ljava/util/Iterator;");
    }
    return (*env)->CallObjectMethod(env, jval, iterator);
}
