# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetProjectServiceAccountResult',
    'AwaitableGetProjectServiceAccountResult',
    'get_project_service_account',
    'get_project_service_account_output',
]

@pulumi.output_type
class GetProjectServiceAccountResult:
    """
    A collection of values returned by getProjectServiceAccount.
    """
    def __init__(__self__, account_email=None, id=None, name=None, project_id=None):
        if account_email and not isinstance(account_email, str):
            raise TypeError("Expected argument 'account_email' to be a str")
        pulumi.set(__self__, "account_email", account_email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="accountEmail")
    def account_email(self) -> str:
        """
        The email address of the service account. This value is
        often used to refer to the service account in order to grant IAM permissions.
        """
        return pulumi.get(self, "account_email")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The Access Approval service account resource name. Format is "projects/{project_id}/serviceAccount".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        return pulumi.get(self, "project_id")


class AwaitableGetProjectServiceAccountResult(GetProjectServiceAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectServiceAccountResult(
            account_email=self.account_email,
            id=self.id,
            name=self.name,
            project_id=self.project_id)


def get_project_service_account(project_id: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectServiceAccountResult:
    """
    Get the email address of a project's Access Approval service account.

    Each Google Cloud project has a unique service account used by Access Approval.
    When using Access Approval with a
    [custom signing key](https://cloud.google.com/cloud-provider-access-management/access-approval/docs/review-approve-access-requests-custom-keys),
    this account needs to be granted the `cloudkms.signerVerifier` IAM role on the
    Cloud KMS key used to sign approvals.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    service_account = gcp.accessapproval.get_project_service_account(project_id="my-project")
    iam = gcp.kms.CryptoKeyIAMMember("iam",
        crypto_key_id=google_kms_crypto_key["crypto_key"]["id"],
        role="roles/cloudkms.signerVerifier",
        member=f"serviceAccount:{service_account.account_email}")
    ```


    :param str project_id: The project ID the service account was created for.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:accessapproval/getProjectServiceAccount:getProjectServiceAccount', __args__, opts=opts, typ=GetProjectServiceAccountResult).value

    return AwaitableGetProjectServiceAccountResult(
        account_email=__ret__.account_email,
        id=__ret__.id,
        name=__ret__.name,
        project_id=__ret__.project_id)


@_utilities.lift_output_func(get_project_service_account)
def get_project_service_account_output(project_id: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProjectServiceAccountResult]:
    """
    Get the email address of a project's Access Approval service account.

    Each Google Cloud project has a unique service account used by Access Approval.
    When using Access Approval with a
    [custom signing key](https://cloud.google.com/cloud-provider-access-management/access-approval/docs/review-approve-access-requests-custom-keys),
    this account needs to be granted the `cloudkms.signerVerifier` IAM role on the
    Cloud KMS key used to sign approvals.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    service_account = gcp.accessapproval.get_project_service_account(project_id="my-project")
    iam = gcp.kms.CryptoKeyIAMMember("iam",
        crypto_key_id=google_kms_crypto_key["crypto_key"]["id"],
        role="roles/cloudkms.signerVerifier",
        member=f"serviceAccount:{service_account.account_email}")
    ```


    :param str project_id: The project ID the service account was created for.
    """
    ...
