# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 network: pulumi.Input[str],
                 automated_backup_policy: Optional[pulumi.Input['ClusterAutomatedBackupPolicyArgs']] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 initial_user: Optional[pulumi.Input['ClusterInitialUserArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[str] cluster_id: The ID of the alloydb cluster.
        :param pulumi.Input[str] network: The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:
               "projects/{projectNumber}/global/networks/{network_id}".
        :param pulumi.Input['ClusterAutomatedBackupPolicyArgs'] automated_backup_policy: The automated backup policy for this cluster.
               If no policy is provided then the default policy will be used. The default policy takes one backup a day, has a backup window of 1 hour, and retains backups for 14 days.
               Structure is documented below.
        :param pulumi.Input[str] display_name: User-settable and human-readable display name for the Cluster.
        :param pulumi.Input['ClusterInitialUserArgs'] initial_user: Initial user to setup during cluster creation.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to backups created using this configuration.
        :param pulumi.Input[str] location: The location where the backup will be stored. Currently, the only supported option is to store the backup in the same region as the cluster.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "network", network)
        if automated_backup_policy is not None:
            pulumi.set(__self__, "automated_backup_policy", automated_backup_policy)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if initial_user is not None:
            pulumi.set(__self__, "initial_user", initial_user)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        The ID of the alloydb cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input[str]:
        """
        The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:
        "projects/{projectNumber}/global/networks/{network_id}".
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[str]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="automatedBackupPolicy")
    def automated_backup_policy(self) -> Optional[pulumi.Input['ClusterAutomatedBackupPolicyArgs']]:
        """
        The automated backup policy for this cluster.
        If no policy is provided then the default policy will be used. The default policy takes one backup a day, has a backup window of 1 hour, and retains backups for 14 days.
        Structure is documented below.
        """
        return pulumi.get(self, "automated_backup_policy")

    @automated_backup_policy.setter
    def automated_backup_policy(self, value: Optional[pulumi.Input['ClusterAutomatedBackupPolicyArgs']]):
        pulumi.set(self, "automated_backup_policy", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        User-settable and human-readable display name for the Cluster.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="initialUser")
    def initial_user(self) -> Optional[pulumi.Input['ClusterInitialUserArgs']]:
        """
        Initial user to setup during cluster creation.
        Structure is documented below.
        """
        return pulumi.get(self, "initial_user")

    @initial_user.setter
    def initial_user(self, value: Optional[pulumi.Input['ClusterInitialUserArgs']]):
        pulumi.set(self, "initial_user", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to apply to backups created using this configuration.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location where the backup will be stored. Currently, the only supported option is to store the backup in the same region as the cluster.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 automated_backup_policy: Optional[pulumi.Input['ClusterAutomatedBackupPolicyArgs']] = None,
                 backup_sources: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBackupSourceArgs']]]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 database_version: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 initial_user: Optional[pulumi.Input['ClusterInitialUserArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 migration_sources: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMigrationSourceArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input['ClusterAutomatedBackupPolicyArgs'] automated_backup_policy: The automated backup policy for this cluster.
               If no policy is provided then the default policy will be used. The default policy takes one backup a day, has a backup window of 1 hour, and retains backups for 14 days.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterBackupSourceArgs']]] backup_sources: Cluster created from backup.
        :param pulumi.Input[str] cluster_id: The ID of the alloydb cluster.
        :param pulumi.Input[str] database_version: The database engine major version. This is an output-only field and it's populated at the Cluster creation time. This
               field cannot be changed after cluster creation.
        :param pulumi.Input[str] display_name: User-settable and human-readable display name for the Cluster.
        :param pulumi.Input['ClusterInitialUserArgs'] initial_user: Initial user to setup during cluster creation.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to backups created using this configuration.
        :param pulumi.Input[str] location: The location where the backup will be stored. Currently, the only supported option is to store the backup in the same region as the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterMigrationSourceArgs']]] migration_sources: Cluster created via DMS migration.
        :param pulumi.Input[str] name: The name of the cluster resource.
        :param pulumi.Input[str] network: The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:
               "projects/{projectNumber}/global/networks/{network_id}".
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] uid: The system-generated UID of the resource.
        """
        if automated_backup_policy is not None:
            pulumi.set(__self__, "automated_backup_policy", automated_backup_policy)
        if backup_sources is not None:
            pulumi.set(__self__, "backup_sources", backup_sources)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if database_version is not None:
            pulumi.set(__self__, "database_version", database_version)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if initial_user is not None:
            pulumi.set(__self__, "initial_user", initial_user)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if migration_sources is not None:
            pulumi.set(__self__, "migration_sources", migration_sources)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="automatedBackupPolicy")
    def automated_backup_policy(self) -> Optional[pulumi.Input['ClusterAutomatedBackupPolicyArgs']]:
        """
        The automated backup policy for this cluster.
        If no policy is provided then the default policy will be used. The default policy takes one backup a day, has a backup window of 1 hour, and retains backups for 14 days.
        Structure is documented below.
        """
        return pulumi.get(self, "automated_backup_policy")

    @automated_backup_policy.setter
    def automated_backup_policy(self, value: Optional[pulumi.Input['ClusterAutomatedBackupPolicyArgs']]):
        pulumi.set(self, "automated_backup_policy", value)

    @property
    @pulumi.getter(name="backupSources")
    def backup_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBackupSourceArgs']]]]:
        """
        Cluster created from backup.
        """
        return pulumi.get(self, "backup_sources")

    @backup_sources.setter
    def backup_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBackupSourceArgs']]]]):
        pulumi.set(self, "backup_sources", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the alloydb cluster.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> Optional[pulumi.Input[str]]:
        """
        The database engine major version. This is an output-only field and it's populated at the Cluster creation time. This
        field cannot be changed after cluster creation.
        """
        return pulumi.get(self, "database_version")

    @database_version.setter
    def database_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_version", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        User-settable and human-readable display name for the Cluster.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="initialUser")
    def initial_user(self) -> Optional[pulumi.Input['ClusterInitialUserArgs']]:
        """
        Initial user to setup during cluster creation.
        Structure is documented below.
        """
        return pulumi.get(self, "initial_user")

    @initial_user.setter
    def initial_user(self, value: Optional[pulumi.Input['ClusterInitialUserArgs']]):
        pulumi.set(self, "initial_user", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to apply to backups created using this configuration.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location where the backup will be stored. Currently, the only supported option is to store the backup in the same region as the cluster.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="migrationSources")
    def migration_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMigrationSourceArgs']]]]:
        """
        Cluster created via DMS migration.
        """
        return pulumi.get(self, "migration_sources")

    @migration_sources.setter
    def migration_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMigrationSourceArgs']]]]):
        pulumi.set(self, "migration_sources", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cluster resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:
        "projects/{projectNumber}/global/networks/{network_id}".
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The system-generated UID of the resource.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automated_backup_policy: Optional[pulumi.Input[pulumi.InputType['ClusterAutomatedBackupPolicyArgs']]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 initial_user: Optional[pulumi.Input[pulumi.InputType['ClusterInitialUserArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage
        ### Alloydb Cluster Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default_network = gcp.compute.Network("defaultNetwork", opts=pulumi.ResourceOptions(provider=google_beta))
        default_cluster = gcp.alloydb.Cluster("defaultCluster",
            cluster_id="alloydb-cluster",
            location="us-central1",
            network=default_network.name.apply(lambda name: f"projects/{project.number}/global/networks/{name}"),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Alloydb Cluster Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default = gcp.compute.Network("default", opts=pulumi.ResourceOptions(provider=google_beta))
        full = gcp.alloydb.Cluster("full",
            cluster_id="alloydb-cluster-full",
            location="us-central1",
            network=default.name.apply(lambda name: f"projects/{project.number}/global/networks/{name}"),
            initial_user=gcp.alloydb.ClusterInitialUserArgs(
                user="alloydb-cluster-full",
                password="alloydb-cluster-full",
            ),
            automated_backup_policy=gcp.alloydb.ClusterAutomatedBackupPolicyArgs(
                location="us-central1",
                backup_window="1800s",
                enabled=True,
                weekly_schedule=gcp.alloydb.ClusterAutomatedBackupPolicyWeeklyScheduleArgs(
                    days_of_weeks=["MONDAY"],
                    start_times=[gcp.alloydb.ClusterAutomatedBackupPolicyWeeklyScheduleStartTimeArgs(
                        hours=23,
                        minutes=0,
                        seconds=0,
                        nanos=0,
                    )],
                ),
                quantity_based_retention=gcp.alloydb.ClusterAutomatedBackupPolicyQuantityBasedRetentionArgs(
                    count=1,
                ),
                labels={
                    "test": "alloydb-cluster-full",
                },
            ),
            labels={
                "test": "alloydb-cluster-full",
            },
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        Cluster can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:alloydb/cluster:Cluster default projects/{{project}}/locations/{{location}}/clusters/{{cluster_id}}
        ```

        ```sh
         $ pulumi import gcp:alloydb/cluster:Cluster default {{project}}/{{location}}/{{cluster_id}}
        ```

        ```sh
         $ pulumi import gcp:alloydb/cluster:Cluster default {{location}}/{{cluster_id}}
        ```

        ```sh
         $ pulumi import gcp:alloydb/cluster:Cluster default {{cluster_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ClusterAutomatedBackupPolicyArgs']] automated_backup_policy: The automated backup policy for this cluster.
               If no policy is provided then the default policy will be used. The default policy takes one backup a day, has a backup window of 1 hour, and retains backups for 14 days.
               Structure is documented below.
        :param pulumi.Input[str] cluster_id: The ID of the alloydb cluster.
        :param pulumi.Input[str] display_name: User-settable and human-readable display name for the Cluster.
        :param pulumi.Input[pulumi.InputType['ClusterInitialUserArgs']] initial_user: Initial user to setup during cluster creation.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to backups created using this configuration.
        :param pulumi.Input[str] location: The location where the backup will be stored. Currently, the only supported option is to store the backup in the same region as the cluster.
        :param pulumi.Input[str] network: The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:
               "projects/{projectNumber}/global/networks/{network_id}".
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage
        ### Alloydb Cluster Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default_network = gcp.compute.Network("defaultNetwork", opts=pulumi.ResourceOptions(provider=google_beta))
        default_cluster = gcp.alloydb.Cluster("defaultCluster",
            cluster_id="alloydb-cluster",
            location="us-central1",
            network=default_network.name.apply(lambda name: f"projects/{project.number}/global/networks/{name}"),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Alloydb Cluster Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default = gcp.compute.Network("default", opts=pulumi.ResourceOptions(provider=google_beta))
        full = gcp.alloydb.Cluster("full",
            cluster_id="alloydb-cluster-full",
            location="us-central1",
            network=default.name.apply(lambda name: f"projects/{project.number}/global/networks/{name}"),
            initial_user=gcp.alloydb.ClusterInitialUserArgs(
                user="alloydb-cluster-full",
                password="alloydb-cluster-full",
            ),
            automated_backup_policy=gcp.alloydb.ClusterAutomatedBackupPolicyArgs(
                location="us-central1",
                backup_window="1800s",
                enabled=True,
                weekly_schedule=gcp.alloydb.ClusterAutomatedBackupPolicyWeeklyScheduleArgs(
                    days_of_weeks=["MONDAY"],
                    start_times=[gcp.alloydb.ClusterAutomatedBackupPolicyWeeklyScheduleStartTimeArgs(
                        hours=23,
                        minutes=0,
                        seconds=0,
                        nanos=0,
                    )],
                ),
                quantity_based_retention=gcp.alloydb.ClusterAutomatedBackupPolicyQuantityBasedRetentionArgs(
                    count=1,
                ),
                labels={
                    "test": "alloydb-cluster-full",
                },
            ),
            labels={
                "test": "alloydb-cluster-full",
            },
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        Cluster can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:alloydb/cluster:Cluster default projects/{{project}}/locations/{{location}}/clusters/{{cluster_id}}
        ```

        ```sh
         $ pulumi import gcp:alloydb/cluster:Cluster default {{project}}/{{location}}/{{cluster_id}}
        ```

        ```sh
         $ pulumi import gcp:alloydb/cluster:Cluster default {{location}}/{{cluster_id}}
        ```

        ```sh
         $ pulumi import gcp:alloydb/cluster:Cluster default {{cluster_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automated_backup_policy: Optional[pulumi.Input[pulumi.InputType['ClusterAutomatedBackupPolicyArgs']]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 initial_user: Optional[pulumi.Input[pulumi.InputType['ClusterInitialUserArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["automated_backup_policy"] = automated_backup_policy
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["initial_user"] = initial_user
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["project"] = project
            __props__.__dict__["backup_sources"] = None
            __props__.__dict__["database_version"] = None
            __props__.__dict__["migration_sources"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["uid"] = None
        super(Cluster, __self__).__init__(
            'gcp:alloydb/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            automated_backup_policy: Optional[pulumi.Input[pulumi.InputType['ClusterAutomatedBackupPolicyArgs']]] = None,
            backup_sources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterBackupSourceArgs']]]]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            database_version: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            initial_user: Optional[pulumi.Input[pulumi.InputType['ClusterInitialUserArgs']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            migration_sources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterMigrationSourceArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            uid: Optional[pulumi.Input[str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ClusterAutomatedBackupPolicyArgs']] automated_backup_policy: The automated backup policy for this cluster.
               If no policy is provided then the default policy will be used. The default policy takes one backup a day, has a backup window of 1 hour, and retains backups for 14 days.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterBackupSourceArgs']]]] backup_sources: Cluster created from backup.
        :param pulumi.Input[str] cluster_id: The ID of the alloydb cluster.
        :param pulumi.Input[str] database_version: The database engine major version. This is an output-only field and it's populated at the Cluster creation time. This
               field cannot be changed after cluster creation.
        :param pulumi.Input[str] display_name: User-settable and human-readable display name for the Cluster.
        :param pulumi.Input[pulumi.InputType['ClusterInitialUserArgs']] initial_user: Initial user to setup during cluster creation.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to backups created using this configuration.
        :param pulumi.Input[str] location: The location where the backup will be stored. Currently, the only supported option is to store the backup in the same region as the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterMigrationSourceArgs']]]] migration_sources: Cluster created via DMS migration.
        :param pulumi.Input[str] name: The name of the cluster resource.
        :param pulumi.Input[str] network: The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:
               "projects/{projectNumber}/global/networks/{network_id}".
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] uid: The system-generated UID of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["automated_backup_policy"] = automated_backup_policy
        __props__.__dict__["backup_sources"] = backup_sources
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["database_version"] = database_version
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["initial_user"] = initial_user
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["migration_sources"] = migration_sources
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["project"] = project
        __props__.__dict__["uid"] = uid
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="automatedBackupPolicy")
    def automated_backup_policy(self) -> pulumi.Output[Optional['outputs.ClusterAutomatedBackupPolicy']]:
        """
        The automated backup policy for this cluster.
        If no policy is provided then the default policy will be used. The default policy takes one backup a day, has a backup window of 1 hour, and retains backups for 14 days.
        Structure is documented below.
        """
        return pulumi.get(self, "automated_backup_policy")

    @property
    @pulumi.getter(name="backupSources")
    def backup_sources(self) -> pulumi.Output[Sequence['outputs.ClusterBackupSource']]:
        """
        Cluster created from backup.
        """
        return pulumi.get(self, "backup_sources")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The ID of the alloydb cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> pulumi.Output[str]:
        """
        The database engine major version. This is an output-only field and it's populated at the Cluster creation time. This
        field cannot be changed after cluster creation.
        """
        return pulumi.get(self, "database_version")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        User-settable and human-readable display name for the Cluster.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="initialUser")
    def initial_user(self) -> pulumi.Output[Optional['outputs.ClusterInitialUser']]:
        """
        Initial user to setup during cluster creation.
        Structure is documented below.
        """
        return pulumi.get(self, "initial_user")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Labels to apply to backups created using this configuration.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        The location where the backup will be stored. Currently, the only supported option is to store the backup in the same region as the cluster.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="migrationSources")
    def migration_sources(self) -> pulumi.Output[Sequence['outputs.ClusterMigrationSource']]:
        """
        Cluster created via DMS migration.
        """
        return pulumi.get(self, "migration_sources")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the cluster resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[str]:
        """
        The relative resource name of the VPC network on which the instance can be accessed. It is specified in the following form:
        "projects/{projectNumber}/global/networks/{network_id}".
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        The system-generated UID of the resource.
        """
        return pulumi.get(self, "uid")

