# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AccountIamPolicyArgs', 'AccountIamPolicy']

@pulumi.input_type
class AccountIamPolicyArgs:
    def __init__(__self__, *,
                 billing_account_id: pulumi.Input[str],
                 policy_data: pulumi.Input[str]):
        """
        The set of arguments for constructing a AccountIamPolicy resource.
        :param pulumi.Input[str] billing_account_id: The billing account id.
        :param pulumi.Input[str] policy_data: The policy data generated by a `organizations.get_iam_policy` data source.
        """
        pulumi.set(__self__, "billing_account_id", billing_account_id)
        pulumi.set(__self__, "policy_data", policy_data)

    @property
    @pulumi.getter(name="billingAccountId")
    def billing_account_id(self) -> pulumi.Input[str]:
        """
        The billing account id.
        """
        return pulumi.get(self, "billing_account_id")

    @billing_account_id.setter
    def billing_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "billing_account_id", value)

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> pulumi.Input[str]:
        """
        The policy data generated by a `organizations.get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @policy_data.setter
    def policy_data(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_data", value)


@pulumi.input_type
class _AccountIamPolicyState:
    def __init__(__self__, *,
                 billing_account_id: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 policy_data: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AccountIamPolicy resources.
        :param pulumi.Input[str] billing_account_id: The billing account id.
        :param pulumi.Input[str] etag: (Computed) The etag of the billing account's IAM policy.
        :param pulumi.Input[str] policy_data: The policy data generated by a `organizations.get_iam_policy` data source.
        """
        if billing_account_id is not None:
            pulumi.set(__self__, "billing_account_id", billing_account_id)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if policy_data is not None:
            pulumi.set(__self__, "policy_data", policy_data)

    @property
    @pulumi.getter(name="billingAccountId")
    def billing_account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The billing account id.
        """
        return pulumi.get(self, "billing_account_id")

    @billing_account_id.setter
    def billing_account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "billing_account_id", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        (Computed) The etag of the billing account's IAM policy.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> Optional[pulumi.Input[str]]:
        """
        The policy data generated by a `organizations.get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @policy_data.setter
    def policy_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_data", value)


class AccountIamPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 billing_account_id: Optional[pulumi.Input[str]] = None,
                 policy_data: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Three different resources help you manage IAM policies on billing accounts. Each of these resources serves a different use case:

        * `billing.AccountIamPolicy`: Authoritative. Sets the IAM policy for the billing accounts and replaces any existing policy already attached.
        * `billing.AccountIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the table are preserved.
        * `billing.AccountIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role of the billing accounts are preserved.

        > **Note:** `billing.AccountIamPolicy` **cannot** be used in conjunction with `billing.AccountIamBinding` and `billing.AccountIamMember` or they will fight over what your policy should be. In addition, be careful not to accidentally unset ownership of the billing account as `billing.AccountIamPolicy` replaces the entire policy.

        > **Note:** `billing.AccountIamBinding` resources **can be** used in conjunction with `billing.AccountIamMember` resources **only if** they do not grant privilege to the same role.

        ## google\\_billing\\_account\\_iam\\_policy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[gcp.organizations.GetIAMPolicyBindingArgs(
            role="roles/billing.viewer",
            members=["user:jane@example.com"],
        )])
        editor = gcp.billing.AccountIamPolicy("editor",
            billing_account_id="00AA00-000AAA-00AA0A",
            policy_data=admin.policy_data)
        ```

        ## google\\_billing\\_account\\_iam\\_binding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        editor = gcp.billing.AccountIamBinding("editor",
            billing_account_id="00AA00-000AAA-00AA0A",
            members=["user:jane@example.com"],
            role="roles/billing.viewer")
        ```

        ## google\\_billing\\_account\\_iam\\_member

        ```python
        import pulumi
        import pulumi_gcp as gcp

        editor = gcp.billing.AccountIamMember("editor",
            billing_account_id="00AA00-000AAA-00AA0A",
            member="user:jane@example.com",
            role="roles/billing.viewer")
        ```

        ## Import

        Instance IAM resources can be imported using the project, table name, role and/or member.

        ```sh
         $ pulumi import gcp:billing/accountIamPolicy:AccountIamPolicy binding "your-billing-account-id"
        ```

        ```sh
         $ pulumi import gcp:billing/accountIamPolicy:AccountIamPolicy binding "your-billing-account-id roles/billing.user"
        ```

        ```sh
         $ pulumi import gcp:billing/accountIamPolicy:AccountIamPolicy binding "your-billing-account-id roles/billing.user user:jane@example.com"
        ```

         -> **Custom Roles**If you're importing a IAM resource with a custom role, make sure to use the

        full name of the custom role, e.g. `organizations/my-org-id/roles/my-custom-role`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] billing_account_id: The billing account id.
        :param pulumi.Input[str] policy_data: The policy data generated by a `organizations.get_iam_policy` data source.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountIamPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Three different resources help you manage IAM policies on billing accounts. Each of these resources serves a different use case:

        * `billing.AccountIamPolicy`: Authoritative. Sets the IAM policy for the billing accounts and replaces any existing policy already attached.
        * `billing.AccountIamBinding`: Authoritative for a given role. Updates the IAM policy to grant a role to a list of members. Other roles within the IAM policy for the table are preserved.
        * `billing.AccountIamMember`: Non-authoritative. Updates the IAM policy to grant a role to a new member. Other members for the role of the billing accounts are preserved.

        > **Note:** `billing.AccountIamPolicy` **cannot** be used in conjunction with `billing.AccountIamBinding` and `billing.AccountIamMember` or they will fight over what your policy should be. In addition, be careful not to accidentally unset ownership of the billing account as `billing.AccountIamPolicy` replaces the entire policy.

        > **Note:** `billing.AccountIamBinding` resources **can be** used in conjunction with `billing.AccountIamMember` resources **only if** they do not grant privilege to the same role.

        ## google\\_billing\\_account\\_iam\\_policy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        admin = gcp.organizations.get_iam_policy(bindings=[gcp.organizations.GetIAMPolicyBindingArgs(
            role="roles/billing.viewer",
            members=["user:jane@example.com"],
        )])
        editor = gcp.billing.AccountIamPolicy("editor",
            billing_account_id="00AA00-000AAA-00AA0A",
            policy_data=admin.policy_data)
        ```

        ## google\\_billing\\_account\\_iam\\_binding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        editor = gcp.billing.AccountIamBinding("editor",
            billing_account_id="00AA00-000AAA-00AA0A",
            members=["user:jane@example.com"],
            role="roles/billing.viewer")
        ```

        ## google\\_billing\\_account\\_iam\\_member

        ```python
        import pulumi
        import pulumi_gcp as gcp

        editor = gcp.billing.AccountIamMember("editor",
            billing_account_id="00AA00-000AAA-00AA0A",
            member="user:jane@example.com",
            role="roles/billing.viewer")
        ```

        ## Import

        Instance IAM resources can be imported using the project, table name, role and/or member.

        ```sh
         $ pulumi import gcp:billing/accountIamPolicy:AccountIamPolicy binding "your-billing-account-id"
        ```

        ```sh
         $ pulumi import gcp:billing/accountIamPolicy:AccountIamPolicy binding "your-billing-account-id roles/billing.user"
        ```

        ```sh
         $ pulumi import gcp:billing/accountIamPolicy:AccountIamPolicy binding "your-billing-account-id roles/billing.user user:jane@example.com"
        ```

         -> **Custom Roles**If you're importing a IAM resource with a custom role, make sure to use the

        full name of the custom role, e.g. `organizations/my-org-id/roles/my-custom-role`.

        :param str resource_name: The name of the resource.
        :param AccountIamPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountIamPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 billing_account_id: Optional[pulumi.Input[str]] = None,
                 policy_data: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountIamPolicyArgs.__new__(AccountIamPolicyArgs)

            if billing_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'billing_account_id'")
            __props__.__dict__["billing_account_id"] = billing_account_id
            if policy_data is None and not opts.urn:
                raise TypeError("Missing required property 'policy_data'")
            __props__.__dict__["policy_data"] = policy_data
            __props__.__dict__["etag"] = None
        super(AccountIamPolicy, __self__).__init__(
            'gcp:billing/accountIamPolicy:AccountIamPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            billing_account_id: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            policy_data: Optional[pulumi.Input[str]] = None) -> 'AccountIamPolicy':
        """
        Get an existing AccountIamPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] billing_account_id: The billing account id.
        :param pulumi.Input[str] etag: (Computed) The etag of the billing account's IAM policy.
        :param pulumi.Input[str] policy_data: The policy data generated by a `organizations.get_iam_policy` data source.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountIamPolicyState.__new__(_AccountIamPolicyState)

        __props__.__dict__["billing_account_id"] = billing_account_id
        __props__.__dict__["etag"] = etag
        __props__.__dict__["policy_data"] = policy_data
        return AccountIamPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="billingAccountId")
    def billing_account_id(self) -> pulumi.Output[str]:
        """
        The billing account id.
        """
        return pulumi.get(self, "billing_account_id")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        (Computed) The etag of the billing account's IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> pulumi.Output[str]:
        """
        The policy data generated by a `organizations.get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

