# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'CertificateManaged',
    'CertificateManagedAuthorizationAttemptInfo',
    'CertificateManagedProvisioningIssue',
    'CertificateMapGclbTarget',
    'CertificateMapGclbTargetIpConfig',
    'CertificateSelfManaged',
    'DnsAuthorizationDnsResourceRecord',
]

@pulumi.output_type
class CertificateManaged(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationAttemptInfos":
            suggest = "authorization_attempt_infos"
        elif key == "dnsAuthorizations":
            suggest = "dns_authorizations"
        elif key == "provisioningIssues":
            suggest = "provisioning_issues"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateManaged. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateManaged.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateManaged.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_attempt_infos: Optional[Sequence['outputs.CertificateManagedAuthorizationAttemptInfo']] = None,
                 dns_authorizations: Optional[Sequence[str]] = None,
                 domains: Optional[Sequence[str]] = None,
                 provisioning_issues: Optional[Sequence['outputs.CertificateManagedProvisioningIssue']] = None,
                 state: Optional[str] = None):
        """
        :param Sequence['CertificateManagedAuthorizationAttemptInfoArgs'] authorization_attempt_infos: -
               Detailed state of the latest authorization attempt for each domain
               specified for this Managed Certificate.
               Structure is documented below.
        :param Sequence[str] dns_authorizations: Authorizations that will be used for performing domain authorization
        :param Sequence[str] domains: The domains for which a managed SSL certificate will be generated.
               Wildcard domains are only supported with DNS challenge resolution
        :param Sequence['CertificateManagedProvisioningIssueArgs'] provisioning_issues: -
               Information about issues with provisioning this Managed Certificate.
               Structure is documented below.
        :param str state: -
               State of the domain for managed certificate issuance.
        """
        if authorization_attempt_infos is not None:
            pulumi.set(__self__, "authorization_attempt_infos", authorization_attempt_infos)
        if dns_authorizations is not None:
            pulumi.set(__self__, "dns_authorizations", dns_authorizations)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if provisioning_issues is not None:
            pulumi.set(__self__, "provisioning_issues", provisioning_issues)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="authorizationAttemptInfos")
    def authorization_attempt_infos(self) -> Optional[Sequence['outputs.CertificateManagedAuthorizationAttemptInfo']]:
        """
        -
        Detailed state of the latest authorization attempt for each domain
        specified for this Managed Certificate.
        Structure is documented below.
        """
        return pulumi.get(self, "authorization_attempt_infos")

    @property
    @pulumi.getter(name="dnsAuthorizations")
    def dns_authorizations(self) -> Optional[Sequence[str]]:
        """
        Authorizations that will be used for performing domain authorization
        """
        return pulumi.get(self, "dns_authorizations")

    @property
    @pulumi.getter
    def domains(self) -> Optional[Sequence[str]]:
        """
        The domains for which a managed SSL certificate will be generated.
        Wildcard domains are only supported with DNS challenge resolution
        """
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter(name="provisioningIssues")
    def provisioning_issues(self) -> Optional[Sequence['outputs.CertificateManagedProvisioningIssue']]:
        """
        -
        Information about issues with provisioning this Managed Certificate.
        Structure is documented below.
        """
        return pulumi.get(self, "provisioning_issues")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        -
        State of the domain for managed certificate issuance.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class CertificateManagedAuthorizationAttemptInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureReason":
            suggest = "failure_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateManagedAuthorizationAttemptInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateManagedAuthorizationAttemptInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateManagedAuthorizationAttemptInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 details: Optional[str] = None,
                 domain: Optional[str] = None,
                 failure_reason: Optional[str] = None,
                 state: Optional[str] = None):
        """
        :param str details: -
               Human readable explanation for reaching the state. Provided to help
               address the configuration issues.
               Not guaranteed to be stable. For programmatic access use `failure_reason` field.
        :param str domain: -
               Domain name of the authorization attempt.
        :param str failure_reason: -
               Reason for failure of the authorization attempt for the domain.
        :param str state: -
               State of the domain for managed certificate issuance.
        """
        if details is not None:
            pulumi.set(__self__, "details", details)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if failure_reason is not None:
            pulumi.set(__self__, "failure_reason", failure_reason)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def details(self) -> Optional[str]:
        """
        -
        Human readable explanation for reaching the state. Provided to help
        address the configuration issues.
        Not guaranteed to be stable. For programmatic access use `failure_reason` field.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        -
        Domain name of the authorization attempt.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="failureReason")
    def failure_reason(self) -> Optional[str]:
        """
        -
        Reason for failure of the authorization attempt for the domain.
        """
        return pulumi.get(self, "failure_reason")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        -
        State of the domain for managed certificate issuance.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class CertificateManagedProvisioningIssue(dict):
    def __init__(__self__, *,
                 details: Optional[str] = None,
                 reason: Optional[str] = None):
        """
        :param str details: -
               Human readable explanation for reaching the state. Provided to help
               address the configuration issues.
               Not guaranteed to be stable. For programmatic access use `failure_reason` field.
        :param str reason: -
               Reason for provisioning failures.
        """
        if details is not None:
            pulumi.set(__self__, "details", details)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def details(self) -> Optional[str]:
        """
        -
        Human readable explanation for reaching the state. Provided to help
        address the configuration issues.
        Not guaranteed to be stable. For programmatic access use `failure_reason` field.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        -
        Reason for provisioning failures.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class CertificateMapGclbTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipConfigs":
            suggest = "ip_configs"
        elif key == "targetHttpsProxy":
            suggest = "target_https_proxy"
        elif key == "targetSslProxy":
            suggest = "target_ssl_proxy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateMapGclbTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateMapGclbTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateMapGclbTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_configs: Optional[Sequence['outputs.CertificateMapGclbTargetIpConfig']] = None,
                 target_https_proxy: Optional[str] = None,
                 target_ssl_proxy: Optional[str] = None):
        if ip_configs is not None:
            pulumi.set(__self__, "ip_configs", ip_configs)
        if target_https_proxy is not None:
            pulumi.set(__self__, "target_https_proxy", target_https_proxy)
        if target_ssl_proxy is not None:
            pulumi.set(__self__, "target_ssl_proxy", target_ssl_proxy)

    @property
    @pulumi.getter(name="ipConfigs")
    def ip_configs(self) -> Optional[Sequence['outputs.CertificateMapGclbTargetIpConfig']]:
        return pulumi.get(self, "ip_configs")

    @property
    @pulumi.getter(name="targetHttpsProxy")
    def target_https_proxy(self) -> Optional[str]:
        return pulumi.get(self, "target_https_proxy")

    @property
    @pulumi.getter(name="targetSslProxy")
    def target_ssl_proxy(self) -> Optional[str]:
        return pulumi.get(self, "target_ssl_proxy")


@pulumi.output_type
class CertificateMapGclbTargetIpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateMapGclbTargetIpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateMapGclbTargetIpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateMapGclbTargetIpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: Optional[str] = None,
                 ports: Optional[Sequence[int]] = None):
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def ports(self) -> Optional[Sequence[int]]:
        return pulumi.get(self, "ports")


@pulumi.output_type
class CertificateSelfManaged(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificatePem":
            suggest = "certificate_pem"
        elif key == "pemCertificate":
            suggest = "pem_certificate"
        elif key == "pemPrivateKey":
            suggest = "pem_private_key"
        elif key == "privateKeyPem":
            suggest = "private_key_pem"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateSelfManaged. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateSelfManaged.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateSelfManaged.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_pem: Optional[str] = None,
                 pem_certificate: Optional[str] = None,
                 pem_private_key: Optional[str] = None,
                 private_key_pem: Optional[str] = None):
        """
        :param str certificate_pem: -
               (Optional, Deprecated)
               **Deprecated** The certificate chain in PEM-encoded form.
               Leaf certificate comes first, followed by intermediate ones if any.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str pem_certificate: The certificate chain in PEM-encoded form.
               Leaf certificate comes first, followed by intermediate ones if any.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str pem_private_key: The private key of the leaf certificate in PEM-encoded form.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param str private_key_pem: -
               (Optional, Deprecated)
               **Deprecated** The private key of the leaf certificate in PEM-encoded form.
               **Note**: This property is sensitive and will not be displayed in the plan.
        """
        if certificate_pem is not None:
            pulumi.set(__self__, "certificate_pem", certificate_pem)
        if pem_certificate is not None:
            pulumi.set(__self__, "pem_certificate", pem_certificate)
        if pem_private_key is not None:
            pulumi.set(__self__, "pem_private_key", pem_private_key)
        if private_key_pem is not None:
            pulumi.set(__self__, "private_key_pem", private_key_pem)

    @property
    @pulumi.getter(name="certificatePem")
    def certificate_pem(self) -> Optional[str]:
        """
        -
        (Optional, Deprecated)
        **Deprecated** The certificate chain in PEM-encoded form.
        Leaf certificate comes first, followed by intermediate ones if any.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "certificate_pem")

    @property
    @pulumi.getter(name="pemCertificate")
    def pem_certificate(self) -> Optional[str]:
        """
        The certificate chain in PEM-encoded form.
        Leaf certificate comes first, followed by intermediate ones if any.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "pem_certificate")

    @property
    @pulumi.getter(name="pemPrivateKey")
    def pem_private_key(self) -> Optional[str]:
        """
        The private key of the leaf certificate in PEM-encoded form.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "pem_private_key")

    @property
    @pulumi.getter(name="privateKeyPem")
    def private_key_pem(self) -> Optional[str]:
        """
        -
        (Optional, Deprecated)
        **Deprecated** The private key of the leaf certificate in PEM-encoded form.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "private_key_pem")


@pulumi.output_type
class DnsAuthorizationDnsResourceRecord(dict):
    def __init__(__self__, *,
                 data: Optional[str] = None,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str name: Name of the resource; provided by the client when the resource is created.
               The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
               and all following characters must be a dash, underscore, letter or digit.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def data(self) -> Optional[str]:
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the resource; provided by the client when the resource is created.
        The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
        and all following characters must be a dash, underscore, letter or digit.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


