# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'TriggerApprovalConfig',
    'TriggerBuild',
    'TriggerBuildArtifacts',
    'TriggerBuildArtifactsObjects',
    'TriggerBuildArtifactsObjectsTiming',
    'TriggerBuildAvailableSecrets',
    'TriggerBuildAvailableSecretsSecretManager',
    'TriggerBuildOptions',
    'TriggerBuildOptionsVolume',
    'TriggerBuildSecret',
    'TriggerBuildSource',
    'TriggerBuildSourceRepoSource',
    'TriggerBuildSourceStorageSource',
    'TriggerBuildStep',
    'TriggerBuildStepVolume',
    'TriggerGitFileSource',
    'TriggerGithub',
    'TriggerGithubPullRequest',
    'TriggerGithubPush',
    'TriggerPubsubConfig',
    'TriggerSourceToBuild',
    'TriggerTriggerTemplate',
    'TriggerWebhookConfig',
    'WorkerPoolNetworkConfig',
    'WorkerPoolWorkerConfig',
]

@pulumi.output_type
class TriggerApprovalConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "approvalRequired":
            suggest = "approval_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerApprovalConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerApprovalConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerApprovalConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 approval_required: Optional[bool] = None):
        """
        :param bool approval_required: Whether or not approval is needed. If this is set on a build, it will become pending when run,
               and will need to be explicitly approved to start.
        """
        if approval_required is not None:
            pulumi.set(__self__, "approval_required", approval_required)

    @property
    @pulumi.getter(name="approvalRequired")
    def approval_required(self) -> Optional[bool]:
        """
        Whether or not approval is needed. If this is set on a build, it will become pending when run,
        and will need to be explicitly approved to start.
        """
        return pulumi.get(self, "approval_required")


@pulumi.output_type
class TriggerBuild(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableSecrets":
            suggest = "available_secrets"
        elif key == "logsBucket":
            suggest = "logs_bucket"
        elif key == "queueTtl":
            suggest = "queue_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBuild. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBuild.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBuild.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 steps: Sequence['outputs.TriggerBuildStep'],
                 artifacts: Optional['outputs.TriggerBuildArtifacts'] = None,
                 available_secrets: Optional['outputs.TriggerBuildAvailableSecrets'] = None,
                 images: Optional[Sequence[str]] = None,
                 logs_bucket: Optional[str] = None,
                 options: Optional['outputs.TriggerBuildOptions'] = None,
                 queue_ttl: Optional[str] = None,
                 secrets: Optional[Sequence['outputs.TriggerBuildSecret']] = None,
                 source: Optional['outputs.TriggerBuildSource'] = None,
                 substitutions: Optional[Mapping[str, str]] = None,
                 tags: Optional[Sequence[str]] = None,
                 timeout: Optional[str] = None):
        """
        :param Sequence['TriggerBuildStepArgs'] steps: The operations to be performed on the workspace.
               Structure is documented below.
        :param 'TriggerBuildArtifactsArgs' artifacts: Artifacts produced by the build that should be uploaded upon successful completion of all build steps.
               Structure is documented below.
        :param 'TriggerBuildAvailableSecretsArgs' available_secrets: Secrets and secret environment variables.
               Structure is documented below.
        :param Sequence[str] images: A list of images to be pushed upon the successful completion of all build steps.
               The images will be pushed using the builder service account's credentials.
               The digests of the pushed images will be stored in the Build resource's results field.
               If any of the images fail to be pushed, the build is marked FAILURE.
        :param str logs_bucket: Google Cloud Storage bucket where logs should be written.
               Logs file names will be of the format ${logsBucket}/log-${build_id}.txt.
        :param 'TriggerBuildOptionsArgs' options: Special options for this build.
               Structure is documented below.
        :param str queue_ttl: TTL in queue for this build. If provided and the build is enqueued longer than this value,
               the build will expire and the build status will be EXPIRED.
               The TTL starts ticking from createTime.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param Sequence['TriggerBuildSecretArgs'] secrets: Secrets to decrypt using Cloud Key Management Service.
               Structure is documented below.
        :param 'TriggerBuildSourceArgs' source: The location of the source files to build.
               One of `storageSource` or `repoSource` must be provided.
               Structure is documented below.
        :param Mapping[str, str] substitutions: Substitutions to use in a triggered build. Should only be used with triggers.run
        :param Sequence[str] tags: Tags for annotation of a Build. These are not docker tags.
        :param str timeout: Time limit for executing this build step. If not defined,
               the step has no
               time limit and will be allowed to continue to run until either it
               completes or the build itself times out.
        """
        pulumi.set(__self__, "steps", steps)
        if artifacts is not None:
            pulumi.set(__self__, "artifacts", artifacts)
        if available_secrets is not None:
            pulumi.set(__self__, "available_secrets", available_secrets)
        if images is not None:
            pulumi.set(__self__, "images", images)
        if logs_bucket is not None:
            pulumi.set(__self__, "logs_bucket", logs_bucket)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if queue_ttl is not None:
            pulumi.set(__self__, "queue_ttl", queue_ttl)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if substitutions is not None:
            pulumi.set(__self__, "substitutions", substitutions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def steps(self) -> Sequence['outputs.TriggerBuildStep']:
        """
        The operations to be performed on the workspace.
        Structure is documented below.
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter
    def artifacts(self) -> Optional['outputs.TriggerBuildArtifacts']:
        """
        Artifacts produced by the build that should be uploaded upon successful completion of all build steps.
        Structure is documented below.
        """
        return pulumi.get(self, "artifacts")

    @property
    @pulumi.getter(name="availableSecrets")
    def available_secrets(self) -> Optional['outputs.TriggerBuildAvailableSecrets']:
        """
        Secrets and secret environment variables.
        Structure is documented below.
        """
        return pulumi.get(self, "available_secrets")

    @property
    @pulumi.getter
    def images(self) -> Optional[Sequence[str]]:
        """
        A list of images to be pushed upon the successful completion of all build steps.
        The images will be pushed using the builder service account's credentials.
        The digests of the pushed images will be stored in the Build resource's results field.
        If any of the images fail to be pushed, the build is marked FAILURE.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="logsBucket")
    def logs_bucket(self) -> Optional[str]:
        """
        Google Cloud Storage bucket where logs should be written.
        Logs file names will be of the format ${logsBucket}/log-${build_id}.txt.
        """
        return pulumi.get(self, "logs_bucket")

    @property
    @pulumi.getter
    def options(self) -> Optional['outputs.TriggerBuildOptions']:
        """
        Special options for this build.
        Structure is documented below.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="queueTtl")
    def queue_ttl(self) -> Optional[str]:
        """
        TTL in queue for this build. If provided and the build is enqueued longer than this value,
        the build will expire and the build status will be EXPIRED.
        The TTL starts ticking from createTime.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "queue_ttl")

    @property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.TriggerBuildSecret']]:
        """
        Secrets to decrypt using Cloud Key Management Service.
        Structure is documented below.
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter
    def source(self) -> Optional['outputs.TriggerBuildSource']:
        """
        The location of the source files to build.
        One of `storageSource` or `repoSource` must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def substitutions(self) -> Optional[Mapping[str, str]]:
        """
        Substitutions to use in a triggered build. Should only be used with triggers.run
        """
        return pulumi.get(self, "substitutions")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        Tags for annotation of a Build. These are not docker tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        Time limit for executing this build step. If not defined,
        the step has no
        time limit and will be allowed to continue to run until either it
        completes or the build itself times out.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class TriggerBuildArtifacts(dict):
    def __init__(__self__, *,
                 images: Optional[Sequence[str]] = None,
                 objects: Optional['outputs.TriggerBuildArtifactsObjects'] = None):
        """
        :param Sequence[str] images: A list of images to be pushed upon the successful completion of all build steps.
               The images will be pushed using the builder service account's credentials.
               The digests of the pushed images will be stored in the Build resource's results field.
               If any of the images fail to be pushed, the build is marked FAILURE.
        :param 'TriggerBuildArtifactsObjectsArgs' objects: A list of objects to be uploaded to Cloud Storage upon successful completion of all build steps.
               Files in the workspace matching specified paths globs will be uploaded to the
               Cloud Storage location using the builder service account's credentials.
               The location and generation of the uploaded objects will be stored in the Build resource's results field.
               If any objects fail to be pushed, the build is marked FAILURE.
               Structure is documented below.
        """
        if images is not None:
            pulumi.set(__self__, "images", images)
        if objects is not None:
            pulumi.set(__self__, "objects", objects)

    @property
    @pulumi.getter
    def images(self) -> Optional[Sequence[str]]:
        """
        A list of images to be pushed upon the successful completion of all build steps.
        The images will be pushed using the builder service account's credentials.
        The digests of the pushed images will be stored in the Build resource's results field.
        If any of the images fail to be pushed, the build is marked FAILURE.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter
    def objects(self) -> Optional['outputs.TriggerBuildArtifactsObjects']:
        """
        A list of objects to be uploaded to Cloud Storage upon successful completion of all build steps.
        Files in the workspace matching specified paths globs will be uploaded to the
        Cloud Storage location using the builder service account's credentials.
        The location and generation of the uploaded objects will be stored in the Build resource's results field.
        If any objects fail to be pushed, the build is marked FAILURE.
        Structure is documented below.
        """
        return pulumi.get(self, "objects")


@pulumi.output_type
class TriggerBuildArtifactsObjects(dict):
    def __init__(__self__, *,
                 location: Optional[str] = None,
                 paths: Optional[Sequence[str]] = None,
                 timings: Optional[Sequence['outputs.TriggerBuildArtifactsObjectsTiming']] = None):
        """
        :param str location: Cloud Storage bucket and optional object path, in the form "gs://bucket/path/to/somewhere/".
               Files in the workspace matching any path pattern will be uploaded to Cloud Storage with
               this location as a prefix.
        :param Sequence[str] paths: Path globs used to match files in the build's workspace.
        :param Sequence['TriggerBuildArtifactsObjectsTimingArgs'] timings: -
               Output only. Stores timing information for pushing all artifact objects.
               Structure is documented below.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if timings is not None:
            pulumi.set(__self__, "timings", timings)

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        Cloud Storage bucket and optional object path, in the form "gs://bucket/path/to/somewhere/".
        Files in the workspace matching any path pattern will be uploaded to Cloud Storage with
        this location as a prefix.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def paths(self) -> Optional[Sequence[str]]:
        """
        Path globs used to match files in the build's workspace.
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter
    def timings(self) -> Optional[Sequence['outputs.TriggerBuildArtifactsObjectsTiming']]:
        """
        -
        Output only. Stores timing information for pushing all artifact objects.
        Structure is documented below.
        """
        return pulumi.get(self, "timings")


@pulumi.output_type
class TriggerBuildArtifactsObjectsTiming(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBuildArtifactsObjectsTiming. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBuildArtifactsObjectsTiming.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBuildArtifactsObjectsTiming.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: Optional[str] = None,
                 start_time: Optional[str] = None):
        """
        :param str end_time: End of time span.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
               nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param str start_time: Start of time span.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
               nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        End of time span.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
        nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        Start of time span.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
        nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class TriggerBuildAvailableSecrets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretManagers":
            suggest = "secret_managers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBuildAvailableSecrets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBuildAvailableSecrets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBuildAvailableSecrets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_managers: Sequence['outputs.TriggerBuildAvailableSecretsSecretManager']):
        """
        :param Sequence['TriggerBuildAvailableSecretsSecretManagerArgs'] secret_managers: Pairs a secret environment variable with a SecretVersion in Secret Manager.
               Structure is documented below.
        """
        pulumi.set(__self__, "secret_managers", secret_managers)

    @property
    @pulumi.getter(name="secretManagers")
    def secret_managers(self) -> Sequence['outputs.TriggerBuildAvailableSecretsSecretManager']:
        """
        Pairs a secret environment variable with a SecretVersion in Secret Manager.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_managers")


@pulumi.output_type
class TriggerBuildAvailableSecretsSecretManager(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "versionName":
            suggest = "version_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBuildAvailableSecretsSecretManager. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBuildAvailableSecretsSecretManager.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBuildAvailableSecretsSecretManager.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 env: str,
                 version_name: str):
        """
        :param str env: A list of global environment variable definitions that will exist for all build steps
               in this build. If a variable is defined in both globally and in a build step,
               the variable will use the build step value.
               The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        :param str version_name: Resource name of the SecretVersion. In format: projects/*/secrets/*/versions/*
        """
        pulumi.set(__self__, "env", env)
        pulumi.set(__self__, "version_name", version_name)

    @property
    @pulumi.getter
    def env(self) -> str:
        """
        A list of global environment variable definitions that will exist for all build steps
        in this build. If a variable is defined in both globally and in a build step,
        the variable will use the build step value.
        The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> str:
        """
        Resource name of the SecretVersion. In format: projects/*/secrets/*/versions/*
        """
        return pulumi.get(self, "version_name")


@pulumi.output_type
class TriggerBuildOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "dynamicSubstitutions":
            suggest = "dynamic_substitutions"
        elif key == "logStreamingOption":
            suggest = "log_streaming_option"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "requestedVerifyOption":
            suggest = "requested_verify_option"
        elif key == "secretEnvs":
            suggest = "secret_envs"
        elif key == "sourceProvenanceHashes":
            suggest = "source_provenance_hashes"
        elif key == "substitutionOption":
            suggest = "substitution_option"
        elif key == "workerPool":
            suggest = "worker_pool"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBuildOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBuildOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBuildOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_size_gb: Optional[int] = None,
                 dynamic_substitutions: Optional[bool] = None,
                 envs: Optional[Sequence[str]] = None,
                 log_streaming_option: Optional[str] = None,
                 logging: Optional[str] = None,
                 machine_type: Optional[str] = None,
                 requested_verify_option: Optional[str] = None,
                 secret_envs: Optional[Sequence[str]] = None,
                 source_provenance_hashes: Optional[Sequence[str]] = None,
                 substitution_option: Optional[str] = None,
                 volumes: Optional[Sequence['outputs.TriggerBuildOptionsVolume']] = None,
                 worker_pool: Optional[str] = None):
        """
        :param int disk_size_gb: Requested disk size for the VM that runs the build. Note that this is NOT "disk free";
               some of the space will be used by the operating system and build utilities.
               Also note that this is the minimum disk size that will be allocated for the build --
               the build may run with a larger disk than requested. At present, the maximum disk size
               is 1000GB; builds that request more than the maximum are rejected with an error.
        :param bool dynamic_substitutions: Option to specify whether or not to apply bash style string operations to the substitutions.
               NOTE this is always enabled for triggered builds and cannot be overridden in the build configuration file.
        :param Sequence[str] envs: A list of global environment variable definitions that will exist for all build steps
               in this build. If a variable is defined in both globally and in a build step,
               the variable will use the build step value.
               The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        :param str log_streaming_option: Option to define build log streaming behavior to Google Cloud Storage.
               Possible values are `STREAM_DEFAULT`, `STREAM_ON`, and `STREAM_OFF`.
        :param str logging: Option to specify the logging mode, which determines if and where build logs are stored.
               Possible values are `LOGGING_UNSPECIFIED`, `LEGACY`, `GCS_ONLY`, `STACKDRIVER_ONLY`, `CLOUD_LOGGING_ONLY`, and `NONE`.
        :param str machine_type: Compute Engine machine type on which to run the build.
               Possible values are `UNSPECIFIED`, `N1_HIGHCPU_8`, `N1_HIGHCPU_32`, `E2_HIGHCPU_8`, and `E2_HIGHCPU_32`.
        :param str requested_verify_option: Requested verifiability options.
               Possible values are `NOT_VERIFIED` and `VERIFIED`.
        :param Sequence[str] secret_envs: A list of global environment variables, which are encrypted using a Cloud Key Management
               Service crypto key. These values must be specified in the build's Secret. These variables
               will be available to all build steps in this build.
        :param Sequence[str] source_provenance_hashes: Requested hash for SourceProvenance.
               Each value may be one of `NONE`, `SHA256`, and `MD5`.
        :param str substitution_option: Option to specify behavior when there is an error in the substitution checks.
               NOTE this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden
               in the build configuration file.
               Possible values are `MUST_MATCH` and `ALLOW_LOOSE`.
        :param Sequence['TriggerBuildOptionsVolumeArgs'] volumes: Global list of volumes to mount for ALL build steps
               Each volume is created as an empty volume prior to starting the build process.
               Upon completion of the build, volumes and their contents are discarded. Global
               volume names and paths cannot conflict with the volumes defined a build step.
               Using a global volume in a build with only one step is not valid as it is indicative
               of a build request with an incorrect configuration.
               Structure is documented below.
        :param str worker_pool: Option to specify a WorkerPool for the build. Format projects/{project}/workerPools/{workerPool}
               This field is experimental.
        """
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if dynamic_substitutions is not None:
            pulumi.set(__self__, "dynamic_substitutions", dynamic_substitutions)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if log_streaming_option is not None:
            pulumi.set(__self__, "log_streaming_option", log_streaming_option)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if requested_verify_option is not None:
            pulumi.set(__self__, "requested_verify_option", requested_verify_option)
        if secret_envs is not None:
            pulumi.set(__self__, "secret_envs", secret_envs)
        if source_provenance_hashes is not None:
            pulumi.set(__self__, "source_provenance_hashes", source_provenance_hashes)
        if substitution_option is not None:
            pulumi.set(__self__, "substitution_option", substitution_option)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if worker_pool is not None:
            pulumi.set(__self__, "worker_pool", worker_pool)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[int]:
        """
        Requested disk size for the VM that runs the build. Note that this is NOT "disk free";
        some of the space will be used by the operating system and build utilities.
        Also note that this is the minimum disk size that will be allocated for the build --
        the build may run with a larger disk than requested. At present, the maximum disk size
        is 1000GB; builds that request more than the maximum are rejected with an error.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="dynamicSubstitutions")
    def dynamic_substitutions(self) -> Optional[bool]:
        """
        Option to specify whether or not to apply bash style string operations to the substitutions.
        NOTE this is always enabled for triggered builds and cannot be overridden in the build configuration file.
        """
        return pulumi.get(self, "dynamic_substitutions")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence[str]]:
        """
        A list of global environment variable definitions that will exist for all build steps
        in this build. If a variable is defined in both globally and in a build step,
        the variable will use the build step value.
        The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter(name="logStreamingOption")
    def log_streaming_option(self) -> Optional[str]:
        """
        Option to define build log streaming behavior to Google Cloud Storage.
        Possible values are `STREAM_DEFAULT`, `STREAM_ON`, and `STREAM_OFF`.
        """
        return pulumi.get(self, "log_streaming_option")

    @property
    @pulumi.getter
    def logging(self) -> Optional[str]:
        """
        Option to specify the logging mode, which determines if and where build logs are stored.
        Possible values are `LOGGING_UNSPECIFIED`, `LEGACY`, `GCS_ONLY`, `STACKDRIVER_ONLY`, `CLOUD_LOGGING_ONLY`, and `NONE`.
        """
        return pulumi.get(self, "logging")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[str]:
        """
        Compute Engine machine type on which to run the build.
        Possible values are `UNSPECIFIED`, `N1_HIGHCPU_8`, `N1_HIGHCPU_32`, `E2_HIGHCPU_8`, and `E2_HIGHCPU_32`.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter(name="requestedVerifyOption")
    def requested_verify_option(self) -> Optional[str]:
        """
        Requested verifiability options.
        Possible values are `NOT_VERIFIED` and `VERIFIED`.
        """
        return pulumi.get(self, "requested_verify_option")

    @property
    @pulumi.getter(name="secretEnvs")
    def secret_envs(self) -> Optional[Sequence[str]]:
        """
        A list of global environment variables, which are encrypted using a Cloud Key Management
        Service crypto key. These values must be specified in the build's Secret. These variables
        will be available to all build steps in this build.
        """
        return pulumi.get(self, "secret_envs")

    @property
    @pulumi.getter(name="sourceProvenanceHashes")
    def source_provenance_hashes(self) -> Optional[Sequence[str]]:
        """
        Requested hash for SourceProvenance.
        Each value may be one of `NONE`, `SHA256`, and `MD5`.
        """
        return pulumi.get(self, "source_provenance_hashes")

    @property
    @pulumi.getter(name="substitutionOption")
    def substitution_option(self) -> Optional[str]:
        """
        Option to specify behavior when there is an error in the substitution checks.
        NOTE this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden
        in the build configuration file.
        Possible values are `MUST_MATCH` and `ALLOW_LOOSE`.
        """
        return pulumi.get(self, "substitution_option")

    @property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.TriggerBuildOptionsVolume']]:
        """
        Global list of volumes to mount for ALL build steps
        Each volume is created as an empty volume prior to starting the build process.
        Upon completion of the build, volumes and their contents are discarded. Global
        volume names and paths cannot conflict with the volumes defined a build step.
        Using a global volume in a build with only one step is not valid as it is indicative
        of a build request with an incorrect configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="workerPool")
    def worker_pool(self) -> Optional[str]:
        """
        Option to specify a WorkerPool for the build. Format projects/{project}/workerPools/{workerPool}
        This field is experimental.
        """
        return pulumi.get(self, "worker_pool")


@pulumi.output_type
class TriggerBuildOptionsVolume(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 path: Optional[str] = None):
        """
        :param str name: Name of the volume to mount.
               Volume names must be unique per build step and must be valid names for Docker volumes.
               Each named volume must be used by at least two build steps.
        :param str path: Path at which to mount the volume.
               Paths must be absolute and cannot conflict with other volume paths on the same
               build step or with certain reserved volume paths.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the volume to mount.
        Volume names must be unique per build step and must be valid names for Docker volumes.
        Each named volume must be used by at least two build steps.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Path at which to mount the volume.
        Paths must be absolute and cannot conflict with other volume paths on the same
        build step or with certain reserved volume paths.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class TriggerBuildSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "secretEnv":
            suggest = "secret_env"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBuildSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBuildSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBuildSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: str,
                 secret_env: Optional[Mapping[str, str]] = None):
        """
        :param str kms_key_name: Cloud KMS key name to use to decrypt these envs.
        :param Mapping[str, str] secret_env: A list of global environment variables, which are encrypted using a Cloud Key Management
               Service crypto key. These values must be specified in the build's Secret. These variables
               will be available to all build steps in this build.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if secret_env is not None:
            pulumi.set(__self__, "secret_env", secret_env)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Cloud KMS key name to use to decrypt these envs.
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter(name="secretEnv")
    def secret_env(self) -> Optional[Mapping[str, str]]:
        """
        A list of global environment variables, which are encrypted using a Cloud Key Management
        Service crypto key. These values must be specified in the build's Secret. These variables
        will be available to all build steps in this build.
        """
        return pulumi.get(self, "secret_env")


@pulumi.output_type
class TriggerBuildSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoSource":
            suggest = "repo_source"
        elif key == "storageSource":
            suggest = "storage_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBuildSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBuildSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBuildSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repo_source: Optional['outputs.TriggerBuildSourceRepoSource'] = None,
                 storage_source: Optional['outputs.TriggerBuildSourceStorageSource'] = None):
        """
        :param 'TriggerBuildSourceRepoSourceArgs' repo_source: Location of the source in a Google Cloud Source Repository.
               Structure is documented below.
        :param 'TriggerBuildSourceStorageSourceArgs' storage_source: Location of the source in an archive file in Google Cloud Storage.
               Structure is documented below.
        """
        if repo_source is not None:
            pulumi.set(__self__, "repo_source", repo_source)
        if storage_source is not None:
            pulumi.set(__self__, "storage_source", storage_source)

    @property
    @pulumi.getter(name="repoSource")
    def repo_source(self) -> Optional['outputs.TriggerBuildSourceRepoSource']:
        """
        Location of the source in a Google Cloud Source Repository.
        Structure is documented below.
        """
        return pulumi.get(self, "repo_source")

    @property
    @pulumi.getter(name="storageSource")
    def storage_source(self) -> Optional['outputs.TriggerBuildSourceStorageSource']:
        """
        Location of the source in an archive file in Google Cloud Storage.
        Structure is documented below.
        """
        return pulumi.get(self, "storage_source")


@pulumi.output_type
class TriggerBuildSourceRepoSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoName":
            suggest = "repo_name"
        elif key == "branchName":
            suggest = "branch_name"
        elif key == "commitSha":
            suggest = "commit_sha"
        elif key == "invertRegex":
            suggest = "invert_regex"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "tagName":
            suggest = "tag_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBuildSourceRepoSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBuildSourceRepoSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBuildSourceRepoSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repo_name: str,
                 branch_name: Optional[str] = None,
                 commit_sha: Optional[str] = None,
                 dir: Optional[str] = None,
                 invert_regex: Optional[bool] = None,
                 project_id: Optional[str] = None,
                 substitutions: Optional[Mapping[str, str]] = None,
                 tag_name: Optional[str] = None):
        """
        :param str repo_name: Name of the Cloud Source Repository.
        :param str branch_name: Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided.
               The syntax of the regular expressions accepted is the syntax accepted by RE2 and
               described at https://github.com/google/re2/wiki/Syntax
        :param str commit_sha: Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        :param str dir: Working directory to use when running this step's container.
               If this value is a relative path, it is relative to the build's working
               directory. If this value is absolute, it may be outside the build's working
               directory, in which case the contents of the path may not be persisted
               across build step executions, unless a `volume` for that path is specified.
               If the build specifies a `RepoSource` with `dir` and a step with a
               `dir`,
               which specifies an absolute path, the `RepoSource` `dir` is ignored
               for the step's execution.
        :param bool invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        :param str project_id: ID of the project that owns the Cloud Source Repository.
               If omitted, the project ID requesting the build is assumed.
        :param Mapping[str, str] substitutions: Substitutions to use in a triggered build. Should only be used with triggers.run
        :param str tag_name: Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided.
               The syntax of the regular expressions accepted is the syntax accepted by RE2 and
               described at https://github.com/google/re2/wiki/Syntax
        """
        pulumi.set(__self__, "repo_name", repo_name)
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if commit_sha is not None:
            pulumi.set(__self__, "commit_sha", commit_sha)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if substitutions is not None:
            pulumi.set(__self__, "substitutions", substitutions)
        if tag_name is not None:
            pulumi.set(__self__, "tag_name", tag_name)

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> str:
        """
        Name of the Cloud Source Repository.
        """
        return pulumi.get(self, "repo_name")

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[str]:
        """
        Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and
        described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch_name")

    @property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> Optional[str]:
        """
        Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        """
        return pulumi.get(self, "commit_sha")

    @property
    @pulumi.getter
    def dir(self) -> Optional[str]:
        """
        Working directory to use when running this step's container.
        If this value is a relative path, it is relative to the build's working
        directory. If this value is absolute, it may be outside the build's working
        directory, in which case the contents of the path may not be persisted
        across build step executions, unless a `volume` for that path is specified.
        If the build specifies a `RepoSource` with `dir` and a step with a
        `dir`,
        which specifies an absolute path, the `RepoSource` `dir` is ignored
        for the step's execution.
        """
        return pulumi.get(self, "dir")

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[bool]:
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        ID of the project that owns the Cloud Source Repository.
        If omitted, the project ID requesting the build is assumed.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def substitutions(self) -> Optional[Mapping[str, str]]:
        """
        Substitutions to use in a triggered build. Should only be used with triggers.run
        """
        return pulumi.get(self, "substitutions")

    @property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[str]:
        """
        Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and
        described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "tag_name")


@pulumi.output_type
class TriggerBuildSourceStorageSource(dict):
    def __init__(__self__, *,
                 bucket: str,
                 object: str,
                 generation: Optional[str] = None):
        """
        :param str bucket: Google Cloud Storage bucket containing the source.
        :param str object: Google Cloud Storage object containing the source.
               This object must be a gzipped archive file (.tar.gz) containing source to build.
        :param str generation: Google Cloud Storage generation for the object.
               If the generation is omitted, the latest generation will be used
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "object", object)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Google Cloud Storage bucket containing the source.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Google Cloud Storage object containing the source.
        This object must be a gzipped archive file (.tar.gz) containing source to build.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def generation(self) -> Optional[str]:
        """
        Google Cloud Storage generation for the object.
        If the generation is omitted, the latest generation will be used
        """
        return pulumi.get(self, "generation")


@pulumi.output_type
class TriggerBuildStep(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretEnvs":
            suggest = "secret_envs"
        elif key == "waitFors":
            suggest = "wait_fors"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerBuildStep. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerBuildStep.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerBuildStep.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 args: Optional[Sequence[str]] = None,
                 dir: Optional[str] = None,
                 entrypoint: Optional[str] = None,
                 envs: Optional[Sequence[str]] = None,
                 id: Optional[str] = None,
                 script: Optional[str] = None,
                 secret_envs: Optional[Sequence[str]] = None,
                 timeout: Optional[str] = None,
                 timing: Optional[str] = None,
                 volumes: Optional[Sequence['outputs.TriggerBuildStepVolume']] = None,
                 wait_fors: Optional[Sequence[str]] = None):
        """
        :param str name: Name of the volume to mount.
               Volume names must be unique per build step and must be valid names for Docker volumes.
               Each named volume must be used by at least two build steps.
        :param Sequence[str] args: A list of arguments that will be presented to the step when it is started.
               If the image used to run the step's container has an entrypoint, the args
               are used as arguments to that entrypoint. If the image does not define an
               entrypoint, the first element in args is used as the entrypoint, and the
               remainder will be used as arguments.
        :param str dir: Working directory to use when running this step's container.
               If this value is a relative path, it is relative to the build's working
               directory. If this value is absolute, it may be outside the build's working
               directory, in which case the contents of the path may not be persisted
               across build step executions, unless a `volume` for that path is specified.
               If the build specifies a `RepoSource` with `dir` and a step with a
               `dir`,
               which specifies an absolute path, the `RepoSource` `dir` is ignored
               for the step's execution.
        :param str entrypoint: Entrypoint to be used instead of the build step image's
               default entrypoint.
               If unset, the image's default entrypoint is used
        :param Sequence[str] envs: A list of global environment variable definitions that will exist for all build steps
               in this build. If a variable is defined in both globally and in a build step,
               the variable will use the build step value.
               The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        :param str id: Unique identifier for this build step, used in `wait_for` to
               reference this build step as a dependency.
        :param str script: A shell script to be executed in the step.
               When script is provided, the user cannot specify the entrypoint or args.
        :param Sequence[str] secret_envs: A list of global environment variables, which are encrypted using a Cloud Key Management
               Service crypto key. These values must be specified in the build's Secret. These variables
               will be available to all build steps in this build.
        :param str timeout: Time limit for executing this build step. If not defined,
               the step has no
               time limit and will be allowed to continue to run until either it
               completes or the build itself times out.
        :param str timing: -
               Output only. Stores timing information for pushing all artifact objects.
               Structure is documented below.
        :param Sequence['TriggerBuildStepVolumeArgs'] volumes: Global list of volumes to mount for ALL build steps
               Each volume is created as an empty volume prior to starting the build process.
               Upon completion of the build, volumes and their contents are discarded. Global
               volume names and paths cannot conflict with the volumes defined a build step.
               Using a global volume in a build with only one step is not valid as it is indicative
               of a build request with an incorrect configuration.
               Structure is documented below.
        :param Sequence[str] wait_fors: The ID(s) of the step(s) that this build step depends on.
               This build step will not start until all the build steps in `wait_for`
               have completed successfully. If `wait_for` is empty, this build step
               will start when all previous build steps in the `Build.Steps` list
               have completed successfully.
        """
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if entrypoint is not None:
            pulumi.set(__self__, "entrypoint", entrypoint)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if secret_envs is not None:
            pulumi.set(__self__, "secret_envs", secret_envs)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if timing is not None:
            pulumi.set(__self__, "timing", timing)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if wait_fors is not None:
            pulumi.set(__self__, "wait_fors", wait_fors)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the volume to mount.
        Volume names must be unique per build step and must be valid names for Docker volumes.
        Each named volume must be used by at least two build steps.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        A list of arguments that will be presented to the step when it is started.
        If the image used to run the step's container has an entrypoint, the args
        are used as arguments to that entrypoint. If the image does not define an
        entrypoint, the first element in args is used as the entrypoint, and the
        remainder will be used as arguments.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def dir(self) -> Optional[str]:
        """
        Working directory to use when running this step's container.
        If this value is a relative path, it is relative to the build's working
        directory. If this value is absolute, it may be outside the build's working
        directory, in which case the contents of the path may not be persisted
        across build step executions, unless a `volume` for that path is specified.
        If the build specifies a `RepoSource` with `dir` and a step with a
        `dir`,
        which specifies an absolute path, the `RepoSource` `dir` is ignored
        for the step's execution.
        """
        return pulumi.get(self, "dir")

    @property
    @pulumi.getter
    def entrypoint(self) -> Optional[str]:
        """
        Entrypoint to be used instead of the build step image's
        default entrypoint.
        If unset, the image's default entrypoint is used
        """
        return pulumi.get(self, "entrypoint")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence[str]]:
        """
        A list of global environment variable definitions that will exist for all build steps
        in this build. If a variable is defined in both globally and in a build step,
        the variable will use the build step value.
        The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier for this build step, used in `wait_for` to
        reference this build step as a dependency.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def script(self) -> Optional[str]:
        """
        A shell script to be executed in the step.
        When script is provided, the user cannot specify the entrypoint or args.
        """
        return pulumi.get(self, "script")

    @property
    @pulumi.getter(name="secretEnvs")
    def secret_envs(self) -> Optional[Sequence[str]]:
        """
        A list of global environment variables, which are encrypted using a Cloud Key Management
        Service crypto key. These values must be specified in the build's Secret. These variables
        will be available to all build steps in this build.
        """
        return pulumi.get(self, "secret_envs")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        Time limit for executing this build step. If not defined,
        the step has no
        time limit and will be allowed to continue to run until either it
        completes or the build itself times out.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def timing(self) -> Optional[str]:
        """
        -
        Output only. Stores timing information for pushing all artifact objects.
        Structure is documented below.
        """
        return pulumi.get(self, "timing")

    @property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.TriggerBuildStepVolume']]:
        """
        Global list of volumes to mount for ALL build steps
        Each volume is created as an empty volume prior to starting the build process.
        Upon completion of the build, volumes and their contents are discarded. Global
        volume names and paths cannot conflict with the volumes defined a build step.
        Using a global volume in a build with only one step is not valid as it is indicative
        of a build request with an incorrect configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="waitFors")
    def wait_fors(self) -> Optional[Sequence[str]]:
        """
        The ID(s) of the step(s) that this build step depends on.
        This build step will not start until all the build steps in `wait_for`
        have completed successfully. If `wait_for` is empty, this build step
        will start when all previous build steps in the `Build.Steps` list
        have completed successfully.
        """
        return pulumi.get(self, "wait_fors")


@pulumi.output_type
class TriggerBuildStepVolume(dict):
    def __init__(__self__, *,
                 name: str,
                 path: str):
        """
        :param str name: Name of the volume to mount.
               Volume names must be unique per build step and must be valid names for Docker volumes.
               Each named volume must be used by at least two build steps.
        :param str path: Path at which to mount the volume.
               Paths must be absolute and cannot conflict with other volume paths on the same
               build step or with certain reserved volume paths.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the volume to mount.
        Volume names must be unique per build step and must be valid names for Docker volumes.
        Each named volume must be used by at least two build steps.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path at which to mount the volume.
        Paths must be absolute and cannot conflict with other volume paths on the same
        build step or with certain reserved volume paths.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class TriggerGitFileSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoType":
            suggest = "repo_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerGitFileSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerGitFileSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerGitFileSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: str,
                 repo_type: str,
                 revision: Optional[str] = None,
                 uri: Optional[str] = None):
        """
        :param str path: Path at which to mount the volume.
               Paths must be absolute and cannot conflict with other volume paths on the same
               build step or with certain reserved volume paths.
        :param str repo_type: The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
               Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET_SERVER
               Possible values are `UNKNOWN`, `CLOUD_SOURCE_REPOSITORIES`, `GITHUB`, and `BITBUCKET_SERVER`.
        :param str revision: The branch, tag, arbitrary ref, or SHA version of the repo to use when resolving the
               filename (optional). This field respects the same syntax/resolution as described here: https://git-scm.com/docs/gitrevisions
               If unspecified, the revision from which the trigger invocation originated is assumed to be the revision from which to read the specified path.
        :param str uri: The URI of the repo (required).
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "repo_type", repo_type)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path at which to mount the volume.
        Paths must be absolute and cannot conflict with other volume paths on the same
        build step or with certain reserved volume paths.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> str:
        """
        The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
        Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET_SERVER
        Possible values are `UNKNOWN`, `CLOUD_SOURCE_REPOSITORIES`, `GITHUB`, and `BITBUCKET_SERVER`.
        """
        return pulumi.get(self, "repo_type")

    @property
    @pulumi.getter
    def revision(self) -> Optional[str]:
        """
        The branch, tag, arbitrary ref, or SHA version of the repo to use when resolving the
        filename (optional). This field respects the same syntax/resolution as described here: https://git-scm.com/docs/gitrevisions
        If unspecified, the revision from which the trigger invocation originated is assumed to be the revision from which to read the specified path.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter
    def uri(self) -> Optional[str]:
        """
        The URI of the repo (required).
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class TriggerGithub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pullRequest":
            suggest = "pull_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerGithub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerGithub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerGithub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 owner: Optional[str] = None,
                 pull_request: Optional['outputs.TriggerGithubPullRequest'] = None,
                 push: Optional['outputs.TriggerGithubPush'] = None):
        """
        :param str name: Name of the volume to mount.
               Volume names must be unique per build step and must be valid names for Docker volumes.
               Each named volume must be used by at least two build steps.
        :param str owner: Owner of the repository. For example: The owner for
               https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".
        :param 'TriggerGithubPullRequestArgs' pull_request: filter to match changes in pull requests. Specify only one of `pull_request` or `push`.
               Structure is documented below.
        :param 'TriggerGithubPushArgs' push: filter to match changes in refs, like branches or tags. Specify only one of `pull_request` or `push`.
               Structure is documented below.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if pull_request is not None:
            pulumi.set(__self__, "pull_request", pull_request)
        if push is not None:
            pulumi.set(__self__, "push", push)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the volume to mount.
        Volume names must be unique per build step and must be valid names for Docker volumes.
        Each named volume must be used by at least two build steps.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> Optional[str]:
        """
        Owner of the repository. For example: The owner for
        https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="pullRequest")
    def pull_request(self) -> Optional['outputs.TriggerGithubPullRequest']:
        """
        filter to match changes in pull requests. Specify only one of `pull_request` or `push`.
        Structure is documented below.
        """
        return pulumi.get(self, "pull_request")

    @property
    @pulumi.getter
    def push(self) -> Optional['outputs.TriggerGithubPush']:
        """
        filter to match changes in refs, like branches or tags. Specify only one of `pull_request` or `push`.
        Structure is documented below.
        """
        return pulumi.get(self, "push")


@pulumi.output_type
class TriggerGithubPullRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commentControl":
            suggest = "comment_control"
        elif key == "invertRegex":
            suggest = "invert_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerGithubPullRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerGithubPullRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerGithubPullRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: str,
                 comment_control: Optional[str] = None,
                 invert_regex: Optional[bool] = None):
        """
        :param str branch: Regex of branches to match.  Specify only one of branch or tag.
        :param str comment_control: Whether to block builds on a "/gcbrun" comment from a repository owner or collaborator.
               Possible values are `COMMENTS_DISABLED`, `COMMENTS_ENABLED`, and `COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY`.
        :param bool invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        """
        pulumi.set(__self__, "branch", branch)
        if comment_control is not None:
            pulumi.set(__self__, "comment_control", comment_control)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)

    @property
    @pulumi.getter
    def branch(self) -> str:
        """
        Regex of branches to match.  Specify only one of branch or tag.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="commentControl")
    def comment_control(self) -> Optional[str]:
        """
        Whether to block builds on a "/gcbrun" comment from a repository owner or collaborator.
        Possible values are `COMMENTS_DISABLED`, `COMMENTS_ENABLED`, and `COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY`.
        """
        return pulumi.get(self, "comment_control")

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[bool]:
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")


@pulumi.output_type
class TriggerGithubPush(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "invertRegex":
            suggest = "invert_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerGithubPush. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerGithubPush.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerGithubPush.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 invert_regex: Optional[bool] = None,
                 tag: Optional[str] = None):
        """
        :param str branch: Regex of branches to match.  Specify only one of branch or tag.
        :param bool invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        :param str tag: Regex of tags to match.  Specify only one of branch or tag.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        Regex of branches to match.  Specify only one of branch or tag.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[bool]:
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        Regex of tags to match.  Specify only one of branch or tag.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class TriggerPubsubConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccountEmail":
            suggest = "service_account_email"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerPubsubConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerPubsubConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerPubsubConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 topic: str,
                 service_account_email: Optional[str] = None,
                 state: Optional[str] = None,
                 subscription: Optional[str] = None):
        """
        :param str topic: The name of the topic from which this subscription is receiving messages.
        :param str service_account_email: Service account that will make the push request.
        :param str state: -
               Potential issues with the underlying Pub/Sub subscription configuration.
               Only populated on get requests.
        :param str subscription: -
               Output only. Name of the subscription.
        """
        pulumi.set(__self__, "topic", topic)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subscription is not None:
            pulumi.set(__self__, "subscription", subscription)

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The name of the topic from which this subscription is receiving messages.
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[str]:
        """
        Service account that will make the push request.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        -
        Potential issues with the underlying Pub/Sub subscription configuration.
        Only populated on get requests.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def subscription(self) -> Optional[str]:
        """
        -
        Output only. Name of the subscription.
        """
        return pulumi.get(self, "subscription")


@pulumi.output_type
class TriggerSourceToBuild(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoType":
            suggest = "repo_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerSourceToBuild. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerSourceToBuild.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerSourceToBuild.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ref: str,
                 repo_type: str,
                 uri: str):
        """
        :param str ref: The branch or tag to use. Must start with "refs/" (required).
        :param str repo_type: The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
               Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET_SERVER
               Possible values are `UNKNOWN`, `CLOUD_SOURCE_REPOSITORIES`, `GITHUB`, and `BITBUCKET_SERVER`.
        :param str uri: The URI of the repo (required).
        """
        pulumi.set(__self__, "ref", ref)
        pulumi.set(__self__, "repo_type", repo_type)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def ref(self) -> str:
        """
        The branch or tag to use. Must start with "refs/" (required).
        """
        return pulumi.get(self, "ref")

    @property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> str:
        """
        The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
        Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET_SERVER
        Possible values are `UNKNOWN`, `CLOUD_SOURCE_REPOSITORIES`, `GITHUB`, and `BITBUCKET_SERVER`.
        """
        return pulumi.get(self, "repo_type")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        The URI of the repo (required).
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class TriggerTriggerTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "branchName":
            suggest = "branch_name"
        elif key == "commitSha":
            suggest = "commit_sha"
        elif key == "invertRegex":
            suggest = "invert_regex"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "repoName":
            suggest = "repo_name"
        elif key == "tagName":
            suggest = "tag_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerTriggerTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerTriggerTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerTriggerTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch_name: Optional[str] = None,
                 commit_sha: Optional[str] = None,
                 dir: Optional[str] = None,
                 invert_regex: Optional[bool] = None,
                 project_id: Optional[str] = None,
                 repo_name: Optional[str] = None,
                 tag_name: Optional[str] = None):
        """
        :param str branch_name: Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided.
               The syntax of the regular expressions accepted is the syntax accepted by RE2 and
               described at https://github.com/google/re2/wiki/Syntax
        :param str commit_sha: Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        :param str dir: Working directory to use when running this step's container.
               If this value is a relative path, it is relative to the build's working
               directory. If this value is absolute, it may be outside the build's working
               directory, in which case the contents of the path may not be persisted
               across build step executions, unless a `volume` for that path is specified.
               If the build specifies a `RepoSource` with `dir` and a step with a
               `dir`,
               which specifies an absolute path, the `RepoSource` `dir` is ignored
               for the step's execution.
        :param bool invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        :param str project_id: ID of the project that owns the Cloud Source Repository.
               If omitted, the project ID requesting the build is assumed.
        :param str repo_name: Name of the Cloud Source Repository.
        :param str tag_name: Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided.
               The syntax of the regular expressions accepted is the syntax accepted by RE2 and
               described at https://github.com/google/re2/wiki/Syntax
        """
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if commit_sha is not None:
            pulumi.set(__self__, "commit_sha", commit_sha)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if repo_name is not None:
            pulumi.set(__self__, "repo_name", repo_name)
        if tag_name is not None:
            pulumi.set(__self__, "tag_name", tag_name)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[str]:
        """
        Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and
        described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch_name")

    @property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> Optional[str]:
        """
        Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        """
        return pulumi.get(self, "commit_sha")

    @property
    @pulumi.getter
    def dir(self) -> Optional[str]:
        """
        Working directory to use when running this step's container.
        If this value is a relative path, it is relative to the build's working
        directory. If this value is absolute, it may be outside the build's working
        directory, in which case the contents of the path may not be persisted
        across build step executions, unless a `volume` for that path is specified.
        If the build specifies a `RepoSource` with `dir` and a step with a
        `dir`,
        which specifies an absolute path, the `RepoSource` `dir` is ignored
        for the step's execution.
        """
        return pulumi.get(self, "dir")

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[bool]:
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        ID of the project that owns the Cloud Source Repository.
        If omitted, the project ID requesting the build is assumed.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> Optional[str]:
        """
        Name of the Cloud Source Repository.
        """
        return pulumi.get(self, "repo_name")

    @property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[str]:
        """
        Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and
        described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "tag_name")


@pulumi.output_type
class TriggerWebhookConfig(dict):
    def __init__(__self__, *,
                 secret: str,
                 state: Optional[str] = None):
        """
        :param str secret: Secrets to decrypt using Cloud Key Management Service.
               Structure is documented below.
        :param str state: -
               Potential issues with the underlying Pub/Sub subscription configuration.
               Only populated on get requests.
        """
        pulumi.set(__self__, "secret", secret)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        Secrets to decrypt using Cloud Key Management Service.
        Structure is documented below.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        -
        Potential issues with the underlying Pub/Sub subscription configuration.
        Only populated on get requests.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class WorkerPoolNetworkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "peeredNetwork":
            suggest = "peered_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerPoolNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerPoolNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerPoolNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 peered_network: str):
        """
        :param str peered_network: Immutable. The network definition that the workers are peered to. If this section is left empty, the workers will be peered to `WorkerPool.project_id` on the service producer network. Must be in the format `projects/{project}/global/networks/{network}`, where `{project}` is a project number, such as `12345`, and `{network}` is the name of a VPC network in the project. See (https://cloud.google.com/cloud-build/docs/custom-workers/set-up-custom-worker-pool-environment#understanding_the_network_configuration_options)
        """
        pulumi.set(__self__, "peered_network", peered_network)

    @property
    @pulumi.getter(name="peeredNetwork")
    def peered_network(self) -> str:
        """
        Immutable. The network definition that the workers are peered to. If this section is left empty, the workers will be peered to `WorkerPool.project_id` on the service producer network. Must be in the format `projects/{project}/global/networks/{network}`, where `{project}` is a project number, such as `12345`, and `{network}` is the name of a VPC network in the project. See (https://cloud.google.com/cloud-build/docs/custom-workers/set-up-custom-worker-pool-environment#understanding_the_network_configuration_options)
        """
        return pulumi.get(self, "peered_network")


@pulumi.output_type
class WorkerPoolWorkerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "noExternalIp":
            suggest = "no_external_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerPoolWorkerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerPoolWorkerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerPoolWorkerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_size_gb: Optional[int] = None,
                 machine_type: Optional[str] = None,
                 no_external_ip: Optional[bool] = None):
        """
        :param int disk_size_gb: Size of the disk attached to the worker, in GB. See (https://cloud.google.com/cloud-build/docs/custom-workers/worker-pool-config-file). Specify a value of up to 1000. If `0` is specified, Cloud Build will use a standard disk size.
        :param str machine_type: Machine type of a worker, such as `n1-standard-1`. See (https://cloud.google.com/cloud-build/docs/custom-workers/worker-pool-config-file). If left blank, Cloud Build will use `n1-standard-1`.
        :param bool no_external_ip: If true, workers are created without any public address, which prevents network egress to public IPs.
        """
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if no_external_ip is not None:
            pulumi.set(__self__, "no_external_ip", no_external_ip)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[int]:
        """
        Size of the disk attached to the worker, in GB. See (https://cloud.google.com/cloud-build/docs/custom-workers/worker-pool-config-file). Specify a value of up to 1000. If `0` is specified, Cloud Build will use a standard disk size.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[str]:
        """
        Machine type of a worker, such as `n1-standard-1`. See (https://cloud.google.com/cloud-build/docs/custom-workers/worker-pool-config-file). If left blank, Cloud Build will use `n1-standard-1`.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter(name="noExternalIp")
    def no_external_ip(self) -> Optional[bool]:
        """
        If true, workers are created without any public address, which prevents network egress to public IPs.
        """
        return pulumi.get(self, "no_external_ip")


