# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'FunctionEventTrigger',
    'FunctionEventTriggerFailurePolicy',
    'FunctionIamBindingCondition',
    'FunctionIamMemberCondition',
    'FunctionSecretEnvironmentVariable',
    'FunctionSecretVolume',
    'FunctionSecretVolumeVersion',
    'FunctionSourceRepository',
    'GetFunctionEventTriggerResult',
    'GetFunctionEventTriggerFailurePolicyResult',
    'GetFunctionSecretEnvironmentVariableResult',
    'GetFunctionSecretVolumeResult',
    'GetFunctionSecretVolumeVersionResult',
    'GetFunctionSourceRepositoryResult',
]

@pulumi.output_type
class FunctionEventTrigger(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventType":
            suggest = "event_type"
        elif key == "failurePolicy":
            suggest = "failure_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionEventTrigger. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionEventTrigger.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionEventTrigger.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_type: str,
                 resource: str,
                 failure_policy: Optional['outputs.FunctionEventTriggerFailurePolicy'] = None):
        """
        :param str event_type: The type of event to observe. For example: `"google.storage.object.finalize"`.
               See the documentation on [calling Cloud Functions](https://cloud.google.com/functions/docs/calling/) for a
               full reference of accepted triggers.
        :param str resource: Required. The name or partial URI of the resource from
               which to observe events. For example, `"myBucket"` or `"projects/my-project/topics/my-topic"`
        :param 'FunctionEventTriggerFailurePolicyArgs' failure_policy: Specifies policy for failed executions. Structure is documented below.
        """
        pulumi.set(__self__, "event_type", event_type)
        pulumi.set(__self__, "resource", resource)
        if failure_policy is not None:
            pulumi.set(__self__, "failure_policy", failure_policy)

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> str:
        """
        The type of event to observe. For example: `"google.storage.object.finalize"`.
        See the documentation on [calling Cloud Functions](https://cloud.google.com/functions/docs/calling/) for a
        full reference of accepted triggers.
        """
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter
    def resource(self) -> str:
        """
        Required. The name or partial URI of the resource from
        which to observe events. For example, `"myBucket"` or `"projects/my-project/topics/my-topic"`
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter(name="failurePolicy")
    def failure_policy(self) -> Optional['outputs.FunctionEventTriggerFailurePolicy']:
        """
        Specifies policy for failed executions. Structure is documented below.
        """
        return pulumi.get(self, "failure_policy")


@pulumi.output_type
class FunctionEventTriggerFailurePolicy(dict):
    def __init__(__self__, *,
                 retry: bool):
        """
        :param bool retry: Whether the function should be retried on failure. Defaults to `false`.
        """
        pulumi.set(__self__, "retry", retry)

    @property
    @pulumi.getter
    def retry(self) -> bool:
        """
        Whether the function should be retried on failure. Defaults to `false`.
        """
        return pulumi.get(self, "retry")


@pulumi.output_type
class FunctionIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class FunctionIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class FunctionSecretEnvironmentVariable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionSecretEnvironmentVariable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionSecretEnvironmentVariable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionSecretEnvironmentVariable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 secret: str,
                 version: str,
                 project_id: Optional[str] = None):
        """
        :param str key: Name of the environment variable.
        :param str secret: ID of the secret in secret manager (not the full resource name).
        :param str version: Version of the secret (version number or the string "latest"). It is preferable to use "latest" version with secret volumes as secret value changes are reflected immediately.
        :param str project_id: Project identifier (due to a known limitation, only project number is supported by this field) of the project that contains the secret. If not set, it will be populated with the function's project, assuming that the secret exists in the same project as of the function.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "version", version)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        ID of the secret in secret manager (not the full resource name).
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Version of the secret (version number or the string "latest"). It is preferable to use "latest" version with secret volumes as secret value changes are reflected immediately.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        Project identifier (due to a known limitation, only project number is supported by this field) of the project that contains the secret. If not set, it will be populated with the function's project, assuming that the secret exists in the same project as of the function.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class FunctionSecretVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionSecretVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionSecretVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionSecretVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: str,
                 secret: str,
                 project_id: Optional[str] = None,
                 versions: Optional[Sequence['outputs.FunctionSecretVolumeVersion']] = None):
        """
        :param str mount_path: The path within the container to mount the secret volume. For example, setting the mount_path as "/etc/secrets" would mount the secret value files under the "/etc/secrets" directory. This directory will also be completely shadowed and unavailable to mount any other secrets. Recommended mount paths: "/etc/secrets" Restricted mount paths: "/cloudsql", "/dev/log", "/pod", "/proc", "/var/log".
        :param str secret: ID of the secret in secret manager (not the full resource name).
        :param str project_id: Project identifier (due to a known limitation, only project number is supported by this field) of the project that contains the secret. If not set, it will be populated with the function's project, assuming that the secret exists in the same project as of the function.
        :param Sequence['FunctionSecretVolumeVersionArgs'] versions: List of secret versions to mount for this secret. If empty, the "latest" version of the secret will be made available in a file named after the secret under the mount point. Structure is documented below.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "secret", secret)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> str:
        """
        The path within the container to mount the secret volume. For example, setting the mount_path as "/etc/secrets" would mount the secret value files under the "/etc/secrets" directory. This directory will also be completely shadowed and unavailable to mount any other secrets. Recommended mount paths: "/etc/secrets" Restricted mount paths: "/cloudsql", "/dev/log", "/pod", "/proc", "/var/log".
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        ID of the secret in secret manager (not the full resource name).
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        Project identifier (due to a known limitation, only project number is supported by this field) of the project that contains the secret. If not set, it will be populated with the function's project, assuming that the secret exists in the same project as of the function.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def versions(self) -> Optional[Sequence['outputs.FunctionSecretVolumeVersion']]:
        """
        List of secret versions to mount for this secret. If empty, the "latest" version of the secret will be made available in a file named after the secret under the mount point. Structure is documented below.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class FunctionSecretVolumeVersion(dict):
    def __init__(__self__, *,
                 path: str,
                 version: str):
        """
        :param str path: Relative path of the file under the mount path where the secret value for this version will be fetched and made available. For example, setting the mount_path as "/etc/secrets" and path as "/secret_foo" would mount the secret value file at "/etc/secrets/secret_foo".
        :param str version: Version of the secret (version number or the string "latest"). It is preferable to use "latest" version with secret volumes as secret value changes are reflected immediately.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Relative path of the file under the mount path where the secret value for this version will be fetched and made available. For example, setting the mount_path as "/etc/secrets" and path as "/secret_foo" would mount the secret value file at "/etc/secrets/secret_foo".
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Version of the secret (version number or the string "latest"). It is preferable to use "latest" version with secret volumes as secret value changes are reflected immediately.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class FunctionSourceRepository(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployedUrl":
            suggest = "deployed_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionSourceRepository. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionSourceRepository.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionSourceRepository.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: str,
                 deployed_url: Optional[str] = None):
        """
        :param str url: The URL pointing to the hosted repository where the function is defined. There are supported Cloud Source Repository URLs in the following formats:
        """
        pulumi.set(__self__, "url", url)
        if deployed_url is not None:
            pulumi.set(__self__, "deployed_url", deployed_url)

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL pointing to the hosted repository where the function is defined. There are supported Cloud Source Repository URLs in the following formats:
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="deployedUrl")
    def deployed_url(self) -> Optional[str]:
        return pulumi.get(self, "deployed_url")


@pulumi.output_type
class GetFunctionEventTriggerResult(dict):
    def __init__(__self__, *,
                 event_type: str,
                 failure_policies: Sequence['outputs.GetFunctionEventTriggerFailurePolicyResult'],
                 resource: str):
        """
        :param str event_type: The type of event to observe. For example: `"google.storage.object.finalize"`.
               See the documentation on [calling Cloud Functions](https://cloud.google.com/functions/docs/calling/)
               for a full reference of accepted triggers.
        :param Sequence['GetFunctionEventTriggerFailurePolicyArgs'] failure_policies: Policy for failed executions. Structure is documented below.
        :param str resource: The name of the resource whose events are being observed, for example, `"myBucket"`
        """
        pulumi.set(__self__, "event_type", event_type)
        pulumi.set(__self__, "failure_policies", failure_policies)
        pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> str:
        """
        The type of event to observe. For example: `"google.storage.object.finalize"`.
        See the documentation on [calling Cloud Functions](https://cloud.google.com/functions/docs/calling/)
        for a full reference of accepted triggers.
        """
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter(name="failurePolicies")
    def failure_policies(self) -> Sequence['outputs.GetFunctionEventTriggerFailurePolicyResult']:
        """
        Policy for failed executions. Structure is documented below.
        """
        return pulumi.get(self, "failure_policies")

    @property
    @pulumi.getter
    def resource(self) -> str:
        """
        The name of the resource whose events are being observed, for example, `"myBucket"`
        """
        return pulumi.get(self, "resource")


@pulumi.output_type
class GetFunctionEventTriggerFailurePolicyResult(dict):
    def __init__(__self__, *,
                 retry: bool):
        """
        :param bool retry: Whether the function should be retried on failure.
        """
        pulumi.set(__self__, "retry", retry)

    @property
    @pulumi.getter
    def retry(self) -> bool:
        """
        Whether the function should be retried on failure.
        """
        return pulumi.get(self, "retry")


@pulumi.output_type
class GetFunctionSecretEnvironmentVariableResult(dict):
    def __init__(__self__, *,
                 key: str,
                 project_id: str,
                 secret: str,
                 version: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def secret(self) -> str:
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def version(self) -> str:
        return pulumi.get(self, "version")


@pulumi.output_type
class GetFunctionSecretVolumeResult(dict):
    def __init__(__self__, *,
                 mount_path: str,
                 project_id: str,
                 secret: str,
                 versions: Sequence['outputs.GetFunctionSecretVolumeVersionResult']):
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> str:
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def secret(self) -> str:
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def versions(self) -> Sequence['outputs.GetFunctionSecretVolumeVersionResult']:
        return pulumi.get(self, "versions")


@pulumi.output_type
class GetFunctionSecretVolumeVersionResult(dict):
    def __init__(__self__, *,
                 path: str,
                 version: str):
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def path(self) -> str:
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def version(self) -> str:
        return pulumi.get(self, "version")


@pulumi.output_type
class GetFunctionSourceRepositoryResult(dict):
    def __init__(__self__, *,
                 deployed_url: str,
                 url: str):
        """
        :param str url: The URL pointing to the hosted repository where the function is defined.
        """
        pulumi.set(__self__, "deployed_url", deployed_url)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="deployedUrl")
    def deployed_url(self) -> str:
        return pulumi.get(self, "deployed_url")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL pointing to the hosted repository where the function is defined.
        """
        return pulumi.get(self, "url")


